<?php

if ( ! function_exists( 'gastrobar_edge_map_post_video_meta' ) ) {
	function gastrobar_edge_map_post_video_meta() {
		$video_post_format_meta_box = gastrobar_edge_create_meta_box(
			array(
				'scope' => array( 'post' ),
				'title' => esc_html__( 'Video Post Format', 'gastrobar' ),
				'name'  => 'post_format_video_meta'
			)
		);
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_video_type_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Video Type', 'gastrobar' ),
				'description'   => esc_html__( 'Choose video type', 'gastrobar' ),
				'parent'        => $video_post_format_meta_box,
				'default_value' => 'social_networks',
				'options'       => array(
					'social_networks' => esc_html__( 'Video Service', 'gastrobar' ),
					'self'            => esc_html__( 'Self Hosted', 'gastrobar' )
				),
				'args'          => array(
					'dependence' => true,
					'hide'       => array(
						'social_networks' => '#edgtf_edgtf_video_self_hosted_container',
						'self'            => '#edgtf_edgtf_video_embedded_container'
					),
					'show'       => array(
						'social_networks' => '#edgtf_edgtf_video_embedded_container',
						'self'            => '#edgtf_edgtf_video_self_hosted_container'
					)
				)
			)
		);
		
		$edgtf_video_embedded_container = gastrobar_edge_add_admin_container(
			array(
				'parent'          => $video_post_format_meta_box,
				'name'            => 'edgtf_video_embedded_container',
				'hidden_property' => 'edgtf_video_type_meta',
				'hidden_value'    => 'self'
			)
		);
		
		$edgtf_video_self_hosted_container = gastrobar_edge_add_admin_container(
			array(
				'parent'          => $video_post_format_meta_box,
				'name'            => 'edgtf_video_self_hosted_container',
				'hidden_property' => 'edgtf_video_type_meta',
				'hidden_value'    => 'social_networks'
			)
		);
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_post_video_link_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Video URL', 'gastrobar' ),
				'description' => esc_html__( 'Enter Video URL', 'gastrobar' ),
				'parent'      => $edgtf_video_embedded_container,
			)
		);
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_post_video_custom_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Video MP4', 'gastrobar' ),
				'description' => esc_html__( 'Enter video URL for MP4 format', 'gastrobar' ),
				'parent'      => $edgtf_video_self_hosted_container,
			)
		);
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_post_video_image_meta',
				'type'        => 'image',
				'label'       => esc_html__( 'Video Image', 'gastrobar' ),
				'description' => esc_html__( 'Enter video image', 'gastrobar' ),
				'parent'      => $edgtf_video_self_hosted_container,
			)
		);
	}
	
	add_action( 'gastrobar_edge_action_meta_boxes_map', 'gastrobar_edge_map_post_video_meta', 22 );
}