<?php

/*** Post Settings ***/

if ( ! function_exists( 'gastrobar_edge_map_post_meta' ) ) {
	function gastrobar_edge_map_post_meta() {
		
		$post_meta_box = gastrobar_edge_create_meta_box(
			array(
				'scope' => array( 'post' ),
				'title' => esc_html__( 'Post', 'gastrobar' ),
				'name'  => 'post-meta'
			)
		);
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_blog_single_sidebar_layout_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Sidebar Layout', 'gastrobar' ),
				'description'   => esc_html__( 'Choose a sidebar layout for Blog single page', 'gastrobar' ),
				'default_value' => '',
				'parent'        => $post_meta_box,
                'options'       => gastrobar_edge_get_custom_sidebars_options( true )
			)
		);
		
		$gastrobar_custom_sidebars = gastrobar_edge_get_custom_sidebars();
		if ( is_array( $gastrobar_custom_sidebars ) && count( $gastrobar_custom_sidebars ) > 0 ) {
			gastrobar_edge_create_meta_box_field( array(
				'name'        => 'edgtf_blog_single_custom_sidebar_area_meta',
				'type'        => 'selectblank',
				'label'       => esc_html__( 'Sidebar to Display', 'gastrobar' ),
				'description' => esc_html__( 'Choose a sidebar to display on Blog single page. Default sidebar is "Sidebar"', 'gastrobar' ),
				'parent'      => $post_meta_box,
				'options'     => gastrobar_edge_get_custom_sidebars(),
				'args' => array(
					'select2' => true
				)
			) );
		}
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_blog_list_featured_image_meta',
				'type'        => 'image',
				'label'       => esc_html__( 'Blog List Image', 'gastrobar' ),
				'description' => esc_html__( 'Choose an Image for displaying in blog list. If not uploaded, featured image will be shown.', 'gastrobar' ),
				'parent'      => $post_meta_box
			)
		);
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_blog_masonry_gallery_fixed_dimensions_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Dimensions for Fixed Proportion', 'gastrobar' ),
				'description'   => esc_html__( 'Choose image layout when it appears in Masonry lists in fixed proportion', 'gastrobar' ),
				'default_value' => 'default',
				'parent'        => $post_meta_box,
				'options'       => array(
					'default'            => esc_html__( 'Default', 'gastrobar' ),
					'large-width'        => esc_html__( 'Large Width', 'gastrobar' ),
					'large-height'       => esc_html__( 'Large Height', 'gastrobar' ),
					'large-width-height' => esc_html__( 'Large Width/Height', 'gastrobar' )
				)
			)
		);
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_blog_masonry_gallery_original_dimensions_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Dimensions for Original Proportion', 'gastrobar' ),
				'description'   => esc_html__( 'Choose image layout when it appears in Masonry lists in original proportion', 'gastrobar' ),
				'default_value' => 'default',
				'parent'        => $post_meta_box,
				'options'       => array(
					'default'     => esc_html__( 'Default', 'gastrobar' ),
					'large-width' => esc_html__( 'Large Width', 'gastrobar' )
				)
			)
		);
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_show_title_area_blog_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Show Title Area', 'gastrobar' ),
				'description'   => esc_html__( 'Enabling this option will show title area on your single post page', 'gastrobar' ),
				'parent'        => $post_meta_box,
				'options'       => gastrobar_edge_get_yes_no_select_array()
			)
		);

		do_action('gastrobar_edge_action_blog_post_meta', $post_meta_box);
	}
	
	add_action( 'gastrobar_edge_action_meta_boxes_map', 'gastrobar_edge_map_post_meta', 20 );
}
