<?php
$blog_single_navigation = gastrobar_edge_options()->getOptionValue('blog_single_navigation') === 'no' ? false : true;
$blog_navigation_through_same_category = gastrobar_edge_options()->getOptionValue('blog_navigation_through_same_category') === 'no' ? false : true;
?>
<?php if($blog_single_navigation){ ?>
	<div class="edgtf-blog-single-navigation">
		<div class="edgtf-blog-single-navigation-inner clearfix">
			<?php
			/* Single navigation section - SETTING PARAMS */
			$post_navigation = array(
				'prev' => array(),
				'next' => array()
			);

			if(get_previous_post() !== ""){
				if($blog_navigation_through_same_category){
					if(get_previous_post(true) !== ""){
						$post = get_previous_post(true);
						$post_navigation['prev']['post']  = $post;
						$post_navigation['prev']['label'] = get_the_title($post->ID);
					}
				} else {
					if(get_previous_post() != ""){
						$post = get_previous_post();
						$post_navigation['prev']['post']  = $post;
						$post_navigation['prev']['label'] = get_the_title($post->ID);
					}
				}
			}
			if(get_next_post() != ""){
				if($blog_navigation_through_same_category){
					if(get_next_post(true) !== ""){
						$post = get_next_post(true);
						$post_navigation['next']['post']  = $post;
						$post_navigation['next']['label'] = get_the_title($post->ID);
					}
				} else {
					if(get_next_post() !== ""){
						$post = get_next_post();
						$post_navigation['next']['post']  = $post;
						$post_navigation['next']['label'] = get_the_title($post->ID);
					}
				}
			}

			/* Single navigation section - RENDERING */
			if (isset($post_navigation['prev']['post']) || isset($post_navigation['next']['post'])) { ?>
                <div class="edgtf-blog-single-prev-holder clearfix">
				    <?php if (isset($post_navigation['prev']['post'])) { ?>
						<div class="edgtf-blog-single-wrap-inner">
							<?php if( has_post_thumbnail($post_navigation['prev']['post']->ID) ) { ?>
								<div class="edgtf-blog-single-thumb-wrapper">
									<a itemprop="url" class="edgtf-blog-single-nav-thumb" href="<?php echo get_permalink($post_navigation['prev']['post']->ID); ?>">
										<?php echo get_the_post_thumbnail($post_navigation['prev']['post']->ID, 'thumbnail'); ?>
									</a>
								</div>
							<?php } ?>
							<div class="edgtf-blog-single-nav-wrapper">
								<a itemprop="url" class="edgtf-blog-single-prev edgtf-blog-nav-title" href="<?php echo get_permalink($post_navigation['prev']['post']->ID); ?>">
									<?php echo wp_kses($post_navigation['prev']['label'], array('span' => array('class' => true))); ?>
								</a>
								<span class="edgtf-arrow-holder">
									<?php echo gastrobar_edge_icon_collections()->renderIcon('arrow_left', 'font_elegant'); ?>
									<span class="edgtf-arrow-text"><?php esc_html_e('Previous', 'gastrobar'); ?></span>
								</span>
							</div>
						</div>
				    <?php } ?>
                </div>

				<?php gastrobar_edge_get_module_template_part('templates/parts/post-info/share', 'blog', '', $params); ?>

                <div  class="edgtf-blog-single-next-holder clearfix">
				    <?php if (isset($post_navigation['next']['post'])) { ?>
						<div class="edgtf-blog-single-wrap-inner">
							<div class="edgtf-blog-single-nav-wrapper">
								<a itemprop="url" class="edgtf-blog-single-next edgtf-blog-nav-title" href="<?php echo get_permalink($post_navigation['next']['post']->ID); ?>">
									<?php echo wp_kses($post_navigation['next']['label'], array('span' => array('class' => true))); ?>
								</a>
								<span class="edgtf-arrow-holder">
									<span class="edgtf-arrow-text"><?php esc_html_e('Next', 'gastrobar'); ?></span>
									<?php echo gastrobar_edge_icon_collections()->renderIcon('arrow_right', 'font_elegant'); ?>
								</span>
							</div>
							<?php if( has_post_thumbnail($post_navigation['next']['post']->ID) ) { ?>
								<div class="edgtf-blog-single-thumb-wrapper">
									<a itemprop="url" class="edgtf-blog-single-nav-thumb" href="<?php echo get_permalink($post_navigation['next']['post']->ID); ?>">
										<?php echo get_the_post_thumbnail($post_navigation['next']['post']->ID, 'thumbnail'); ?>
									</a>
								</div>
							<?php } ?>
						</div>
				    <?php } ?>
                </div>
			<?php }	?>
		</div>
	</div>
<?php } ?>