<?php

if ( ! function_exists( 'gastrobar_edge_map_footer_meta' ) ) {
	function gastrobar_edge_map_footer_meta() {
		
		$footer_meta_box = gastrobar_edge_create_meta_box(
			array(
				'scope' => apply_filters( 'gastrobar_edge_filter_set_scope_for_meta_boxes', array( 'page', 'post' ), 'footer_meta' ),
				'title' => esc_html__( 'Footer', 'gastrobar' ),
				'name'  => 'footer_meta'
			)
		);
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_disable_footer_meta',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Disable Footer for this Page', 'gastrobar' ),
				'description'   => esc_html__( 'Enabling this option will hide footer on this page', 'gastrobar' ),
				'parent'        => $footer_meta_box
			)
		);
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_show_footer_top_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Show Footer Top', 'gastrobar' ),
				'description'   => esc_html__( 'Enabling this option will show Footer Top area', 'gastrobar' ),
				'parent'        => $footer_meta_box,
				'options'       => gastrobar_edge_get_yes_no_select_array()
			)
		);

        gastrobar_edge_create_meta_box_field(
            array(
                'name'        => 'edgtf_footer_top_background_pattern_meta',
                'type'        => 'image',
                'label'       => esc_html__( 'Background Pattern', 'gastrobar' ),
                'description' => esc_html__( 'Set background pattern for top footer area', 'gastrobar' ),
                'parent'      => $footer_meta_box
            )
        );
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_show_footer_bottom_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Show Footer Bottom', 'gastrobar' ),
				'description'   => esc_html__( 'Enabling this option will show Footer Bottom area', 'gastrobar' ),
				'parent'        => $footer_meta_box,
				'options'       => gastrobar_edge_get_yes_no_select_array()
			)
		);
	}
	
	add_action( 'gastrobar_edge_action_meta_boxes_map', 'gastrobar_edge_map_footer_meta', 70 );
}