<?php

if ( ! function_exists( 'gastrobar_edge_footer_options_map' ) ) {
	function gastrobar_edge_footer_options_map() {
		
		gastrobar_edge_add_admin_page(
			array(
				'slug'  => '_footer_page',
				'title' => esc_html__( 'Footer', 'gastrobar' ),
				'icon'  => 'fa fa-sort-amount-asc'
			)
		);
		
		$footer_panel = gastrobar_edge_add_admin_panel(
			array(
				'title' => esc_html__( 'Footer', 'gastrobar' ),
				'name'  => 'footer',
				'page'  => '_footer_page'
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'footer_in_grid',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Footer in Grid', 'gastrobar' ),
				'description'   => esc_html__( 'Enabling this option will place Footer content in grid', 'gastrobar' ),
				'parent'        => $footer_panel,
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'show_footer_top',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Show Footer Top', 'gastrobar' ),
				'description'   => esc_html__( 'Enabling this option will show Footer Top area', 'gastrobar' ),
				'args'          => array(
					'dependence'             => true,
					'dependence_hide_on_yes' => '',
					'dependence_show_on_yes' => '#edgtf_show_footer_top_container'
				),
				'parent'        => $footer_panel,
			)
		);
		
		$show_footer_top_container = gastrobar_edge_add_admin_container(
			array(
				'name'            => 'show_footer_top_container',
				'hidden_property' => 'show_footer_top',
				'hidden_value'    => 'no',
				'parent'          => $footer_panel
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'footer_top_columns',
				'parent'        => $show_footer_top_container,
				'default_value' => '4',
				'label'         => esc_html__( 'Footer Top Columns', 'gastrobar' ),
				'description'   => esc_html__( 'Choose number of columns for Footer Top area', 'gastrobar' ),
				'options'       => array(
					'1' => '1',
					'2' => '2',
					'3' => '3',
					'4' => '4'
				)
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'footer_top_columns_alignment',
				'default_value' => 'left',
				'label'         => esc_html__( 'Footer Top Columns Alignment', 'gastrobar' ),
				'description'   => esc_html__( 'Text Alignment in Footer Columns', 'gastrobar' ),
				'options'       => array(
					''       => esc_html__( 'Default', 'gastrobar' ),
					'left'   => esc_html__( 'Left', 'gastrobar' ),
					'center' => esc_html__( 'Center', 'gastrobar' ),
					'right'  => esc_html__( 'Right', 'gastrobar' )
				),
				'parent'        => $show_footer_top_container,
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'name'        => 'footer_top_background_color',
				'type'        => 'color',
				'label'       => esc_html__( 'Background Color', 'gastrobar' ),
				'description' => esc_html__( 'Set background color for top footer area', 'gastrobar' ),
				'parent'      => $show_footer_top_container
			)
		);

        gastrobar_edge_add_admin_field(
            array(
                'name'        => 'footer_top_background_pattern',
                'type'        => 'image',
                'label'       => esc_html__( 'Background pattern', 'gastrobar' ),
                'description' => esc_html__( 'Set background pattern for top footer area', 'gastrobar' ),
                'parent'      => $show_footer_top_container
            )
        );
		
		gastrobar_edge_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'show_footer_bottom',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Show Footer Bottom', 'gastrobar' ),
				'description'   => esc_html__( 'Enabling this option will show Footer Bottom area', 'gastrobar' ),
				'args'          => array(
					'dependence'             => true,
					'dependence_hide_on_yes' => '',
					'dependence_show_on_yes' => '#edgtf_show_footer_bottom_container'
				),
				'parent'        => $footer_panel,
			)
		);
		
		$show_footer_bottom_container = gastrobar_edge_add_admin_container(
			array(
				'name'            => 'show_footer_bottom_container',
				'hidden_property' => 'show_footer_bottom',
				'hidden_value'    => 'no',
				'parent'          => $footer_panel
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'footer_bottom_columns',
				'default_value' => '3',
				'label'         => esc_html__( 'Footer Bottom Columns', 'gastrobar' ),
				'description'   => esc_html__( 'Choose number of columns for Footer Bottom area', 'gastrobar' ),
				'options'       => array(
					'1' => '1',
					'2' => '2',
					'3' => '3'
				),
				'parent'        => $show_footer_bottom_container,
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'name'        => 'footer_bottom_background_color',
				'type'        => 'color',
				'label'       => esc_html__( 'Background Color', 'gastrobar' ),
				'description' => esc_html__( 'Set background color for bottom footer area', 'gastrobar' ),
				'parent'      => $show_footer_bottom_container
			)
		);
	}
	
	add_action( 'gastrobar_edge_action_options_map', 'gastrobar_edge_footer_options_map', 11 );
}