<?php

if ( ! function_exists( 'gastrobar_edge_get_hide_dep_for_header_menu_area_meta_boxes' ) ) {
	function gastrobar_edge_get_hide_dep_for_header_menu_area_meta_boxes() {
		$hide_dep_options = apply_filters( 'gastrobar_edge_filter_header_menu_area_hide_meta_boxes', $hide_dep_options = array() );
		
		return $hide_dep_options;
	}
}

if ( ! function_exists( 'gastrobar_edge_header_menu_area_meta_options_map' ) ) {
	function gastrobar_edge_header_menu_area_meta_options_map( $header_meta_box ) {
		$hide_dep_options = gastrobar_edge_get_hide_dep_for_header_menu_area_meta_boxes();
		
		$menu_area_container = gastrobar_edge_add_admin_container_no_style(
			array(
				'type'            => 'container',
				'name'            => 'menu_area_container',
				'parent'          => $header_meta_box,
				'hidden_property' => 'edgtf_header_type_meta',
				'hidden_values'   => $hide_dep_options,
				'args'            => array(
					'enable_panels_for_default_value' => true
				)
			)
		);
		
		gastrobar_edge_add_admin_section_title(
			array(
				'parent' => $menu_area_container,
				'name'   => 'menu_area_style',
				'title'  => esc_html__( 'Menu Area Style', 'gastrobar' )
			)
		);
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_disable_header_widget_menu_area_meta',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Disable Header Menu Area Widget', 'gastrobar' ),
				'description'   => esc_html__( 'Enabling this option will hide widget area from the menu area', 'gastrobar' ),
				'parent'        => $menu_area_container
			)
		);
		
		$gastrobar_custom_sidebars = gastrobar_edge_get_custom_sidebars();
		if ( is_array( $gastrobar_custom_sidebars ) && count( $gastrobar_custom_sidebars ) > 0 ) {
			gastrobar_edge_create_meta_box_field(
				array(
					'name'        => 'edgtf_custom_menu_area_sidebar_meta',
					'type'        => 'selectblank',
					'label'       => esc_html__( 'Choose Custom Widget Area In Menu Area', 'gastrobar' ),
					'description' => esc_html__( 'Choose custom widget area to display in header menu area"', 'gastrobar' ),
					'parent'      => $menu_area_container,
					'options'     => $gastrobar_custom_sidebars
				)
			);
		}

        gastrobar_edge_create_meta_box_field(
            array(
                'name'          => 'edgtf_disable_divided_left_widget_area_meta',
                'type'          => 'yesno',
                'default_value' => 'no',
                'label'         => esc_html__( 'Disable Header Divided Left Widget Area', 'gastrobar' ),
                'description'   => esc_html__( 'Enabling this option will hide Header Divided Left widget area from the left menu area', 'gastrobar' ),
                'parent'        => $menu_area_container
            )
        );

        $gastrobar_custom_sidebars = gastrobar_edge_get_custom_sidebars();
        if ( is_array( $gastrobar_custom_sidebars ) && count( $gastrobar_custom_sidebars ) > 0 ) {
            gastrobar_edge_create_meta_box_field(
                array(
                    'name'        => 'edgtf_custom_divided_left_area_sidebar_meta',
                    'type'        => 'selectblank',
                    'label'       => esc_html__( 'Choose Custom Widget Area In Divided Left Widget Area', 'gastrobar' ),
                    'description' => esc_html__( 'Choose custom widget area to display in Divided Left Widget Area"', 'gastrobar' ),
                    'parent'      => $menu_area_container,
                    'options'     => $gastrobar_custom_sidebars
                )
            );
        }

        gastrobar_edge_create_meta_box_field(
            array(
                'name'          => 'edgtf_disable_divided_right_widget_area_meta',
                'type'          => 'yesno',
                'default_value' => 'no',
                'label'         => esc_html__( 'Disable Header Divided Right Widget Area', 'gastrobar' ),
                'description'   => esc_html__( 'Enabling this option will hide Header Divided Right widget area from the right menu area', 'gastrobar' ),
                'parent'        => $menu_area_container
            )
        );

        $gastrobar_custom_sidebars = gastrobar_edge_get_custom_sidebars();
        if ( is_array( $gastrobar_custom_sidebars ) && count( $gastrobar_custom_sidebars ) > 0 ) {
            gastrobar_edge_create_meta_box_field(
                array(
                    'name'        => 'edgtf_custom_divided_right_area_sidebar_meta',
                    'type'        => 'selectblank',
                    'label'       => esc_html__( 'Choose Custom Widget Area In Divided Right Widget Area', 'gastrobar' ),
                    'description' => esc_html__( 'Choose custom widget area to display in Divided Right Widget Area"', 'gastrobar' ),
                    'parent'      => $menu_area_container,
                    'options'     => $gastrobar_custom_sidebars
                )
            );
        }
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_menu_area_in_grid_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Menu Area In Grid', 'gastrobar' ),
				'description'   => esc_html__( 'Set menu area content to be in grid', 'gastrobar' ),
				'parent'        => $menu_area_container,
				'default_value' => '',
				'options'       => gastrobar_edge_get_yes_no_select_array(),
				'args'          => array(
					'dependence' => true,
					'hide'       => array(
						''    => '#edgtf_menu_area_in_grid_container',
						'no'  => '#edgtf_menu_area_in_grid_container',
						'yes' => ''
					),
					'show'       => array(
						''    => '',
						'no'  => '',
						'yes' => '#edgtf_menu_area_in_grid_container'
					)
				)
			)
		);
		
		$menu_area_in_grid_container = gastrobar_edge_add_admin_container(
			array(
				'type'            => 'container',
				'name'            => 'menu_area_in_grid_container',
				'parent'          => $menu_area_container,
				'hidden_property' => 'edgtf_menu_area_in_grid_meta',
				'hidden_value'    => 'no',
				'hidden_values'   => array( '', 'no' )
			)
		);
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_menu_area_grid_background_color_meta',
				'type'        => 'color',
				'label'       => esc_html__( 'Grid Background Color', 'gastrobar' ),
				'description' => esc_html__( 'Set grid background color for menu area', 'gastrobar' ),
				'parent'      => $menu_area_in_grid_container
			)
		);
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_menu_area_grid_background_transparency_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Grid Background Transparency', 'gastrobar' ),
				'description' => esc_html__( 'Set grid background transparency for menu area (0 = fully transparent, 1 = opaque)', 'gastrobar' ),
				'parent'      => $menu_area_in_grid_container,
				'args'        => array(
					'col_width' => 2
				)
			)
		);
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_menu_area_in_grid_shadow_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Grid Area Shadow', 'gastrobar' ),
				'description'   => esc_html__( 'Set shadow on grid menu area', 'gastrobar' ),
				'parent'        => $menu_area_in_grid_container,
				'default_value' => '',
				'options'       => gastrobar_edge_get_yes_no_select_array()
			)
		);
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_menu_area_in_grid_border_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Grid Area Border', 'gastrobar' ),
				'description'   => esc_html__( 'Set border on grid menu area', 'gastrobar' ),
				'parent'        => $menu_area_in_grid_container,
				'default_value' => '',
				'options'       => gastrobar_edge_get_yes_no_select_array(),
				'args'          => array(
					'dependence' => true,
					'hide'       => array(
						''    => '#edgtf_menu_area_in_grid_border_container',
						'no'  => '#edgtf_menu_area_in_grid_border_container',
						'yes' => ''
					),
					'show'       => array(
						''    => '',
						'no'  => '',
						'yes' => '#edgtf_menu_area_in_grid_border_container'
					)
				)
			)
		);
		
		$menu_area_in_grid_border_container = gastrobar_edge_add_admin_container(
			array(
				'type'            => 'container',
				'name'            => 'menu_area_in_grid_border_container',
				'parent'          => $menu_area_in_grid_container,
				'hidden_property' => 'edgtf_menu_area_in_grid_border_meta',
				'hidden_value'    => 'no',
				'hidden_values'   => array( '', 'no' )
			)
		);
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_menu_area_in_grid_border_color_meta',
				'type'        => 'color',
				'label'       => esc_html__( 'Border Color', 'gastrobar' ),
				'description' => esc_html__( 'Set border color for grid area', 'gastrobar' ),
				'parent'      => $menu_area_in_grid_border_container
			)
		);
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_menu_area_background_color_meta',
				'type'        => 'color',
				'label'       => esc_html__( 'Background Color', 'gastrobar' ),
				'description' => esc_html__( 'Choose a background color for menu area', 'gastrobar' ),
				'parent'      => $menu_area_container
			)
		);
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_menu_area_background_transparency_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Transparency', 'gastrobar' ),
				'description' => esc_html__( 'Choose a transparency for the menu area background color (0 = fully transparent, 1 = opaque)', 'gastrobar' ),
				'parent'      => $menu_area_container,
				'args'        => array(
					'col_width' => 2
				)
			)
		);
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_menu_area_shadow_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Menu Area Shadow', 'gastrobar' ),
				'description'   => esc_html__( 'Set shadow on menu area', 'gastrobar' ),
				'parent'        => $menu_area_container,
				'default_value' => '',
				'options'       => gastrobar_edge_get_yes_no_select_array()
			)
		);
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_menu_area_border_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Menu Area Border', 'gastrobar' ),
				'description'   => esc_html__( 'Set border on menu area', 'gastrobar' ),
				'parent'        => $menu_area_container,
				'default_value' => '',
				'options'       => gastrobar_edge_get_yes_no_select_array(),
				'args'          => array(
					'dependence' => true,
					'hide'       => array(
						''    => '#edgtf_menu_area_border_bottom_color_container',
						'no'  => '#edgtf_menu_area_border_bottom_color_container',
						'yes' => ''
					),
					'show'       => array(
						''    => '',
						'no'  => '',
						'yes' => '#edgtf_menu_area_border_bottom_color_container'
					)
				)
			)
		);
		
		$menu_area_border_bottom_color_container = gastrobar_edge_add_admin_container(
			array(
				'type'            => 'container',
				'name'            => 'menu_area_border_bottom_color_container',
				'parent'          => $menu_area_container,
				'hidden_property' => 'edgtf_menu_area_border_meta',
				'hidden_value'    => 'no',
				'hidden_values'   => array( '', 'no' )
			)
		);
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_menu_area_border_color_meta',
				'type'        => 'color',
				'label'       => esc_html__( 'Border Color', 'gastrobar' ),
				'description' => esc_html__( 'Choose color of header bottom border', 'gastrobar' ),
				'parent'      => $menu_area_border_bottom_color_container
			)
		);
		
		gastrobar_edge_create_meta_box_field(
			array(
				'parent'        => $menu_area_container,
				'type'          => 'text',
				'name'          => 'edgtf_dropdown_top_position_meta',
				'label'         => esc_html__( 'Dropdown Position', 'gastrobar' ),
				'description'   => esc_html__( 'Enter value in percentage of entire header height', 'gastrobar' ),
				'args'          => array(
					'col_width' => 3,
					'suffix'    => '%'
				)
			)
		);
		
		do_action( 'gastrobar_edge_header_menu_area_additional_meta_boxes_map', $menu_area_container );
	}
	
	add_action( 'gastrobar_edge_action_header_menu_area_meta_boxes_map', 'gastrobar_edge_header_menu_area_meta_options_map', 10, 1 );
}