<?php

if ( ! function_exists( 'gastrobar_edge_get_hide_dep_for_header_centered_meta_boxes' ) ) {
	function gastrobar_edge_get_hide_dep_for_header_centered_meta_boxes() {
		$hide_dep_options = apply_filters( 'gastrobar_edge_filter_header_centered_hide_meta_boxes', $hide_dep_options = array() );
		
		return $hide_dep_options;
	}
}

if ( ! function_exists( 'gastrobar_edge_header_centered_meta_map' ) ) {
	function gastrobar_edge_header_centered_meta_map( $parent ) {
		$hide_dep_options = gastrobar_edge_get_hide_dep_for_header_centered_meta_boxes();
		
		gastrobar_edge_create_meta_box_field(
			array(
				'parent'          => $parent,
				'type'            => 'text',
				'name'            => 'edgtf_logo_wrapper_padding_header_centered_meta',
				'default_value'   => '',
				'label'           => esc_html__( 'Logo Padding', 'gastrobar' ),
				'description'     => esc_html__( 'Insert padding in format: 0px 0px 1px 0px', 'gastrobar' ),
				'args'            => array(
					'col_width' => 3
				),
				'hidden_property' => 'edgtf_header_type_meta',
				'hidden_values'   => $hide_dep_options
			)
		);
	}
	
	add_action( 'gastrobar_edge_action_header_logo_area_additional_meta_boxes_map', 'gastrobar_edge_header_centered_meta_map', 10, 1 );
}