<?php

if ( ! function_exists( 'gastrobar_edge_register_header_centered_type' ) ) {
	/**
	 * This function is used to register header type class for header factory file
	 */
	function gastrobar_edge_register_header_centered_type( $header_types ) {
		$header_type = array(
			'header-centered' => 'GastrobarEdgeNamespace\Modules\Header\Types\HeaderCentered'
		);
		
		$header_types = array_merge( $header_types, $header_type );
		
		return $header_types;
	}
}

if ( ! function_exists( 'gastrobar_edge_init_register_header_centered_type' ) ) {
	/**
	 * This function is used to wait header-function.php file to init header object and then to init hook registration function above
	 */
	function gastrobar_edge_init_register_header_centered_type() {
		add_filter( 'gastrobar_edge_filter_register_header_type_class', 'gastrobar_edge_register_header_centered_type' );
	}
	
	add_action( 'gastrobar_edge_action_before_header_function_init', 'gastrobar_edge_init_register_header_centered_type' );
}

if ( ! function_exists( 'gastrobar_edge_header_centered_per_page_custom_styles' ) ) {
	/**
	 * Return header per page styles
	 */
	function gastrobar_edge_header_centered_per_page_custom_styles( $style, $class_prefix, $page_id ) {
		$header_area_style    = array();
		$header_area_selector = array( $class_prefix . '.edgtf-header-centered .edgtf-logo-area .edgtf-logo-wrapper' );
		
		$logo_area_logo_padding = get_post_meta( $page_id, 'edgtf_logo_wrapper_padding_header_centered_meta', true );
		
		if ( $logo_area_logo_padding !== '' ) {
			$header_area_style['padding'] = $logo_area_logo_padding;
		}
		
		$current_style = '';
		
		if ( ! empty( $header_area_style ) ) {
			$current_style .= gastrobar_edge_dynamic_css( $header_area_selector, $header_area_style );
		}
		
		$current_style = $current_style . $style;
		
		return $current_style;
	}
	
	add_filter( 'gastrobar_edge_filter_add_header_page_custom_style', 'gastrobar_edge_header_centered_per_page_custom_styles', 10, 3 );
}

if ( ! function_exists( 'gastrobar_edge_register_header_centered_widgets' ) ) {
	/**
	 * Registers additional widget areas for this header type
	 */
	function gastrobar_edge_register_header_centered_widgets() {
		register_sidebar(
			array(
				'id'            => 'centered_header_left',
				'name'          => esc_html__( 'Centered Header Left', 'gastrobar' ),
				'description'   => esc_html__( 'This widget area is rendered on the left of the centered header logo area.', 'gastrobar' ),
				'before_widget' => '<div class="%2$s edgtf-centered-menu-left-widget">',
				'after_widget'  => '</div>',
				'before_title'  => '<h5 class="edgtf-widget-title">',
				'after_title'   => '</h5>'
			)
		);

		register_sidebar(
			array(
				'id'            => 'centered_header_right',
				'name'          => esc_html__( 'Centered Header Right', 'gastrobar' ),
				'description'   => esc_html__( 'This widget area is rendered on the right of the centered header logo area.', 'gastrobar' ),
				'before_widget' => '<div class="%2$s edgtf-centered-menu-right-widget">',
				'after_widget'  => '</div>',
				'before_title'  => '<h5 class="edgtf-widget-title">',
				'after_title'   => '</h5>'
			)
		);
	}

	if ( gastrobar_edge_check_is_header_type_enabled( 'header-centered' ) ) {
		add_action( 'widgets_init', 'gastrobar_edge_register_header_centered_widgets' );
	}
}