<?php

if ( ! function_exists( 'gastrobar_edge_set_header_divided_type_global_option' ) ) {
	/**
	 * This function set header type value for global header option map
	 */
	function gastrobar_edge_set_header_divided_type_global_option( $header_types ) {
		$header_types['header-divided'] = array(
			'image' => EDGE_FRAMEWORK_HEADER_TYPES_ROOT . '/header-divided/assets/img/header-divided.png',
			'label' => esc_html__( 'Divided', 'gastrobar' )
		);
		
		return $header_types;
	}
	
	add_filter( 'gastrobar_edge_filter_header_type_global_option', 'gastrobar_edge_set_header_divided_type_global_option' );
}

if ( ! function_exists( 'gastrobar_edge_set_header_divided_type_meta_boxes_option' ) ) {
	/**
	 * This function set header type value for header meta boxes map
	 */
	function gastrobar_edge_set_header_divided_type_meta_boxes_option( $header_type_options ) {
		$header_type_options['header-divided'] = esc_html__( 'Divided', 'gastrobar' );
		
		return $header_type_options;
	}
	
	add_filter( 'gastrobar_edge_filter_header_type_meta_boxes', 'gastrobar_edge_set_header_divided_type_meta_boxes_option' );
}

if ( ! function_exists( 'gastrobar_edge_set_show_dep_options_for_header_divided' ) ) {
	/**
	 * This function set show container values when this header type is selected for header type global option
	 */
	function gastrobar_edge_set_show_dep_options_for_header_divided( $show_dep_options ) {
		$show_containers   = array();
		$show_containers[] = '#edgtf_header_behaviour';
		$show_containers[] = '#edgtf_menu_area_container';
		$show_containers[] = '#edgtf_panel_main_menu';
		$show_containers[] = '#edgtf_panel_sticky_header';
		$show_containers[] = '#edgtf_panel_fixed_header';
		
		$show_containers = apply_filters( 'gastrobar_edge_filter_show_dep_options_for_header_divided', $show_containers );
		
		$show_dep_options['header-divided'] = implode( ',', $show_containers );
		
		return $show_dep_options;
	}
	
	add_filter( 'gastrobar_edge_filter_header_type_show_global_option', 'gastrobar_edge_set_show_dep_options_for_header_divided' );
}

if ( ! function_exists( 'gastrobar_edge_set_hide_dep_options_for_header_divided' ) ) {
	/**
	 * This function set hide container values when this header type is selected for header type global option
	 */
	function gastrobar_edge_set_hide_dep_options_for_header_divided( $hide_dep_options ) {
		$hide_containers   = array();
		$hide_containers[] = '#edgtf_logo_area_container';
		$hide_containers[] = '#edgtf_panel_fullscreen_menu';
		
		$hide_containers = apply_filters( 'gastrobar_edge_filter_hide_dep_options_for_header_divided', $hide_containers );
		
		$hide_dep_options['header-divided'] = implode( ',', $hide_containers );
		
		return $hide_dep_options;
	}
	
	add_filter( 'gastrobar_edge_filter_header_type_hide_global_option', 'gastrobar_edge_set_hide_dep_options_for_header_divided' );
}

if ( ! function_exists( 'gastrobar_edge_set_show_dep_options_for_header_divided_meta_boxes' ) ) {
	/**
	 * This function set show container values when this header type is selected for header type meta boxes map
	 */
	function gastrobar_edge_set_show_dep_options_for_header_divided_meta_boxes( $show_dep_options ) {
		$show_containers   = array();
		$show_containers[] = '#edgtf_menu_area_container';
		
		$show_containers = apply_filters( 'gastrobar_edge_filter_show_dep_options_for_header_divided_meta_boxes', $show_containers );
		
		$show_dep_options['header-divided'] = implode( ',', $show_containers );
		
		return $show_dep_options;
	}
	
	add_filter( 'gastrobar_edge_filter_header_type_show_meta_boxes', 'gastrobar_edge_set_show_dep_options_for_header_divided_meta_boxes' );
}

if ( ! function_exists( 'gastrobar_edge_set_hide_dep_options_for_header_divided_meta_boxes' ) ) {
	/**
	 * This function set hide container values when this header type is selected for header type meta boxes map
	 */
	function gastrobar_edge_set_hide_dep_options_for_header_divided_meta_boxes( $hide_dep_options ) {
		$hide_containers   = array();
		$hide_containers[] = '#edgtf_logo_area_container';
		
		$hide_containers = apply_filters( 'gastrobar_edge_filter_hide_dep_options_for_header_divided_meta_boxes', $hide_containers );
		
		$hide_dep_options['header-divided'] = implode( ',', $hide_containers );
		
		return $hide_dep_options;
	}
	
	add_filter( 'gastrobar_edge_filter_header_type_hide_meta_boxes', 'gastrobar_edge_set_hide_dep_options_for_header_divided_meta_boxes' );
}

if ( ! function_exists( 'gastrobar_edge_set_hide_dep_options_header_divided' ) ) {
	/**
	 * This function is used to hide all containers/panels for admin options when this header type is selected
	 */
	function gastrobar_edge_set_hide_dep_options_header_divided( $hide_dep_options ) {
		$hide_dep_options[] = 'header-divided';
		
		return $hide_dep_options;
	}
	
	// header global panel options
	add_filter( 'gastrobar_edge_filter_header_logo_area_hide_global_option', 'gastrobar_edge_set_hide_dep_options_header_divided' );
	
	// header global panel meta boxes
	add_filter( 'gastrobar_edge_filter_header_logo_area_hide_meta_boxes', 'gastrobar_edge_set_hide_dep_options_header_divided' );
	
	// header types panel options
	add_filter( 'gastrobar_edge_filter_full_screen_menu_hide_global_option', 'gastrobar_edge_set_hide_dep_options_header_divided' );
	add_filter( 'gastrobar_edge_filter_header_centered_hide_global_option', 'gastrobar_edge_set_hide_dep_options_header_divided' );
	add_filter( 'gastrobar_edge_filter_header_standard_hide_global_option', 'gastrobar_edge_set_hide_dep_options_header_divided' );
	add_filter( 'gastrobar_edge_filter_header_vertical_hide_global_option', 'gastrobar_edge_set_hide_dep_options_header_divided' );
	add_filter( 'gastrobar_edge_filter_header_vertical_menu_hide_global_option', 'gastrobar_edge_set_hide_dep_options_header_divided' );
	
	// header types panel meta boxes
	add_filter( 'gastrobar_edge_filter_header_centered_hide_meta_boxes', 'gastrobar_edge_set_hide_dep_options_header_divided' );
	add_filter( 'gastrobar_edge_filter_header_standard_hide_meta_boxes', 'gastrobar_edge_set_hide_dep_options_header_divided' );
	add_filter( 'gastrobar_edge_filter_header_vertical_hide_meta_boxes', 'gastrobar_edge_set_hide_dep_options_header_divided' );
}