<?php

if ( ! function_exists( 'gastrobar_edge_get_hide_dep_for_full_screen_menu_options' ) ) {
	function gastrobar_edge_get_hide_dep_for_full_screen_menu_options() {
		$hide_dep_options = apply_filters( 'gastrobar_edge_filter_full_screen_menu_hide_global_option', $hide_dep_options = array() );
		
		return $hide_dep_options;
	}
}

if ( ! function_exists( 'gastrobar_edge_fullscreen_menu_options_map' ) ) {
	function gastrobar_edge_fullscreen_menu_options_map() {
		$hide_dep_options = gastrobar_edge_get_hide_dep_for_full_screen_menu_options();
		
		$fullscreen_panel = gastrobar_edge_add_admin_panel(
			array(
				'title'           => esc_html__( 'Full Screen Menu', 'gastrobar' ),
				'name'            => 'panel_fullscreen_menu',
				'page'            => '_header_page',
				'hidden_property' => 'header_type',
				'hidden_values'   => $hide_dep_options
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'        => $fullscreen_panel,
				'type'          => 'select',
				'name'          => 'fullscreen_menu_animation_style',
				'default_value' => 'fade-push-text-right',
				'label'         => esc_html__( 'Full Screen Menu Overlay Animation', 'gastrobar' ),
				'description'   => esc_html__( 'Choose animation type for full screen menu overlay', 'gastrobar' ),
				'options'       => array(
					'fade-push-text-right' => esc_html__( 'Fade Push Text Right', 'gastrobar' ),
					'fade-push-text-top'   => esc_html__( 'Fade Push Text Top', 'gastrobar' ),
					'fade-text-scaledown'  => esc_html__( 'Fade Text Scaledown', 'gastrobar' )
				)
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'        => $fullscreen_panel,
				'type'          => 'yesno',
				'name'          => 'fullscreen_in_grid',
				'default_value' => 'no',
				'label'         => esc_html__( 'Full Screen Menu in Grid', 'gastrobar' ),
				'description'   => esc_html__( 'Enabling this option will put full screen menu content in grid', 'gastrobar' ),
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'        => $fullscreen_panel,
				'type'          => 'selectblank',
				'name'          => 'fullscreen_alignment',
				'default_value' => '',
				'label'         => esc_html__( 'Full Screen Menu Alignment', 'gastrobar' ),
				'description'   => esc_html__( 'Choose alignment for full screen menu content', 'gastrobar' ),
				'options'       => array(
					''       => esc_html__( 'Default', 'gastrobar' ),
					'left'   => esc_html__( 'Left', 'gastrobar' ),
					'center' => esc_html__( 'Center', 'gastrobar' ),
					'right'  => esc_html__( 'Right', 'gastrobar' )
				)
			)
		);

        gastrobar_edge_add_admin_field(
            array(
                'parent'        => $fullscreen_panel,
                'type'          => 'selectblank',
                'name'          => 'fullscreen_skin',
                'default_value' => '',
                'label'         => esc_html__( 'Full Screen Menu Skin', 'gastrobar' ),
                'description'   => esc_html__( 'Choose the skin for full screen menu content', 'gastrobar' ),
                'options'       => array(
                    ''       => esc_html__( 'Default', 'gastrobar' ),
                    'light'   => esc_html__( 'Light', 'gastrobar' ),
                )
            )
        );
		
		$background_group = gastrobar_edge_add_admin_group(
			array(
				'parent'      => $fullscreen_panel,
				'name'        => 'background_group',
				'title'       => esc_html__( 'Background', 'gastrobar' ),
				'description' => esc_html__( 'Select a background color and transparency for full screen menu (0 = fully transparent, 1 = opaque)', 'gastrobar' )
			)
		);
		
		$background_group_row = gastrobar_edge_add_admin_row(
			array(
				'parent' => $background_group,
				'name'   => 'background_group_row'
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent' => $background_group_row,
				'type'   => 'colorsimple',
				'name'   => 'fullscreen_menu_background_color',
				'label'  => esc_html__( 'Background Color', 'gastrobar' )
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent' => $background_group_row,
				'type'   => 'textsimple',
				'name'   => 'fullscreen_menu_background_transparency',
				'label'  => esc_html__( 'Background Transparency', 'gastrobar' )
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'      => $fullscreen_panel,
				'type'        => 'image',
				'name'        => 'fullscreen_menu_background_image',
				'label'       => esc_html__( 'Background Image', 'gastrobar' ),
				'description' => esc_html__( 'Choose a background image for full screen menu background', 'gastrobar' )
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'      => $fullscreen_panel,
				'type'        => 'image',
				'name'        => 'fullscreen_menu_pattern_image',
				'label'       => esc_html__( 'Pattern Background Image', 'gastrobar' ),
				'description' => esc_html__( 'Choose a pattern image for full screen menu background', 'gastrobar' )
			)
		);
		
		//1st level style group
		$first_level_style_group = gastrobar_edge_add_admin_group(
			array(
				'parent'      => $fullscreen_panel,
				'name'        => 'first_level_style_group',
				'title'       => esc_html__( '1st Level Style', 'gastrobar' ),
				'description' => esc_html__( 'Define styles for 1st level in full screen menu', 'gastrobar' )
			)
		);
		
		$first_level_style_row1 = gastrobar_edge_add_admin_row(
			array(
				'parent' => $first_level_style_group,
				'name'   => 'first_level_style_row1'
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'        => $first_level_style_row1,
				'type'          => 'colorsimple',
				'name'          => 'fullscreen_menu_color',
				'default_value' => '',
				'label'         => esc_html__( 'Text Color', 'gastrobar' ),
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'        => $first_level_style_row1,
				'type'          => 'colorsimple',
				'name'          => 'fullscreen_menu_hover_color',
				'default_value' => '',
				'label'         => esc_html__( 'Hover Text Color', 'gastrobar' ),
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'        => $first_level_style_row1,
				'type'          => 'colorsimple',
				'name'          => 'fullscreen_menu_active_color',
				'default_value' => '',
				'label'         => esc_html__( 'Active Text Color', 'gastrobar' ),
			)
		);
		
		$first_level_style_row3 = gastrobar_edge_add_admin_row(
			array(
				'parent' => $first_level_style_group,
				'name'   => 'first_level_style_row3'
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'        => $first_level_style_row3,
				'type'          => 'fontsimple',
				'name'          => 'fullscreen_menu_google_fonts',
				'default_value' => '-1',
				'label'         => esc_html__( 'Font Family', 'gastrobar' ),
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'        => $first_level_style_row3,
				'type'          => 'textsimple',
				'name'          => 'fullscreen_menu_font_size',
				'default_value' => '',
				'label'         => esc_html__( 'Font Size', 'gastrobar' ),
				'args'          => array(
					'suffix' => 'px'
				)
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'        => $first_level_style_row3,
				'type'          => 'textsimple',
				'name'          => 'fullscreen_menu_line_height',
				'default_value' => '',
				'label'         => esc_html__( 'Line Height', 'gastrobar' ),
				'args'          => array(
					'suffix' => 'px'
				)
			)
		);
		
		$first_level_style_row4 = gastrobar_edge_add_admin_row(
			array(
				'parent' => $first_level_style_group,
				'name'   => 'first_level_style_row4'
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'        => $first_level_style_row4,
				'type'          => 'selectblanksimple',
				'name'          => 'fullscreen_menu_font_style',
				'default_value' => '',
				'label'         => esc_html__( 'Font Style', 'gastrobar' ),
				'options'       => gastrobar_edge_get_font_style_array()
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'        => $first_level_style_row4,
				'type'          => 'selectblanksimple',
				'name'          => 'fullscreen_menu_font_weight',
				'default_value' => '',
				'label'         => esc_html__( 'Font Weight', 'gastrobar' ),
				'options'       => gastrobar_edge_get_font_weight_array()
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'        => $first_level_style_row4,
				'type'          => 'textsimple',
				'name'          => 'fullscreen_menu_letter_spacing',
				'default_value' => '',
				'label'         => esc_html__( 'Lettert Spacing', 'gastrobar' ),
				'args'          => array(
					'suffix' => 'px'
				)
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'        => $first_level_style_row4,
				'type'          => 'selectblanksimple',
				'name'          => 'fullscreen_menu_text_transform',
				'default_value' => '',
				'label'         => esc_html__( 'Text Transform', 'gastrobar' ),
				'options'       => gastrobar_edge_get_text_transform_array()
			)
		);
		
		//2nd level style group
		$second_level_style_group = gastrobar_edge_add_admin_group(
			array(
				'parent'      => $fullscreen_panel,
				'name'        => 'second_level_style_group',
				'title'       => esc_html__( '2nd Level Style', 'gastrobar' ),
				'description' => esc_html__( 'Define styles for 2nd level in full screen menu', 'gastrobar' )
			)
		);
		
		$second_level_style_row1 = gastrobar_edge_add_admin_row(
			array(
				'parent' => $second_level_style_group,
				'name'   => 'second_level_style_row1'
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'        => $second_level_style_row1,
				'type'          => 'colorsimple',
				'name'          => 'fullscreen_menu_color_2nd',
				'default_value' => '',
				'label'         => esc_html__( 'Text Color', 'gastrobar' ),
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'        => $second_level_style_row1,
				'type'          => 'colorsimple',
				'name'          => 'fullscreen_menu_hover_color_2nd',
				'default_value' => '',
				'label'         => esc_html__( 'Hover/Active Text Color', 'gastrobar' ),
			)
		);
		
		$second_level_style_row2 = gastrobar_edge_add_admin_row(
			array(
				'parent' => $second_level_style_group,
				'name'   => 'second_level_style_row2'
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'        => $second_level_style_row2,
				'type'          => 'fontsimple',
				'name'          => 'fullscreen_menu_google_fonts_2nd',
				'default_value' => '-1',
				'label'         => esc_html__( 'Font Family', 'gastrobar' ),
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'        => $second_level_style_row2,
				'type'          => 'textsimple',
				'name'          => 'fullscreen_menu_font_size_2nd',
				'default_value' => '',
				'label'         => esc_html__( 'Font Size', 'gastrobar' ),
				'args'          => array(
					'suffix' => 'px'
				)
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'        => $second_level_style_row2,
				'type'          => 'textsimple',
				'name'          => 'fullscreen_menu_line_height_2nd',
				'default_value' => '',
				'label'         => esc_html__( 'Line Height', 'gastrobar' ),
				'args'          => array(
					'suffix' => 'px'
				)
			)
		);
		
		$second_level_style_row3 = gastrobar_edge_add_admin_row(
			array(
				'parent' => $second_level_style_group,
				'name'   => 'second_level_style_row3'
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'        => $second_level_style_row3,
				'type'          => 'selectblanksimple',
				'name'          => 'fullscreen_menu_font_style_2nd',
				'default_value' => '',
				'label'         => esc_html__( 'Font Style', 'gastrobar' ),
				'options'       => gastrobar_edge_get_font_style_array()
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'        => $second_level_style_row3,
				'type'          => 'selectblanksimple',
				'name'          => 'fullscreen_menu_font_weight_2nd',
				'default_value' => '',
				'label'         => esc_html__( 'Font Weight', 'gastrobar' ),
				'options'       => gastrobar_edge_get_font_weight_array()
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'        => $second_level_style_row3,
				'type'          => 'textsimple',
				'name'          => 'fullscreen_menu_letter_spacing_2nd',
				'default_value' => '',
				'label'         => esc_html__( 'Lettert Spacing', 'gastrobar' ),
				'args'          => array(
					'suffix' => 'px'
				)
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'        => $second_level_style_row3,
				'type'          => 'selectblanksimple',
				'name'          => 'fullscreen_menu_text_transform_2nd',
				'default_value' => '',
				'label'         => esc_html__( 'Text Transform', 'gastrobar' ),
				'options'       => gastrobar_edge_get_text_transform_array()
			)
		);
		
		$third_level_style_group = gastrobar_edge_add_admin_group(
			array(
				'parent'      => $fullscreen_panel,
				'name'        => 'third_level_style_group',
				'title'       => esc_html__( '3rd Level Style', 'gastrobar' ),
				'description' => esc_html__( 'Define styles for 3rd level in full screen menu', 'gastrobar' )
			)
		);
		
		$third_level_style_row1 = gastrobar_edge_add_admin_row(
			array(
				'parent' => $third_level_style_group,
				'name'   => 'third_level_style_row1'
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'        => $third_level_style_row1,
				'type'          => 'colorsimple',
				'name'          => 'fullscreen_menu_color_3rd',
				'default_value' => '',
				'label'         => esc_html__( 'Text Color', 'gastrobar' ),
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'        => $third_level_style_row1,
				'type'          => 'colorsimple',
				'name'          => 'fullscreen_menu_hover_color_3rd',
				'default_value' => '',
				'label'         => esc_html__( 'Hover/Active Text Color', 'gastrobar' ),
			)
		);
		
		$third_level_style_row2 = gastrobar_edge_add_admin_row(
			array(
				'parent' => $third_level_style_group,
				'name'   => 'second_level_style_row2'
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'        => $third_level_style_row2,
				'type'          => 'fontsimple',
				'name'          => 'fullscreen_menu_google_fonts_3rd',
				'default_value' => '-1',
				'label'         => esc_html__( 'Font Family', 'gastrobar' ),
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'        => $third_level_style_row2,
				'type'          => 'textsimple',
				'name'          => 'fullscreen_menu_font_size_3rd',
				'default_value' => '',
				'label'         => esc_html__( 'Font Size', 'gastrobar' ),
				'args'          => array(
					'suffix' => 'px'
				)
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'        => $third_level_style_row2,
				'type'          => 'textsimple',
				'name'          => 'fullscreen_menu_line_height_3rd',
				'default_value' => '',
				'label'         => esc_html__( 'Line Height', 'gastrobar' ),
				'args'          => array(
					'suffix' => 'px'
				)
			)
		);
		
		$third_level_style_row3 = gastrobar_edge_add_admin_row(
			array(
				'parent' => $third_level_style_group,
				'name'   => 'second_level_style_row3'
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'        => $third_level_style_row3,
				'type'          => 'selectblanksimple',
				'name'          => 'fullscreen_menu_font_style_3rd',
				'default_value' => '',
				'label'         => esc_html__( 'Font Style', 'gastrobar' ),
				'options'       => gastrobar_edge_get_font_style_array()
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'        => $third_level_style_row3,
				'type'          => 'selectblanksimple',
				'name'          => 'fullscreen_menu_font_weight_3rd',
				'default_value' => '',
				'label'         => esc_html__( 'Font Weight', 'gastrobar' ),
				'options'       => gastrobar_edge_get_font_weight_array()
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'        => $third_level_style_row3,
				'type'          => 'textsimple',
				'name'          => 'fullscreen_menu_letter_spacing_3rd',
				'default_value' => '',
				'label'         => esc_html__( 'Lettert Spacing', 'gastrobar' ),
				'args'          => array(
					'suffix' => 'px'
				)
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'        => $third_level_style_row3,
				'type'          => 'selectblanksimple',
				'name'          => 'fullscreen_menu_text_transform_3rd',
				'default_value' => '',
				'label'         => esc_html__( 'Text Transform', 'gastrobar' ),
				'options'       => gastrobar_edge_get_text_transform_array()
			)
		);
		
		$icon_colors_group = gastrobar_edge_add_admin_group(
			array(
				'parent'      => $fullscreen_panel,
				'name'        => 'fullscreen_menu_icon_colors_group',
				'title'       => esc_html__( 'Full Screen Menu Icon Style', 'gastrobar' ),
				'description' => esc_html__( 'Define styles for full screen menu icon', 'gastrobar' )
			)
		);
		
		$icon_colors_row1 = gastrobar_edge_add_admin_row(
			array(
				'parent' => $icon_colors_group,
				'name'   => 'icon_colors_row1'
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent' => $icon_colors_row1,
				'type'   => 'colorsimple',
				'name'   => 'fullscreen_menu_icon_color',
				'label'  => esc_html__( 'Color', 'gastrobar' ),
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent' => $icon_colors_row1,
				'type'   => 'colorsimple',
				'name'   => 'fullscreen_menu_icon_hover_color',
				'label'  => esc_html__( 'Hover Color', 'gastrobar' ),
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent' => $icon_colors_row1,
				'type'   => 'colorsimple',
				'name'   => 'fullscreen_menu_icon_mobile_color',
				'label'  => esc_html__( 'Mobile Color', 'gastrobar' ),
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent' => $icon_colors_row1,
				'type'   => 'colorsimple',
				'name'   => 'fullscreen_menu_icon_mobile_hover_color',
				'label'  => esc_html__( 'Mobile Hover Color', 'gastrobar' ),
			)
		);
	}
	
	add_action( 'gastrobar_edge_action_additional_header_menu_area_options_map', 'gastrobar_edge_fullscreen_menu_options_map' );
}