<?php

if ( ! function_exists( 'gastrobar_edge_header_minimal_full_screen_menu_body_class' ) ) {
	/**
	 * Function that adds body classes for different full screen menu types
	 *
	 * @param $classes array original array of body classes
	 *
	 * @return array modified array of classes
	 */
	function gastrobar_edge_header_minimal_full_screen_menu_body_class( $classes ) {
		$classes[] = 'edgtf-' . gastrobar_edge_options()->getOptionValue( 'fullscreen_menu_animation_style' );

        $fullscreen_skin = gastrobar_edge_options()->getOptionValue( 'fullscreen_skin' );

        if($fullscreen_skin === 'light') {
            $classes[] = 'edgtf-fullscreen-menu-light';
        }
		
		return $classes;
	}
	
	if ( gastrobar_edge_check_is_header_type_enabled( 'header-minimal', gastrobar_edge_get_page_id() ) ) {
		add_filter( 'body_class', 'gastrobar_edge_header_minimal_full_screen_menu_body_class' );
	}
}

if ( ! function_exists( 'gastrobar_edge_get_header_minimal_full_screen_menu' ) ) {
	/**
	 * Loads fullscreen menu HTML template
	 */
	function gastrobar_edge_get_header_minimal_full_screen_menu() {
		$parameters = array(
			'fullscreen_menu_in_grid' => gastrobar_edge_options()->getOptionValue( 'fullscreen_in_grid' ) === 'yes' ? true : false
		);
		
		gastrobar_edge_get_module_template_part( 'templates/full-screen-menu', 'header/types/header-minimal', '', $parameters );
	}
	
	if ( gastrobar_edge_check_is_header_type_enabled( 'header-minimal', gastrobar_edge_get_page_id() ) ) {
		add_action( 'gastrobar_edge_action_after_wrapper_inner', 'gastrobar_edge_get_header_minimal_full_screen_menu', 40 );
	}
}

if ( ! function_exists( 'gastrobar_edge_header_minimal_mobile_menu_module' ) ) {
    /**
     * Function that edits module for mobile menu
     *
     * @param $module - default module value
     *
     * @return string name of module
     */
    function gastrobar_edge_header_minimal_mobile_menu_module( $module ) {
        return 'header/types/header-minimal';
    }

    if ( gastrobar_edge_check_is_header_type_enabled( 'header-minimal', gastrobar_edge_get_page_id() ) ) {
        add_filter('gastrobar_edge_filter_mobile_menu_module', 'gastrobar_edge_header_minimal_mobile_menu_module');
    }
}

if ( ! function_exists( 'gastrobar_edge_header_minimal_mobile_menu_slug' ) ) {
    /**
     * Function that edits slug for mobile menu
     *
     * @param $slug - default slug value
     *
     * @return string name of slug
     */
    function gastrobar_edge_header_minimal_mobile_menu_slug( $slug ) {
        return 'minimal';
    }

    if ( gastrobar_edge_check_is_header_type_enabled( 'header-minimal', gastrobar_edge_get_page_id() ) ) {
        add_filter('gastrobar_edge_filter_mobile_menu_slug', 'gastrobar_edge_header_minimal_mobile_menu_slug');
    }
}