<?php

if ( ! function_exists( 'gastrobar_edge_get_hide_dep_for_header_standard_meta_boxes' ) ) {
	function gastrobar_edge_get_hide_dep_for_header_standard_meta_boxes() {
		$hide_dep_options = apply_filters( 'gastrobar_edge_filter_header_standard_hide_meta_boxes', $hide_dep_options = array() );
		
		return $hide_dep_options;
	}
}

if ( ! function_exists( 'gastrobar_edge_header_standard_meta_map' ) ) {
	function gastrobar_edge_header_standard_meta_map( $parent ) {
		$hide_dep_options = gastrobar_edge_get_hide_dep_for_header_standard_meta_boxes();
		
		gastrobar_edge_create_meta_box_field(
			array(
				'parent'          => $parent,
				'type'            => 'select',
				'name'            => 'edgtf_set_menu_area_position_meta',
				'default_value'   => '',
				'label'           => esc_html__( 'Choose Menu Area Position', 'gastrobar' ),
				'description'     => esc_html__( 'Select menu area position in your header', 'gastrobar' ),
				'options'         => array(
					''       => esc_html__( 'Default', 'gastrobar' ),
					'left'   => esc_html__( 'Left', 'gastrobar' ),
					'right'  => esc_html__( 'Right', 'gastrobar' ),
					'center' => esc_html__( 'Center', 'gastrobar' )
				),
				'hidden_property' => 'edgtf_header_type_meta',
				'hidden_values'   => $hide_dep_options
			)
		);
	}
	
	add_action( 'gastrobar_edge_action_additional_header_area_meta_boxes_map', 'gastrobar_edge_header_standard_meta_map' );
}