<?php

if ( ! function_exists( 'gastrobar_edge_get_hide_dep_for_header_standard_options' ) ) {
	function gastrobar_edge_get_hide_dep_for_header_standard_options() {
		$hide_dep_options = apply_filters( 'gastrobar_edge_filter_header_standard_hide_global_option', $hide_dep_options = array() );
		
		return $hide_dep_options;
	}
}

if ( ! function_exists( 'gastrobar_edge_header_standard_map' ) ) {
	function gastrobar_edge_header_standard_map( $parent ) {
		$hide_dep_options = gastrobar_edge_get_hide_dep_for_header_standard_options();
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'          => $parent,
				'type'            => 'select',
				'name'            => 'set_menu_area_position',
				'default_value'   => 'right',
				'label'           => esc_html__( 'Choose Menu Area Position', 'gastrobar' ),
				'description'     => esc_html__( 'Select menu area position in your header', 'gastrobar' ),
				'options'         => array(
					'right'  => esc_html__( 'Right', 'gastrobar' ),
					'left'   => esc_html__( 'Left', 'gastrobar' ),
					'center' => esc_html__( 'Center', 'gastrobar' )
				),
				'hidden_property' => 'header_type',
				'hidden_values'   => $hide_dep_options
			)
		);
	}
	
	add_action( 'gastrobar_edge_action_additional_header_menu_area_options_map', 'gastrobar_edge_header_standard_map' );
}