<?php

if ( ! function_exists( 'gastrobar_edge_get_hide_dep_for_header_vertical_area_meta_boxes' ) ) {
	function gastrobar_edge_get_hide_dep_for_header_vertical_area_meta_boxes() {
		$hide_dep_options = apply_filters( 'gastrobar_edge_filter_header_vertical_hide_meta_boxes', $hide_dep_options = array() );
		
		return $hide_dep_options;
	}
}

if ( ! function_exists( 'gastrobar_edge_header_vertical_area_meta_options_map' ) ) {
	function gastrobar_edge_header_vertical_area_meta_options_map( $header_meta_box ) {
		$hide_dep_options = gastrobar_edge_get_hide_dep_for_header_vertical_area_meta_boxes();
		
		$header_vertical_area_meta_container = gastrobar_edge_add_admin_container(
			array(
				'parent'          => $header_meta_box,
				'name'            => 'header_vertical_area_container',
				'hidden_property' => 'edgtf_header_type_meta',
				'hidden_values'   => $hide_dep_options
			)
		);
		
		gastrobar_edge_add_admin_section_title(
			array(
				'parent' => $header_vertical_area_meta_container,
				'name'   => 'vertical_area_style',
				'title'  => esc_html__( 'Vertical Area Style', 'gastrobar' )
			)
		);
		
		$gastrobar_custom_sidebars = gastrobar_edge_get_custom_sidebars();
		if ( is_array( $gastrobar_custom_sidebars ) && count( $gastrobar_custom_sidebars ) > 0 ) {
			gastrobar_edge_create_meta_box_field(
				array(
					'name'        => 'edgtf_custom_vertical_area_sidebar_meta',
					'type'        => 'selectblank',
					'label'       => esc_html__( 'Choose Custom Widget Area in Vertical area', 'gastrobar' ),
					'description' => esc_html__( 'Choose custom widget area to display in vertical menu"', 'gastrobar' ),
					'parent'      => $header_vertical_area_meta_container,
					'options'     => $gastrobar_custom_sidebars
				)
			);
		}
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_vertical_header_background_color_meta',
				'type'        => 'color',
				'label'       => esc_html__( 'Background Color', 'gastrobar' ),
				'description' => esc_html__( 'Set background color for vertical menu', 'gastrobar' ),
				'parent'      => $header_vertical_area_meta_container
			)
		);
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_vertical_header_background_image_meta',
				'type'          => 'image',
				'default_value' => '',
				'label'         => esc_html__( 'Background Image', 'gastrobar' ),
				'description'   => esc_html__( 'Set background image for vertical menu', 'gastrobar' ),
				'parent'        => $header_vertical_area_meta_container
			)
		);
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_disable_vertical_header_background_image_meta',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Disable Background Image', 'gastrobar' ),
				'description'   => esc_html__( 'Enabling this option will hide background image in Vertical Menu', 'gastrobar' ),
				'parent'        => $header_vertical_area_meta_container
			)
		);
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_vertical_header_shadow_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Shadow', 'gastrobar' ),
				'description'   => esc_html__( 'Set shadow on vertical menu', 'gastrobar' ),
				'parent'        => $header_vertical_area_meta_container,
				'default_value' => '',
				'options'       => gastrobar_edge_get_yes_no_select_array()
			)
		);
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_vertical_header_border_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Vertical Area Border', 'gastrobar' ),
				'description'   => esc_html__( 'Set border on vertical area', 'gastrobar' ),
				'parent'        => $header_vertical_area_meta_container,
				'default_value' => '',
				'options'       => gastrobar_edge_get_yes_no_select_array(),
				'args'          => array(
					'dependence' => true,
					'hide'       => array(
						''    => '#edgtf_vertical_header_border_container',
						'no'  => '#edgtf_vertical_header_border_container',
						'yes' => ''
					),
					'show'       => array(
						''    => '',
						'no'  => '',
						'yes' => '#edgtf_vertical_header_border_container'
					)
				)
			)
		);
		
		$vertical_header_border_container = gastrobar_edge_add_admin_container(
			array(
				'type'            => 'container',
				'name'            => 'vertical_header_border_container',
				'parent'          => $header_vertical_area_meta_container,
				'hidden_property' => 'edgtf_vertical_header_border_meta',
				'hidden_value'    => 'no',
				'hidden_values'   => array( '', 'no' )
			)
		);
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_vertical_header_border_color_meta',
				'type'        => 'color',
				'label'       => esc_html__( 'Border Color', 'gastrobar' ),
				'description' => esc_html__( 'Choose color of border', 'gastrobar' ),
				'parent'      => $vertical_header_border_container
			)
		);
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_vertical_header_center_content_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Center Content', 'gastrobar' ),
				'description'   => esc_html__( 'Set content in vertical center', 'gastrobar' ),
				'parent'        => $header_vertical_area_meta_container,
				'default_value' => '',
				'options'       => gastrobar_edge_get_yes_no_select_array()
			)
		);
	}
	
	add_action( 'gastrobar_edge_action_additional_header_area_meta_boxes_map', 'gastrobar_edge_header_vertical_area_meta_options_map', 10, 1 );
}