<?php

if ( ! function_exists( 'gastrobar_edge_include_mobile_header_menu' ) ) {
	function gastrobar_edge_include_mobile_header_menu( $menus ) {
		$menus['mobile-navigation'] = esc_html__( 'Mobile Navigation', 'gastrobar' );
		
		return $menus;
	}
	
	add_filter( 'gastrobar_edge_filter_register_headers_menu', 'gastrobar_edge_include_mobile_header_menu' );
}

if ( ! function_exists( 'gastrobar_edge_register_mobile_header_areas' ) ) {
	/**
	 * Registers widget areas for mobile header
	 */
	function gastrobar_edge_register_mobile_header_areas() {
		if ( gastrobar_edge_is_responsive_on() ) {
			register_sidebar(
				array(
					'id'            => 'edgtf-right-from-mobile-logo',
					'name'          => esc_html__( 'Mobile Header Widget Area', 'gastrobar' ),
					'description'   => esc_html__( 'Widgets added here will appear on the right hand side from the mobile logo on mobile header', 'gastrobar' ),
					'before_widget' => '<div id="%1$s" class="widget %2$s edgtf-right-from-mobile-logo">',
					'after_widget'  => '</div>'
				)
			);
		}
	}
	
	add_action( 'widgets_init', 'gastrobar_edge_register_mobile_header_areas' );
}

if ( ! function_exists( 'gastrobar_edge_mobile_header_class' ) ) {
	function gastrobar_edge_mobile_header_class( $classes ) {
		$classes[] = 'edgtf-default-mobile-header';
		
		$classes[] = 'edgtf-sticky-up-mobile-header';
		
		return $classes;
	}
	
	add_filter( 'body_class', 'gastrobar_edge_mobile_header_class' );
}

if ( ! function_exists( 'gastrobar_edge_get_mobile_header' ) ) {
	/**
	 * Loads mobile header HTML only if responsiveness is enabled
	 */
	function gastrobar_edge_get_mobile_header( $slug = '', $module = '' ) {
		if ( gastrobar_edge_is_responsive_on() ) {
			$mobile_menu_title = gastrobar_edge_options()->getOptionValue( 'mobile_menu_title' );
			$has_navigation    = has_nav_menu( 'main-navigation' ) || has_nav_menu( 'mobile-navigation' ) ? true : false;
			
			$parameters = array(
				'show_navigation_opener' => $has_navigation,
				'mobile_menu_title'      => $mobile_menu_title
			);

            $module = apply_filters('gastrobar_edge_filter_mobile_menu_module', 'header/types/mobile-header');
            $slug = apply_filters('gastrobar_edge_filter_mobile_menu_slug', '');

            gastrobar_edge_get_module_template_part( 'templates/mobile-header', $module, $slug, $parameters );
		}
	}
	
	add_action( 'gastrobar_edge_action_after_wrapper_inner', 'gastrobar_edge_get_mobile_header', 20 );
}

if ( ! function_exists( 'gastrobar_edge_get_mobile_logo' ) ) {
	/**
	 * Loads mobile logo HTML. It checks if mobile logo image is set and uses that, else takes normal logo image
	 */
	function gastrobar_edge_get_mobile_logo() {
		$show_logo_image = gastrobar_edge_options()->getOptionValue( 'hide_logo' ) === 'yes' ? false : true;
		
		if ( $show_logo_image ) {
			$mobile_logo_image = gastrobar_edge_get_meta_field_intersect( 'logo_image_mobile', gastrobar_edge_get_page_id() );
			
			//check if mobile logo has been set and use that, else use normal logo
			$logo_image = ! empty( $mobile_logo_image ) ? $mobile_logo_image : gastrobar_edge_get_meta_field_intersect( 'logo_image', gastrobar_edge_get_page_id() );
			
			//get logo image dimensions and set style attribute for image link.
			$logo_dimensions = gastrobar_edge_get_image_dimensions( $logo_image );
			
			$logo_height = '';
			$logo_styles = '';
			if ( is_array( $logo_dimensions ) && array_key_exists( 'height', $logo_dimensions ) ) {
				$logo_height = $logo_dimensions['height'];
				$logo_styles = 'height: ' . intval( $logo_height / 2 ) . 'px'; //divided with 2 because of retina screens
			}
			
			//set parameters for logo
			$parameters = array(
				'logo_image'      => $logo_image,
				'logo_dimensions' => $logo_dimensions,
				'logo_height'     => $logo_height,
				'logo_styles'     => $logo_styles
			);
			
			gastrobar_edge_get_module_template_part( 'templates/mobile-logo', 'header/types/mobile-header', '', $parameters );
		}
	}
}

if ( ! function_exists( 'gastrobar_edge_get_mobile_nav' ) ) {
	/**
	 * Loads mobile navigation HTML
	 */
	function gastrobar_edge_get_mobile_nav() {
		gastrobar_edge_get_module_template_part( 'templates/mobile-navigation', 'header/types/mobile-header' );
	}
}

if ( ! function_exists( 'cityrama_edgtf_mobile_header_per_page_js_var' ) ) {
    function cityrama_edgtf_mobile_header_per_page_js_var( $perPageVars ) {
        $perPageVars['edgtfMobileHeaderHeight'] = gastrobar_edge_set_default_mobile_menu_height_for_header_types();

        return $perPageVars;
    }

    add_filter( 'cityrama_edgtf_per_page_js_vars', 'cityrama_edgtf_mobile_header_per_page_js_var' );
}