<?php

if(!function_exists('gastrobar_edge_overlapping_content_enabled')) {
    /**
     * Checks if overlapping content is enabled
     *
     * @return bool
     */
    function gastrobar_edge_overlapping_content_enabled() {
        $id = gastrobar_edge_get_page_id();

        return get_post_meta($id, 'edgtf_overlapping_content_enable_meta', true) === 'yes';
    }
}

if(!function_exists('gastrobar_edge_overlapping_content_class')) {
    /**
     * Adds overlapping content class to body tag
     * if overlapping content is enabled
     * @param $classes
     *
     * @return array
     */
    function gastrobar_edge_overlapping_content_class($classes) {
        if(gastrobar_edge_overlapping_content_enabled()) {
            $classes[] = 'edgtf-overlapping-content-enabled';
        }

        return $classes;
    }

    add_filter('body_class', 'gastrobar_edge_overlapping_content_class');
}

if(!function_exists('gastrobar_edge_oc_content_top_padding')) {
    function gastrobar_edge_oc_content_top_padding($style) {
	    $id = gastrobar_edge_get_page_id();

	    $class_prefix = gastrobar_edge_get_unique_page_class($id);

	    $content_selector = array(
		    $class_prefix.' .edgtf-content .edgtf-content-inner > .edgtf-container .edgtf-overlapping-content'
	    );

	    $content_css = array();

	    $top_offset = get_post_meta($id, 'edgtf_overlapping_content_top_offset', true);
	    if($top_offset !== '') {
		    $content_css['margin-top'] = gastrobar_edge_filter_px($top_offset).'px';
	    }

	    $current_style = '';
		if(!empty ($content_css)) {
			$current_style = gastrobar_edge_dynamic_css($content_selector, $content_css);
		}

	    $current_style = $current_style . $style;

	    return $current_style;
    }

	add_filter('gastrobar_edge_filter_add_page_custom_style', 'gastrobar_edge_oc_content_top_padding');
}