<?php

if ( ! function_exists( 'gastrobar_edge_map_overlapping_content_meta' ) ) {
	function gastrobar_edge_map_overlapping_content_meta($general_meta_box) {

		gastrobar_edge_create_meta_box_field(array(
			'name'          => 'edgtf_overlapping_content_enable_meta',
			'type'          => 'yesno',
			'default_value' => 'no',
			'label'         => esc_html__('Enable Overlapping Content', 'gastrobar' ),
			'description'   => esc_html__('Enabling this option will make content overlap title area', 'gastrobar' ),
			'parent'        => $general_meta_box
		));

		gastrobar_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_overlapping_content_top_offset',
				'type'          => 'text',
				'default_value' => '',
				'label'         => esc_html__('Overlapping Content Top Offset', 'gastrobar' ),
				'parent'        => $general_meta_box,
				'args'          => array(
					'col_width' => 2,
					'suffix'    => 'px'
				)
			)
		);
	}

	add_action( 'gastrobar_edge_filter_overlapping_meta_boxes_map', 'gastrobar_edge_map_overlapping_content_meta' );
}