<?php


if(!function_exists('edgtf_restaurant_map_map')) {
	/**
	 * Adds admin page for OpenTable integration
	 */
	function edgtf_restaurant_map_map() {
		gastrobar_edge_add_admin_page(array(
			'title' => esc_html__('Reservation', 'gastrobar'),
			'slug'  => '_restaurant',
			'icon'  => 'fa fa-cutlery'
		));

		//#OpenTable Panel
		$panel_open_table = gastrobar_edge_add_admin_panel(array(
			'page'  => '_restaurant',
			'name'  => 'panel_open_table',
			'title' => esc_html__('OpenTable', 'gastrobar')
		));

		gastrobar_edge_add_admin_field(array(
			'name'        => 'open_table_id',
			'type'        => 'text',
			'label'       => esc_html__('OpenTable ID', 'gastrobar'),
			'description' => esc_html__('Add your restaurant\'s OpenTable ID', 'gastrobar'),
			'parent'      => $panel_open_table,
			'args'        => array(
				'col_width' => 3
			)
		));
	}

	add_action('gastrobar_edge_action_options_map', 'edgtf_restaurant_map_map', 22);
}