<?php
namespace EdgeCore\CPT\Shortcodes\ReservationForm;

use EdgeCore\Lib\ShortcodeInterface;

class ReservationForm implements ShortcodeInterface {
	private $base;

	public function __construct() {
		$this->base = 'edgtf_reservation_form';

		add_action('vc_before_init', array($this, 'vcMap'));
	}

	public function getBase() {
		return $this->base;
	}

	public function vcMap() {
		vc_map(array(
			'name'                      => esc_html__('Edge Reservation Form', 'gastrobar'),
			'base'                      => $this->base,
			'category'                  => esc_html__('by EDGE', 'gastrobar'),
			'icon'                      => 'icon-wpb-reservation-form extended-custom-icon',
			'allowed_container_element' => 'vc_row',
			'params'                    => array(
				array(
					'type'        => 'textfield',
					'param_name'  => 'open_table_id',
					'heading'     => esc_html__('OpenTable ID', 'gastrobar'),
					'admin_label' => true
				),
				array(
					'type'        => 'dropdown',
					'param_name'  => 'skin',
					'heading'     => esc_html__('Skin', 'gastrobar'),
					'value'       => array(
						esc_html__( 'Default', 'gastrobar' ) => '',
						esc_html__( 'Light', 'gastrobar' )   => 'light',
					),
					'save_always' => true,
					'admin_label' => true
				)
			)
		));
	}

	public function render($atts, $content = null) {
		$default_atts = array(
			'open_table_id' => '',
			'skin'          => ''
		);

		$params = shortcode_atts($default_atts, $atts);

		$params['holder_class'] = $this->holderClass($params);

		if($params['open_table_id'] === '' ) {
			$params['open_table_id'] = gastrobar_edge_options()->getOptionValue('open_table_id');
		}

		return gastrobar_edge_get_reservation_form_module_template_part('templates/reservation-form', 'reservation-form', '', $params);
	}

	public function holderClass($params) {
		$class = array();

		if ( $params['skin'] !== '' ) {
			$class[] = 'edgtf-rf-' . esc_attr( $params['skin'] );
		}

		return implode( ' ', $class );
	}
}


