<?php

if ( ! function_exists( 'gastrobar_edge_get_search_types_options' ) ) {
    function gastrobar_edge_get_search_types_options() {
        $search_type_options = apply_filters( 'gastrobar_edge_filter_search_type_global_option', $search_type_options = array() );

        return $search_type_options;
    }
}

if ( ! function_exists( 'gastrobar_edge_search_options_map' ) ) {
	function gastrobar_edge_search_options_map() {
		
		gastrobar_edge_add_admin_page(
			array(
				'slug'  => '_search_page',
				'title' => esc_html__( 'Search', 'gastrobar' ),
				'icon'  => 'fa fa-search'
			)
		);
		
		$search_page_panel = gastrobar_edge_add_admin_panel(
			array(
				'title' => esc_html__( 'Search Page', 'gastrobar' ),
				'name'  => 'search_template',
				'page'  => '_search_page'
			)
		);
		
		gastrobar_edge_add_admin_field( array(
			'name'          => 'search_page_layout',
			'type'          => 'select',
			'label'         => esc_html__( 'Layout', 'gastrobar' ),
			'default_value' => 'in-grid',
			'description'   => esc_html__( 'Set layout. Default is in grid.', 'gastrobar' ),
			'parent'        => $search_page_panel,
			'options'       => array(
				'in-grid'    => esc_html__( 'In Grid', 'gastrobar' ),
				'full-width' => esc_html__( 'Full Width', 'gastrobar' )
			)
		) );
		
		gastrobar_edge_add_admin_field( array(
			'name'          => 'search_page_sidebar_layout',
			'type'          => 'select',
			'label'         => esc_html__( 'Sidebar Layout', 'gastrobar' ),
			'description'   => esc_html__( "Choose a sidebar layout for search page", 'gastrobar' ),
			'default_value' => 'no-sidebar',
			'options'       => gastrobar_edge_get_custom_sidebars_options(),
			'parent'        => $search_page_panel
		) );
		
		$gastrobar_custom_sidebars = gastrobar_edge_get_custom_sidebars();
		if ( is_array( $gastrobar_custom_sidebars ) && count( $gastrobar_custom_sidebars ) > 0 ) {
			gastrobar_edge_add_admin_field( array(
				'name'        => 'search_custom_sidebar_area',
				'type'        => 'selectblank',
				'label'       => esc_html__( 'Sidebar to Display', 'gastrobar' ),
				'description' => esc_html__( 'Choose a sidebar to display on search page. Default sidebar is "Sidebar"', 'gastrobar' ),
				'parent'      => $search_page_panel,
				'options'     => $gastrobar_custom_sidebars,
				'args'        => array(
					'select2' => true
				)
			) );
		}
		
		$search_panel = gastrobar_edge_add_admin_panel(
			array(
				'title' => esc_html__( 'Search', 'gastrobar' ),
				'name'  => 'search',
				'page'  => '_search_page'
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'        => $search_panel,
				'type'          => 'select',
				'name'          => 'search_type',
				'default_value' => 'fullscreen',
				'label'         => esc_html__( 'Select Search Type', 'gastrobar' ),
				'description'   => esc_html__( "Choose a type of Select search bar (Note: Slide From Header Bottom search type doesn't work with Vertical Header)", 'gastrobar' ),
				'options'       => gastrobar_edge_get_search_types_options()
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'        => $search_panel,
				'type'          => 'select',
				'name'          => 'search_icon_pack',
				'default_value' => 'font_elegant',
				'label'         => esc_html__( 'Search Icon Pack', 'gastrobar' ),
				'description'   => esc_html__( 'Choose icon pack for search icon', 'gastrobar' ),
				'options'       => gastrobar_edge_icon_collections()->getIconCollectionsExclude( array( 'linea_icons' ) )
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'        => $search_panel,
				'type'          => 'yesno',
				'name'          => 'search_in_grid',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Enable Grid Layout', 'gastrobar' ),
				'description'   => esc_html__( 'Set search area to be in grid. (Applied for Search covers header and Slide from Window Top types.', 'gastrobar' ),
			)
		);
		
		gastrobar_edge_add_admin_section_title(
			array(
				'parent' => $search_panel,
				'name'   => 'initial_header_icon_title',
				'title'  => esc_html__( 'Initial Search Icon in Header', 'gastrobar' )
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'        => $search_panel,
				'type'          => 'text',
				'name'          => 'header_search_icon_size',
				'default_value' => '',
				'label'         => esc_html__( 'Icon Size', 'gastrobar' ),
				'description'   => esc_html__( 'Set size for icon', 'gastrobar' ),
				'args'          => array(
					'col_width' => 3,
					'suffix'    => 'px'
				)
			)
		);
		
		$search_icon_color_group = gastrobar_edge_add_admin_group(
			array(
				'parent'      => $search_panel,
				'title'       => esc_html__( 'Icon Colors', 'gastrobar' ),
				'description' => esc_html__( 'Define color style for icon', 'gastrobar' ),
				'name'        => 'search_icon_color_group'
			)
		);
		
		$search_icon_color_row = gastrobar_edge_add_admin_row(
			array(
				'parent' => $search_icon_color_group,
				'name'   => 'search_icon_color_row'
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent' => $search_icon_color_row,
				'type'   => 'colorsimple',
				'name'   => 'header_search_icon_color',
				'label'  => esc_html__( 'Color', 'gastrobar' )
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent' => $search_icon_color_row,
				'type'   => 'colorsimple',
				'name'   => 'header_search_icon_hover_color',
				'label'  => esc_html__( 'Hover Color', 'gastrobar' )
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'        => $search_panel,
				'type'          => 'yesno',
				'name'          => 'enable_search_icon_text',
				'default_value' => 'no',
				'label'         => esc_html__( 'Enable Search Icon Text', 'gastrobar' ),
				'description'   => esc_html__( "Enable this option to show 'Search' text next to search icon in header", 'gastrobar' ),
				'args'          => array(
					'dependence'             => true,
					'dependence_hide_on_yes' => '',
					'dependence_show_on_yes' => '#edgtf_enable_search_icon_text_container'
				)
			)
		);
		
		$enable_search_icon_text_container = gastrobar_edge_add_admin_container(
			array(
				'parent'          => $search_panel,
				'name'            => 'enable_search_icon_text_container',
				'hidden_property' => 'enable_search_icon_text',
				'hidden_value'    => 'no'
			)
		);
		
		$enable_search_icon_text_group = gastrobar_edge_add_admin_group(
			array(
				'parent'      => $enable_search_icon_text_container,
				'title'       => esc_html__( 'Search Icon Text', 'gastrobar' ),
				'name'        => 'enable_search_icon_text_group',
				'description' => esc_html__( 'Define style for search icon text', 'gastrobar' )
			)
		);
		
		$enable_search_icon_text_row = gastrobar_edge_add_admin_row(
			array(
				'parent' => $enable_search_icon_text_group,
				'name'   => 'enable_search_icon_text_row'
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent' => $enable_search_icon_text_row,
				'type'   => 'colorsimple',
				'name'   => 'search_icon_text_color',
				'label'  => esc_html__( 'Text Color', 'gastrobar' )
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent' => $enable_search_icon_text_row,
				'type'   => 'colorsimple',
				'name'   => 'search_icon_text_color_hover',
				'label'  => esc_html__( 'Text Hover Color', 'gastrobar' )
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'        => $enable_search_icon_text_row,
				'type'          => 'textsimple',
				'name'          => 'search_icon_text_font_size',
				'label'         => esc_html__( 'Font Size', 'gastrobar' ),
				'default_value' => '',
				'args'          => array(
					'suffix' => 'px'
				)
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'        => $enable_search_icon_text_row,
				'type'          => 'textsimple',
				'name'          => 'search_icon_text_line_height',
				'label'         => esc_html__( 'Line Height', 'gastrobar' ),
				'default_value' => '',
				'args'          => array(
					'suffix' => 'px'
				)
			)
		);
		
		$enable_search_icon_text_row2 = gastrobar_edge_add_admin_row(
			array(
				'parent' => $enable_search_icon_text_group,
				'name'   => 'enable_search_icon_text_row2',
				'next'   => true
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'        => $enable_search_icon_text_row2,
				'type'          => 'selectblanksimple',
				'name'          => 'search_icon_text_text_transform',
				'label'         => esc_html__( 'Text Transform', 'gastrobar' ),
				'default_value' => '',
				'options'       => gastrobar_edge_get_text_transform_array()
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'        => $enable_search_icon_text_row2,
				'type'          => 'fontsimple',
				'name'          => 'search_icon_text_google_fonts',
				'label'         => esc_html__( 'Font Family', 'gastrobar' ),
				'default_value' => '-1',
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'        => $enable_search_icon_text_row2,
				'type'          => 'selectblanksimple',
				'name'          => 'search_icon_text_font_style',
				'label'         => esc_html__( 'Font Style', 'gastrobar' ),
				'default_value' => '',
				'options'       => gastrobar_edge_get_font_style_array(),
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'        => $enable_search_icon_text_row2,
				'type'          => 'selectblanksimple',
				'name'          => 'search_icon_text_font_weight',
				'label'         => esc_html__( 'Font Weight', 'gastrobar' ),
				'default_value' => '',
				'options'       => gastrobar_edge_get_font_weight_array(),
			)
		);
		
		$enable_search_icon_text_row3 = gastrobar_edge_add_admin_row(
			array(
				'parent' => $enable_search_icon_text_group,
				'name'   => 'enable_search_icon_text_row3',
				'next'   => true
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'        => $enable_search_icon_text_row3,
				'type'          => 'textsimple',
				'name'          => 'search_icon_text_letter_spacing',
				'label'         => esc_html__( 'Letter Spacing', 'gastrobar' ),
				'default_value' => '',
				'args'          => array(
					'suffix' => 'px'
				)
			)
		);
	}
	
	add_action( 'gastrobar_edge_action_options_map', 'gastrobar_edge_search_options_map', 16 );
}