(function($) {
    "use strict";

    var searchSlideFromHB = {};
    edgtf.modules.searchSlideFromHB = searchSlideFromHB;

    searchSlideFromHB.edgtfOnDocumentReady = edgtfOnDocumentReady;

    $(document).ready(edgtfOnDocumentReady);
    
    /* 
        All functions to be called on $(document).ready() should be in this function
    */
    function edgtfOnDocumentReady() {
	    edgtfSearchSlideFromHB();
    }
	
	/**
	 * Init Search Types
	 */
	function edgtfSearchSlideFromHB() {
        if ( edgtf.body.hasClass( 'edgtf-slide-from-header-bottom' ) ) {

            var searchOpener = $('a.edgtf-search-opener');

            if (searchOpener.length > 0) {
                //Check for type of search
                searchOpener.on('click',function (e) {
                    e.preventDefault();

                    var thisSearchOpener = $(this),
                        searchIconPosition = parseInt(edgtf.windowWidth - thisSearchOpener.offset().left - thisSearchOpener.outerWidth());

                    if (edgtf.body.hasClass('edgtf-boxed') && edgtf.windowWidth > 1024) {
                        searchIconPosition -= parseInt((edgtf.windowWidth - $('.edgtf-boxed .edgtf-wrapper .edgtf-wrapper-inner').outerWidth()) / 2);
                    }

                    var searchFormHeaderHolder = $('.edgtf-page-header'),
                        searchFormTopOffset = '100%',
                        searchFormTopHeaderHolder = $('.edgtf-top-bar'),
                        searchFormFixedHeaderHolder = searchFormHeaderHolder.find('.edgtf-fixed-wrapper.fixed'),
                        searchFormMobileHeaderHolder = $('.edgtf-mobile-header'),
                        searchForm = $('.edgtf-slide-from-header-bottom-holder'),
                        searchFormIsInTopHeader = !!thisSearchOpener.parents('.edgtf-top-bar').length,
                        searchFormIsInFixedHeader = !!thisSearchOpener.parents('.edgtf-fixed-wrapper.fixed').length,
                        searchFormIsInStickyHeader = !!thisSearchOpener.parents('.edgtf-sticky-header').length,
                        searchFormIsInMobileHeader = !!thisSearchOpener.parents('.edgtf-mobile-header').length;

                    searchForm.removeClass('edgtf-is-active');

                    //Find search form position in header and height
                    if (searchFormIsInTopHeader) {
                        searchFormTopHeaderHolder.find('.edgtf-slide-from-header-bottom-holder').addClass('edgtf-is-active');

                    } else if (searchFormIsInFixedHeader) {
                        searchFormTopOffset = searchFormFixedHeaderHolder.outerHeight() + edgtfGlobalVars.vars.edgtfAddForAdminBar;
                        searchFormHeaderHolder.children('.edgtf-slide-from-header-bottom-holder').addClass('edgtf-is-active');

                    } else if (searchFormIsInStickyHeader) {
                        searchFormTopOffset = edgtfGlobalVars.vars.edgtfStickyHeaderHeight + edgtfGlobalVars.vars.edgtfAddForAdminBar;
                        searchFormHeaderHolder.children('.edgtf-slide-from-header-bottom-holder').addClass('edgtf-is-active');

                    } else if (searchFormIsInMobileHeader) {
                        if (searchFormMobileHeaderHolder.hasClass('mobile-header-appear')) {
                            searchFormTopOffset = searchFormMobileHeaderHolder.children('.edgtf-mobile-header-inner').outerHeight() + edgtfGlobalVars.vars.edgtfAddForAdminBar;
                        }
                        searchFormMobileHeaderHolder.find('.edgtf-slide-from-header-bottom-holder').addClass('edgtf-is-active');

                    } else {
                        searchFormHeaderHolder.children('.edgtf-slide-from-header-bottom-holder').addClass('edgtf-is-active');
                    }

                    if (searchForm.hasClass('edgtf-is-active')) {
                        searchForm.css({
                            'right': searchIconPosition,
                            'top': searchFormTopOffset
                        }).stop(true).slideToggle(300, 'easeOutBack');
                    }

                    //Close on escape
                    $(document).keyup(function (e) {
                        if (e.keyCode == 27) { //KeyCode for ESC button is 27
                            searchForm.stop(true).fadeOut(0);
                        }
                    });

                    $(window).scroll(function () {
                        searchForm.stop(true).fadeOut(0);
                    });
                });
            }
        }
	}

})(jQuery);
