<?php

if ( ! function_exists( 'gastrobar_edge_search_body_class' ) ) {
	/**
	 * Function that adds body classes for different search types
	 *
	 * @param $classes array original array of body classes
	 *
	 * @return array modified array of classes
	 */
	function gastrobar_edge_search_body_class( $classes ) {
		$classes[] = 'edgtf-search-slides-from-window-top';
		
		return $classes;
	}
	
	add_filter( 'body_class', 'gastrobar_edge_search_body_class' );
}

if ( ! function_exists( 'gastrobar_edge_get_search' ) ) {
	/**
	 * Loads search HTML based on search type option.
	 */
	function gastrobar_edge_get_search() {
		gastrobar_edge_load_search_template();
	}
	
	add_action( 'gastrobar_edge_action_before_page_header', 'gastrobar_edge_get_search' );
}

if ( ! function_exists( 'gastrobar_edge_load_search_template' ) ) {
	/**
	 * Loads search HTML based on search type option.
	 */
	function gastrobar_edge_load_search_template() {
		$search_icon_pack  = gastrobar_edge_options()->getOptionValue( 'search_icon_pack' );
		$search_in_grid    = gastrobar_edge_options()->getOptionValue( 'search_in_grid' ) == 'yes' ? true : false;
		$search_icon       = '';
		$search_icon_close = '';
		
		if ( ! empty( $search_icon_pack ) ) {
			$search_icon       .= gastrobar_edge_icon_collections()->getSearchIcon( $search_icon_pack, true );
			$search_icon_close .= gastrobar_edge_icon_collections()->getSearchClose( $search_icon_pack, true );
		}
		
		$parameters = array(
			'search_in_grid'    => $search_in_grid,
			'search_icon'       => $search_icon,
			'search_icon_close' => $search_icon_close
		);

        gastrobar_edge_get_module_template_part( 'types/slide-from-window-top/templates/slide-from-window-top', 'search', '', $parameters );
	}
}