<?php

if ( ! function_exists( 'gastrobar_edge_sidearea_options_map' ) ) {
	function gastrobar_edge_sidearea_options_map() {
		
		gastrobar_edge_add_admin_page(
			array(
				'slug'  => '_side_area_page',
				'title' => esc_html__( 'Side Area', 'gastrobar' ),
				'icon'  => 'fa fa-indent'
			)
		);
		
		$side_area_panel = gastrobar_edge_add_admin_panel(
			array(
				'title' => esc_html__( 'Side Area', 'gastrobar' ),
				'name'  => 'side_area',
				'page'  => '_side_area_page'
			)
		);
		
		$side_area_icon_style_group = gastrobar_edge_add_admin_group(
			array(
				'parent'      => $side_area_panel,
				'name'        => 'side_area_icon_style_group',
				'title'       => esc_html__( 'Side Area Icon Style', 'gastrobar' ),
				'description' => esc_html__( 'Define styles for Side Area icon', 'gastrobar' )
			)
		);
		
		$side_area_icon_style_row1 = gastrobar_edge_add_admin_row(
			array(
				'parent' => $side_area_icon_style_group,
				'name'   => 'side_area_icon_style_row1'
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent' => $side_area_icon_style_row1,
				'type'   => 'colorsimple',
				'name'   => 'side_area_icon_color',
				'label'  => esc_html__( 'Color', 'gastrobar' )
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent' => $side_area_icon_style_row1,
				'type'   => 'colorsimple',
				'name'   => 'side_area_icon_hover_color',
				'label'  => esc_html__( 'Hover Color', 'gastrobar' )
			)
		);
		
		$side_area_icon_style_row2 = gastrobar_edge_add_admin_row(
			array(
				'parent' => $side_area_icon_style_group,
				'name'   => 'side_area_icon_style_row2',
				'next'   => true
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent' => $side_area_icon_style_row2,
				'type'   => 'colorsimple',
				'name'   => 'side_area_close_icon_color',
				'label'  => esc_html__( 'Close Icon Color', 'gastrobar' )
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent' => $side_area_icon_style_row2,
				'type'   => 'colorsimple',
				'name'   => 'side_area_close_icon_hover_color',
				'label'  => esc_html__( 'Close Icon Hover Color', 'gastrobar' )
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'        => $side_area_panel,
				'type'          => 'text',
				'name'          => 'side_area_width',
				'default_value' => '',
				'label'         => esc_html__( 'Side Area Width', 'gastrobar' ),
				'description'   => esc_html__( 'Enter a width for Side Area', 'gastrobar' ),
				'args'          => array(
					'col_width' => 3,
					'suffix'    => 'px'
				)
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'      => $side_area_panel,
				'type'        => 'color',
				'name'        => 'side_area_background_color',
				'label'       => esc_html__( 'Background Color', 'gastrobar' ),
				'description' => esc_html__( 'Choose a background color for Side Area', 'gastrobar' )
			)
		);

        gastrobar_edge_add_admin_field(
            array(
                'parent'      => $side_area_panel,
                'type'        => 'image',
                'name'        => 'side_area_background_pattern',
                'label'       => esc_html__( 'Background Pattern', 'gastrobar' ),
                'description' => esc_html__( 'Choose a background pattern for Side Area', 'gastrobar' )
            )
        );
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'      => $side_area_panel,
				'type'        => 'text',
				'name'        => 'side_area_padding',
				'label'       => esc_html__( 'Padding', 'gastrobar' ),
				'description' => esc_html__( 'Define padding for Side Area in format top right bottom left', 'gastrobar' ),
				'args'        => array(
					'col_width' => 3
				)
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'parent'        => $side_area_panel,
				'type'          => 'selectblank',
				'name'          => 'side_area_aligment',
				'default_value' => '',
				'label'         => esc_html__( 'Text Alignment', 'gastrobar' ),
				'description'   => esc_html__( 'Choose text alignment for side area', 'gastrobar' ),
				'options'       => array(
					''       => esc_html__( 'Default', 'gastrobar' ),
					'left'   => esc_html__( 'Left', 'gastrobar' ),
					'center' => esc_html__( 'Center', 'gastrobar' ),
					'right'  => esc_html__( 'Right', 'gastrobar' )
				)
			)
		);
	}
	
	add_action( 'gastrobar_edge_action_options_map', 'gastrobar_edge_sidearea_options_map', 15 );
}