<?php

if ( ! function_exists( 'gastrobar_edge_map_sidebar_meta' ) ) {
	function gastrobar_edge_map_sidebar_meta() {
		$edgtf_sidebar_meta_box = gastrobar_edge_create_meta_box(
			array(
				'scope' => apply_filters( 'gastrobar_edge_filter_set_scope_for_meta_boxes', array( 'page' ), 'sidebar_meta' ),
				'title' => esc_html__( 'Sidebar', 'gastrobar' ),
				'name'  => 'sidebar_meta'
			)
		);
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_sidebar_layout_meta',
				'type'        => 'select',
				'label'       => esc_html__( 'Sidebar Layout', 'gastrobar' ),
				'description' => esc_html__( 'Choose the sidebar layout', 'gastrobar' ),
				'parent'      => $edgtf_sidebar_meta_box,
                'options'       => gastrobar_edge_get_custom_sidebars_options( true )
			)
		);
		
		$edgtf_custom_sidebars = gastrobar_edge_get_custom_sidebars();
		if ( is_array( $edgtf_custom_sidebars ) && count( $edgtf_custom_sidebars ) > 0 ) {
			gastrobar_edge_create_meta_box_field(
				array(
					'name'        => 'edgtf_custom_sidebar_area_meta',
					'type'        => 'selectblank',
					'label'       => esc_html__( 'Choose Widget Area in Sidebar', 'gastrobar' ),
					'description' => esc_html__( 'Choose Custom Widget area to display in Sidebar"', 'gastrobar' ),
					'parent'      => $edgtf_sidebar_meta_box,
					'options'     => $edgtf_custom_sidebars,
					'args'        => array(
						'select2' => true
					)
				)
			);
		}
	}
	
	add_action( 'gastrobar_edge_action_meta_boxes_map', 'gastrobar_edge_map_sidebar_meta', 31 );
}