<?php

if ( ! function_exists( 'gastrobar_edge_sidebar_options_map' ) ) {
	function gastrobar_edge_sidebar_options_map() {
		
		gastrobar_edge_add_admin_page(
			array(
				'slug'  => '_sidebar_page',
				'title' => esc_html__( 'Sidebar Area', 'gastrobar' ),
				'icon'  => 'fa fa-indent'
			)
		);
		
		$sidebar_panel = gastrobar_edge_add_admin_panel(
			array(
				'title' => esc_html__( 'Sidebar Area', 'gastrobar' ),
				'name'  => 'sidebar',
				'page'  => '_sidebar_page'
			)
		);
		
		gastrobar_edge_add_admin_field( array(
			'name'          => 'sidebar_layout',
			'type'          => 'select',
			'label'         => esc_html__( 'Sidebar Layout', 'gastrobar' ),
			'description'   => esc_html__( 'Choose a sidebar layout for pages', 'gastrobar' ),
			'parent'        => $sidebar_panel,
			'default_value' => 'no-sidebar',
            'options'       => gastrobar_edge_get_custom_sidebars_options()
		) );
		
		$gastrobar_custom_sidebars = gastrobar_edge_get_custom_sidebars();
		if ( is_array( $gastrobar_custom_sidebars ) && count( $gastrobar_custom_sidebars ) > 0 ) {
			gastrobar_edge_add_admin_field( array(
				'name'        => 'custom_sidebar_area',
				'type'        => 'selectblank',
				'label'       => esc_html__( 'Sidebar to Display', 'gastrobar' ),
				'description' => esc_html__( 'Choose a sidebar to display on pages. Default sidebar is "Sidebar"', 'gastrobar' ),
				'parent'      => $sidebar_panel,
				'options'     => $gastrobar_custom_sidebars,
				'args'        => array(
					'select2' => true
				)
			) );
		}
	}
	
	add_action( 'gastrobar_edge_action_options_map', 'gastrobar_edge_sidebar_options_map', 9 );
}