<?php

if ( ! function_exists( 'gastrobar_edge_register_sidebars' ) ) {
	/**
	 * Function that registers theme's sidebars
	 */
	function gastrobar_edge_register_sidebars() {
		
		register_sidebar(
			array(
				'id'            => 'sidebar',
				'name'          => esc_html__( 'Sidebar', 'gastrobar' ),
				'description'   => esc_html__( 'Default Sidebar', 'gastrobar' ),
				'before_widget' => '<div id="%1$s" class="widget %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<div class="edgtf-widget-title-holder"><h5 class="edgtf-widget-title">',
				'after_title'   => '</h5></div>'
			)
		);
	}
	
	add_action( 'widgets_init', 'gastrobar_edge_register_sidebars', 1 );
}

if ( ! function_exists( 'gastrobar_edge_add_support_custom_sidebar' ) ) {
	/**
	 * Function that adds theme support for custom sidebars. It also creates GastrobarEdgePhpClassSidebar object
	 */
	function gastrobar_edge_add_support_custom_sidebar() {
		add_theme_support( 'GastrobarEdgePhpClassSidebar' );
		
		if ( get_theme_support( 'GastrobarEdgePhpClassSidebar' ) ) {
			new GastrobarEdgePhpClassSidebar();
		}
	}
	
	add_action( 'after_setup_theme', 'gastrobar_edge_add_support_custom_sidebar' );
}