<?php

if ( ! function_exists( 'gastrobar_edge_get_title_types_meta_boxes' ) ) {
	function gastrobar_edge_get_title_types_meta_boxes() {
		$title_type_options = apply_filters( 'gastrobar_edge_filter_title_type_meta_boxes', $title_type_options = array( '' => esc_html__( 'Default', 'gastrobar' ) ) );
		
		return $title_type_options;
	}
}

foreach ( glob( EDGE_FRAMEWORK_MODULES_ROOT_DIR . '/title/types/*/admin/meta-boxes/*.php' ) as $meta_box_load ) {
	include_once $meta_box_load;
}

if ( ! function_exists( 'gastrobar_edge_map_title_meta' ) ) {
	function gastrobar_edge_map_title_meta() {
		$title_type_meta_boxes = gastrobar_edge_get_title_types_meta_boxes();
		
		$title_meta_box = gastrobar_edge_create_meta_box(
			array(
				'scope' => apply_filters( 'gastrobar_edge_filter_set_scope_for_meta_boxes', array( 'page', 'post' ), 'title_meta' ),
				'title' => esc_html__( 'Title', 'gastrobar' ),
				'name'  => 'title_meta'
			)
		);
		
		gastrobar_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_show_title_area_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Show Title Area', 'gastrobar' ),
				'description'   => esc_html__( 'Disabling this option will turn off page title area', 'gastrobar' ),
				'parent'        => $title_meta_box,
				'options'       => gastrobar_edge_get_yes_no_select_array(),
				'args'          => array(
					'dependence' => true,
					'hide'       => array(
						''    => '',
						'no'  => '#edgtf_edgtf_show_title_area_meta_container',
						'yes' => ''
					),
					'show'       => array(
						''    => '#edgtf_edgtf_show_title_area_meta_container',
						'no'  => '',
						'yes' => '#edgtf_edgtf_show_title_area_meta_container'
					)
				)
			)
		);
		
			$show_title_area_meta_container = gastrobar_edge_add_admin_container(
				array(
					'parent'          => $title_meta_box,
					'name'            => 'edgtf_show_title_area_meta_container',
					'hidden_property' => 'edgtf_show_title_area_meta',
					'hidden_value'    => 'no'
				)
			);
		
				gastrobar_edge_create_meta_box_field(
					array(
						'name'          => 'edgtf_title_area_type_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Title Area Type', 'gastrobar' ),
						'description'   => esc_html__( 'Choose title type', 'gastrobar' ),
						'parent'        => $show_title_area_meta_container,
						'options'       => $title_type_meta_boxes
					)
				);
		
				gastrobar_edge_create_meta_box_field(
					array(
						'name'          => 'edgtf_title_area_in_grid_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Title Area In Grid', 'gastrobar' ),
						'description'   => esc_html__( 'Set title area content to be in grid', 'gastrobar' ),
						'options'       => gastrobar_edge_get_yes_no_select_array(),
						'parent'        => $show_title_area_meta_container
					)
				);
		
				gastrobar_edge_create_meta_box_field(
					array(
						'name'        => 'edgtf_title_area_height_meta',
						'type'        => 'text',
						'label'       => esc_html__( 'Height', 'gastrobar' ),
						'description' => esc_html__( 'Set a height for Title Area', 'gastrobar' ),
						'parent'      => $show_title_area_meta_container,
						'args'        => array(
							'col_width' => 2,
							'suffix'    => 'px'
						)
					)
				);
				
				gastrobar_edge_create_meta_box_field(
					array(
						'name'        => 'edgtf_title_area_background_color_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Background Color', 'gastrobar' ),
						'description' => esc_html__( 'Choose a background color for title area', 'gastrobar' ),
						'parent'      => $show_title_area_meta_container
					)
				);
		
				gastrobar_edge_create_meta_box_field(
					array(
						'name'        => 'edgtf_title_area_background_image_meta',
						'type'        => 'image',
						'label'       => esc_html__( 'Background Image', 'gastrobar' ),
						'description' => esc_html__( 'Choose an Image for title area', 'gastrobar' ),
						'parent'      => $show_title_area_meta_container
					)
				);
		
				gastrobar_edge_create_meta_box_field(
					array(
						'name'          => 'edgtf_title_area_background_image_behavior_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Background Image Behavior', 'gastrobar' ),
						'description'   => esc_html__( 'Choose title area background image behavior', 'gastrobar' ),
						'parent'        => $show_title_area_meta_container,
						'options'       => array(
							''                    => esc_html__( 'Default', 'gastrobar' ),
							'hide'                => esc_html__( 'Hide Image', 'gastrobar' ),
							'responsive'          => esc_html__( 'Enable Responsive Image', 'gastrobar' ),
							'responsive-disabled' => esc_html__( 'Disable Responsive Image', 'gastrobar' ),
							'parallax'            => esc_html__( 'Enable Parallax Image', 'gastrobar' ),
							'parallax-zoom-out'   => esc_html__( 'Enable Parallax With Zoom Out Image', 'gastrobar' ),
							'parallax-disabled'   => esc_html__( 'Disable Parallax Image', 'gastrobar' )
						)
					)
				);
				
				gastrobar_edge_create_meta_box_field(
					array(
						'name'          => 'edgtf_title_area_vertical_alignment_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Vertical Alignment', 'gastrobar' ),
						'description'   => esc_html__( 'Specify title area content vertical alignment', 'gastrobar' ),
						'parent'        => $show_title_area_meta_container,
						'options'       => array(
							''              => esc_html__( 'Default', 'gastrobar' ),
							'header-bottom' => esc_html__( 'From Bottom of Header', 'gastrobar' ),
							'window-top'    => esc_html__( 'From Window Top', 'gastrobar' )
						)
					)
				);
				
				gastrobar_edge_create_meta_box_field(
					array(
						'name'          => 'edgtf_title_area_title_tag_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Title Tag', 'gastrobar' ),
						'options'       => gastrobar_edge_get_title_tag( true ),
						'parent'        => $show_title_area_meta_container
					)
				);
				
				gastrobar_edge_create_meta_box_field(
					array(
						'name'        => 'edgtf_title_text_color_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Title Color', 'gastrobar' ),
						'description' => esc_html__( 'Choose a color for title text', 'gastrobar' ),
						'parent'      => $show_title_area_meta_container
					)
				);
				
				gastrobar_edge_create_meta_box_field(
					array(
						'name'          => 'edgtf_title_area_subtitle_meta',
						'type'          => 'text',
						'default_value' => '',
						'label'         => esc_html__( 'Subtitle Text', 'gastrobar' ),
						'description'   => esc_html__( 'Enter your subtitle text', 'gastrobar' ),
						'parent'        => $show_title_area_meta_container,
						'args'          => array(
							'col_width' => 6
						)
					)
				);
		
				gastrobar_edge_create_meta_box_field(
					array(
						'name'          => 'edgtf_title_area_subtitle_tag_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Subtitle Tag', 'gastrobar' ),
						'options'       => gastrobar_edge_get_title_tag( true, array( 'p' => 'p' ) ),
						'parent'        => $show_title_area_meta_container
					)
				);
				
				gastrobar_edge_create_meta_box_field(
					array(
						'name'        => 'edgtf_subtitle_color_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Subtitle Color', 'gastrobar' ),
						'description' => esc_html__( 'Choose a color for subtitle text', 'gastrobar' ),
						'parent'      => $show_title_area_meta_container
					)
				);
		
		/***************** Additional Title Area Layout - start *****************/
		
		do_action( 'gastrobar_edge_action_additional_title_area_meta_boxes', $show_title_area_meta_container );
		
		/***************** Additional Title Area Layout - end *****************/
		
	}
	
	add_action( 'gastrobar_edge_action_meta_boxes_map', 'gastrobar_edge_map_title_meta', 60 );
}