<?php

/**
 * Force Visual Composer to initialize as "built into the theme". This will hide certain tabs under the Settings->Visual Composer page
 */
if ( function_exists( 'vc_set_as_theme' ) ) {
	vc_set_as_theme( true );
}

/**
 * Change path for overridden templates
 */
if ( function_exists( 'vc_set_shortcodes_templates_dir' ) ) {
	$dir = EDGE_ROOT_DIR . '/vc-templates';
	vc_set_shortcodes_templates_dir( $dir );
}

if ( ! function_exists( 'gastrobar_edge_configure_visual_composer_frontend_editor' ) ) {
	/**
	 * Configuration for Visual Composer FrontEnd Editor
	 * Hooks on vc_after_init action
	 */
	function gastrobar_edge_configure_visual_composer_frontend_editor() {
		/**
		 * Remove frontend editor
		 */
		if ( function_exists( 'vc_disable_frontend' ) ) {
			vc_disable_frontend();
		}
	}
	
	add_action( 'vc_after_init', 'gastrobar_edge_configure_visual_composer_frontend_editor' );
}

if ( ! function_exists( 'gastrobar_edge_vc_row_map' ) ) {
	/**
	 * Map VC Row shortcode
	 * Hooks on vc_after_init action
	 */
	function gastrobar_edge_vc_row_map() {
		
		/******* VC Row shortcode - begin *******/
		
		vc_add_param( 'vc_row',
			array(
				'type'       => 'dropdown',
				'param_name' => 'row_content_width',
				'heading'    => esc_html__( 'Edge Row Content Width', 'gastrobar' ),
				'value'      => array(
					esc_html__( 'Full Width', 'gastrobar' ) => 'full-width',
					esc_html__( 'In Grid', 'gastrobar' )    => 'grid'
				),
				'group'      => esc_html__( 'Edge Settings', 'gastrobar' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'        => 'textfield',
				'param_name'  => 'anchor',
				'heading'     => esc_html__( 'Edge Anchor ID', 'gastrobar' ),
				'description' => esc_html__( 'For example "home"', 'gastrobar' ),
				'group'       => esc_html__( 'Edge Settings', 'gastrobar' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'       => 'colorpicker',
				'param_name' => 'simple_background_color',
				'heading'    => esc_html__( 'Edge Background Color', 'gastrobar' ),
				'group'      => esc_html__( 'Edge Settings', 'gastrobar' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'       => 'attach_image',
				'param_name' => 'simple_background_image',
				'heading'    => esc_html__( 'Edge Background Image', 'gastrobar' ),
				'group'      => esc_html__( 'Edge Settings', 'gastrobar' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'        => 'dropdown',
				'param_name'  => 'disable_background_image',
				'heading'     => esc_html__( 'Edge Disable Background Image', 'gastrobar' ),
				'value'       => array(
					esc_html__( 'Never', 'gastrobar' )        => '',
					esc_html__( 'Below 1280px', 'gastrobar' ) => '1280',
					esc_html__( 'Below 1024px', 'gastrobar' ) => '1024',
					esc_html__( 'Below 768px', 'gastrobar' )  => '768',
					esc_html__( 'Below 680px', 'gastrobar' )  => '680',
					esc_html__( 'Below 480px', 'gastrobar' )  => '480'
				),
				'save_always' => true,
				'description' => esc_html__( 'Choose on which stage you hide row background image', 'gastrobar' ),
				'dependency'  => array( 'element' => 'simple_background_image', 'not_empty' => true ),
				'group'       => esc_html__( 'Edge Settings', 'gastrobar' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'       => 'attach_image',
				'param_name' => 'parallax_background_image',
				'heading'    => esc_html__( 'Edge Parallax Background Image', 'gastrobar' ),
				'group'      => esc_html__( 'Edge Settings', 'gastrobar' )
			)
		);

		vc_add_param( 'vc_row',
			array(
				'type'       => 'attach_image',
				'param_name' => 'overlay_background_image',
				'heading'    => esc_html__( 'Edge Overlay Background Image', 'gastrobar' ),
				'group'      => esc_html__( 'Edge Settings', 'gastrobar' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'        => 'textfield',
				'param_name'  => 'parallax_bg_speed',
				'heading'     => esc_html__( 'Edge Parallax Speed', 'gastrobar' ),
				'description' => esc_html__( 'Set your parallax speed. Default value is 1.', 'gastrobar' ),
				'dependency'  => array( 'element' => 'parallax_background_image', 'not_empty' => true ),
				'group'       => esc_html__( 'Edge Settings', 'gastrobar' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'       => 'textfield',
				'param_name' => 'parallax_bg_height',
				'heading'    => esc_html__( 'Edge Parallax Section Height (px)', 'gastrobar' ),
				'dependency' => array( 'element' => 'parallax_background_image', 'not_empty' => true ),
				'group'      => esc_html__( 'Edge Settings', 'gastrobar' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'       => 'dropdown',
				'param_name' => 'content_text_aligment',
				'heading'    => esc_html__( 'Edge Content Aligment', 'gastrobar' ),
				'value'      => array(
					esc_html__( 'Default', 'gastrobar' ) => '',
					esc_html__( 'Left', 'gastrobar' )    => 'left',
					esc_html__( 'Center', 'gastrobar' )  => 'center',
					esc_html__( 'Right', 'gastrobar' )   => 'right'
				),
				'group'      => esc_html__( 'Edge Settings', 'gastrobar' )
			)
		);
		
		/******* VC Row shortcode - end *******/
		
		/******* VC Row Inner shortcode - begin *******/
		
		vc_add_param( 'vc_row_inner',
			array(
				'type'       => 'dropdown',
				'param_name' => 'row_content_width',
				'heading'    => esc_html__( 'Edge Row Content Width', 'gastrobar' ),
				'value'      => array(
					esc_html__( 'Full Width', 'gastrobar' ) => 'full-width',
					esc_html__( 'In Grid', 'gastrobar' )    => 'grid'
				),
				'group'      => esc_html__( 'Edge Settings', 'gastrobar' )
			)
		);
		
		vc_add_param( 'vc_row_inner',
			array(
				'type'       => 'colorpicker',
				'param_name' => 'simple_background_color',
				'heading'    => esc_html__( 'Edge Background Color', 'gastrobar' ),
				'group'      => esc_html__( 'Edge Settings', 'gastrobar' )
			)
		);
		
		vc_add_param( 'vc_row_inner',
			array(
				'type'       => 'attach_image',
				'param_name' => 'simple_background_image',
				'heading'    => esc_html__( 'Edge Background Image', 'gastrobar' ),
				'group'      => esc_html__( 'Edge Settings', 'gastrobar' )
			)
		);
		
		vc_add_param( 'vc_row_inner',
			array(
				'type'        => 'dropdown',
				'param_name'  => 'disable_background_image',
				'heading'     => esc_html__( 'Edge Disable Background Image', 'gastrobar' ),
				'value'       => array(
					esc_html__( 'Never', 'gastrobar' )        => '',
					esc_html__( 'Below 1280px', 'gastrobar' ) => '1280',
					esc_html__( 'Below 1024px', 'gastrobar' ) => '1024',
					esc_html__( 'Below 768px', 'gastrobar' )  => '768',
					esc_html__( 'Below 680px', 'gastrobar' )  => '680',
					esc_html__( 'Below 480px', 'gastrobar' )  => '480'
				),
				'save_always' => true,
				'description' => esc_html__( 'Choose on which stage you hide row background image', 'gastrobar' ),
				'dependency'  => array( 'element' => 'simple_background_image', 'not_empty' => true ),
				'group'       => esc_html__( 'Edge Settings', 'gastrobar' )
			)
		);
		
		vc_add_param( 'vc_row_inner',
			array(
				'type'       => 'dropdown',
				'param_name' => 'content_text_aligment',
				'heading'    => esc_html__( 'Edge Content Aligment', 'gastrobar' ),
				'value'      => array(
					esc_html__( 'Default', 'gastrobar' ) => '',
					esc_html__( 'Left', 'gastrobar' )    => 'left',
					esc_html__( 'Center', 'gastrobar' )  => 'center',
					esc_html__( 'Right', 'gastrobar' )   => 'right'
				),
				'group'      => esc_html__( 'Edge Settings', 'gastrobar' )
			)
		);
		
		/******* VC Row Inner shortcode - end *******/

		/******* VC Column shortcode - begin *******/

		vc_add_param( 'vc_column',
			array(
				'type'       => 'attach_image',
				'param_name' => 'overlapping_image',
				'heading'    => esc_html__( 'Edge Overlapping Image', 'gastrobar' ),
				'group'       => esc_html__( 'Edge Overlapping Image', 'gastrobar' )
			)
		);

		vc_add_param( 'vc_column',
			array(
				'type'        => 'textfield',
				'param_name'  => 'overlapping_image_top',
				'heading'     => esc_html__( 'Edge Overlapping Image Top Offset (px, or %)', 'gastrobar' ),
				'description' => esc_html__( 'Set the top offset for the overlapping image with px or % next to the value', 'gastrobar' ),
				'dependency'  => array( 'element' => 'overlapping_image', 'not_empty' => true ),
				'group'       => esc_html__( 'Edge Overlapping Image', 'gastrobar' )
			)
		);

		vc_add_param( 'vc_column',
			array(
				'type'        => 'textfield',
				'param_name'  => 'overlapping_image_left',
				'heading'     => esc_html__( 'Edge Overlapping Image Left Offset (px, or %)', 'gastrobar' ),
				'description' => esc_html__( 'Set the left offset for the overlapping image with px or % next to the value', 'gastrobar' ),
				'dependency'  => array( 'element' => 'overlapping_image', 'not_empty' => true ),
				'group'       => esc_html__( 'Edge Overlapping Image', 'gastrobar' )
			)
		);

		vc_add_param( 'vc_column',
			array(
				'type'        => 'dropdown',
				'param_name'  => 'overlapping_image_center',
				'heading'     => esc_html__( 'Edge Center Image', 'gastrobar' ),
				'value'       => array_flip( gastrobar_edge_get_yes_no_select_array( false ) ),
				'dependency'  => array( 'element' => 'overlapping_image', 'not_empty' => true ),
				'save_always' => true,
				'group'       => esc_html__( 'Edge Overlapping Image', 'gastrobar' )
			)
		);

		vc_add_param( 'vc_column',
			array(
				'type'        => 'dropdown',
				'param_name'  => 'overlapping_image_disable',
				'heading'     => esc_html__( 'Edge Disable Image On Small Devices', 'gastrobar' ),
				'value'       => array_flip( gastrobar_edge_get_yes_no_select_array( false ) ),
				'dependency'  => array( 'element' => 'overlapping_image', 'not_empty' => true ),
				'save_always' => true,
				'group'       => esc_html__( 'Edge Overlapping Image', 'gastrobar' )
			)
		);

		/******* VC Column shortcode - end *******/
		
		/******* VC Revolution Slider shortcode - begin *******/
		
		if ( gastrobar_edge_revolution_slider_installed() ) {
			
			vc_add_param( 'rev_slider_vc',
				array(
					'type'        => 'dropdown',
					'param_name'  => 'enable_paspartu',
					'heading'     => esc_html__( 'Edge Enable Passepartout', 'gastrobar' ),
					'value'       => array_flip( gastrobar_edge_get_yes_no_select_array( false ) ),
					'save_always' => true,
					'group'       => esc_html__( 'Edge Settings', 'gastrobar' )
				)
			);
			
			vc_add_param( 'rev_slider_vc',
				array(
					'type'        => 'dropdown',
					'param_name'  => 'paspartu_size',
					'heading'     => esc_html__( 'Edge Passepartout Size', 'gastrobar' ),
					'value'       => array(
						esc_html__( 'Tiny', 'gastrobar' )   => 'tiny',
						esc_html__( 'Small', 'gastrobar' )  => 'small',
						esc_html__( 'Normal', 'gastrobar' ) => 'normal',
						esc_html__( 'Large', 'gastrobar' )  => 'large'
					),
					'save_always' => true,
					'dependency'  => array( 'element' => 'enable_paspartu', 'value' => array( 'yes' ) ),
					'group'       => esc_html__( 'Edge Settings', 'gastrobar' )
				)
			);
			
			vc_add_param( 'rev_slider_vc',
				array(
					'type'        => 'dropdown',
					'param_name'  => 'disable_side_paspartu',
					'heading'     => esc_html__( 'Edge Disable Side Passepartout', 'gastrobar' ),
					'value'       => array_flip( gastrobar_edge_get_yes_no_select_array( false ) ),
					'save_always' => true,
					'dependency'  => array( 'element' => 'enable_paspartu', 'value' => array( 'yes' ) ),
					'group'       => esc_html__( 'Edge Settings', 'gastrobar' )
				)
			);
			
			vc_add_param( 'rev_slider_vc',
				array(
					'type'        => 'dropdown',
					'param_name'  => 'disable_top_paspartu',
					'heading'     => esc_html__( 'Edge Disable Top Passepartout', 'gastrobar' ),
					'value'       => array_flip( gastrobar_edge_get_yes_no_select_array( false ) ),
					'save_always' => true,
					'dependency'  => array( 'element' => 'enable_paspartu', 'value' => array( 'yes' ) ),
					'group'       => esc_html__( 'Edge Settings', 'gastrobar' )
				)
			);
		}
		
		/******* VC Revolution Slider shortcode - end *******/


	}
	
	add_action( 'vc_after_init', 'gastrobar_edge_vc_row_map' );
}