<?php

class GastrobarEdgePhpClassButtonWidget extends GastrobarEdgePhpClassWidget {
	public function __construct() {
		parent::__construct(
			'edgtf_button_widget',
			esc_html__( 'Edge Button Widget', 'gastrobar' ),
			array( 'description' => esc_html__( 'Add button element to widget areas', 'gastrobar' ) )
		);
		
		$this->setParams();
	}
	
	protected function setParams() {
		$this->params = array(
			array(
				'type'    => 'dropdown',
				'name'    => 'type',
				'title'   => esc_html__( 'Type', 'gastrobar' ),
				'options' => array(
					'solid'   => esc_html__( 'Solid', 'gastrobar' ),
					'outline' => esc_html__( 'Outline', 'gastrobar' ),
					'simple'  => esc_html__( 'Simple', 'gastrobar' )
				)
			),
			array(
				'type'        => 'dropdown',
				'name'        => 'size',
				'title'       => esc_html__( 'Size', 'gastrobar' ),
				'options'     => array(
					'small'  => esc_html__( 'Small', 'gastrobar' ),
					'medium' => esc_html__( 'Medium', 'gastrobar' ),
					'large'  => esc_html__( 'Large', 'gastrobar' ),
					'huge'   => esc_html__( 'Huge', 'gastrobar' )
				),
				'description' => esc_html__( 'This option is only available for solid and outline button type', 'gastrobar' )
			),
			array(
				'type'    => 'textfield',
				'name'    => 'text',
				'title'   => esc_html__( 'Text', 'gastrobar' ),
				'default' => esc_html__( 'Button Text', 'gastrobar' )
			),
			array(
				'type'  => 'textfield',
				'name'  => 'link',
				'title' => esc_html__( 'Link', 'gastrobar' )
			),
			array(
				'type'    => 'dropdown',
				'name'    => 'target',
				'title'   => esc_html__( 'Link Target', 'gastrobar' ),
				'options' => gastrobar_edge_get_link_target_array()
			),
			array(
				'type'  => 'textfield',
				'name'  => 'color',
				'title' => esc_html__( 'Color', 'gastrobar' )
			),
			array(
				'type'  => 'textfield',
				'name'  => 'hover_color',
				'title' => esc_html__( 'Hover Color', 'gastrobar' )
			),
			array(
				'type'        => 'textfield',
				'name'        => 'background_color',
				'title'       => esc_html__( 'Background Color', 'gastrobar' ),
				'description' => esc_html__( 'This option is only available for solid button type', 'gastrobar' )
			),
			array(
				'type'        => 'textfield',
				'name'        => 'hover_background_color',
				'title'       => esc_html__( 'Hover Background Color', 'gastrobar' ),
				'description' => esc_html__( 'This option is only available for solid button type', 'gastrobar' )
			),
			array(
				'type'        => 'textfield',
				'name'        => 'border_color',
				'title'       => esc_html__( 'Border Color', 'gastrobar' ),
				'description' => esc_html__( 'This option is only available for solid and outline button type', 'gastrobar' )
			),
			array(
				'type'        => 'textfield',
				'name'        => 'hover_border_color',
				'title'       => esc_html__( 'Hover Border Color', 'gastrobar' ),
				'description' => esc_html__( 'This option is only available for solid and outline button type', 'gastrobar' )
			),
            array(
                'type'        => 'textfield',
                'name'        => 'box_shadow_color',
                'title'       => esc_html__( 'Box Shadow Color', 'gastrobar' ),
                'description' => esc_html__( 'This option is only available for outline button type', 'gastrobar' )
            ),
			array(
				'type'        => 'textfield',
				'name'        => 'margin',
				'title'       => esc_html__( 'Margin', 'gastrobar' ),
				'description' => esc_html__( 'Insert margin in format: top right bottom left (e.g. 10px 5px 10px 5px)', 'gastrobar' )
			)
		);
	}
	
	public function widget( $args, $instance ) {
		$params = '';
		
		if ( ! is_array( $instance ) ) {
			$instance = array();
		}
		
		// Filter out all empty params
		$instance = array_filter( $instance, function ( $array_value ) {
			return trim( $array_value ) != '';
		} );
		
		// Default values
		if ( ! isset( $instance['text'] ) ) {
			$instance['text'] = 'Button Text';
		}
		
		// Generate shortcode params
		foreach ( $instance as $key => $value ) {
			$params .= " $key='$value' ";
		}
		
		echo '<div class="widget edgtf-button-widget">';
			echo do_shortcode( "[edgtf_button $params]" ); // XSS OK
		echo '</div>';
	}
}