<?php

class GastrobarEdgePhpClassIconTextWidget extends GastrobarEdgePhpClassWidget {
	public function __construct() {
		parent::__construct(
			'edgtf_icon_text_widget',
			esc_html__( 'Edge Icon With Text Widget', 'gastrobar' ),
			array( 'description' => esc_html__( 'Add icon with multi line text to widget areas', 'gastrobar' ) )
		);
		
		$this->setParams();
	}
	
	protected function setParams() {
		$this->params = array_merge(
			gastrobar_edge_icon_collections()->getIconWidgetParamsArray(),
			array(
				array(
					'type'  => 'textfield',
					'name'  => 'icon_size',
					'title' => esc_html__( 'Icon Size (px)', 'gastrobar' )
				),
				array(
					'type'  => 'textfield',
					'name'  => 'color',
					'title' => esc_html__( 'Color', 'gastrobar' )
				),
				array(
					'type'  => 'textfield',
					'name'  => 'extra_class',
					'title' => esc_html__( 'Extra Class Name', 'gastrobar' )
				),
				array(
					'type'  => 'textfield',
					'name'  => 'widget_title',
					'title' => esc_html__( 'Widget Title', 'gastrobar' )
				),
				array(
					'type'  => 'textarea',
					'name'  => 'content',
					'title' => esc_html__( 'Content', 'gastrobar' )
				)
			)
		);
	}
	
	public function widget( $args, $instance ) {
		$extra_class   = array();
		$extra_class[] = ! empty( $instance['extra_class'] ) ? $instance['extra_class'] : '';
		$extra_class[] = ! empty( $instance['widget_grid'] ) && $instance['widget_grid'] === 'auto' ? 'edgtf-grid-auto-width' : '';

		$holder_styles = array();
		if ( ! empty( $instance['color'] ) ) {
			$holder_styles[] = 'color: ' . $instance['color'];
		}

		$icon_styles = array();
		if ( ! empty( $instance['icon_size'] ) ) {
			$icon_styles[] = 'font-size: ' . gastrobar_edge_filter_px( $instance['icon_size'] ) . 'px';
		}

		$icon_holder_html = '';
		if ( ! empty( $instance['icon_pack'] ) ) {
			$icon_class   = array();
			$icon_class[] = ! empty( $instance['fa_icon'] ) && $instance['icon_pack'] === 'font_awesome' ? 'fa ' . $instance['fa_icon'] : '';
			$icon_class[] = ! empty( $instance['fe_icon'] ) && $instance['icon_pack'] === 'font_elegant' ? $instance['fe_icon'] : '';
			$icon_class[] = ! empty( $instance['ion_icon'] ) && $instance['icon_pack'] === 'ion_icons' ? $instance['ion_icon'] : '';
			$icon_class[] = ! empty( $instance['linea_icon'] ) && $instance['icon_pack'] === 'linea_icons' ? $instance['linea_icon'] : '';
			$icon_class[] = ! empty( $instance['linear_icon'] ) && $instance['icon_pack'] === 'linear_icons' ? 'lnr ' . $instance['linear_icon'] : '';
			$icon_class[] = ! empty( $instance['simple_line_icon'] ) && $instance['icon_pack'] === 'simple_line_icons' ? $instance['simple_line_icon'] : '';

			$icon_class = array_filter( $icon_class, function ( $value ) {
				return $value !== '';
			} );

			if ( ! empty( $icon_class ) ) {
				$icon_class = implode( ' ', $icon_class );

				$icon_holder_html = '<span class="edgtf-icon-element ' . esc_attr( $icon_class ) . '" ' . gastrobar_edge_get_inline_style( $icon_styles ) . '></span>';
			}
		}
		?>
		
		<div class="widget edgtf-icon-text-widget <?php echo esc_attr( implode( ' ', $extra_class ) ); ?>" <?php echo gastrobar_edge_get_inline_style( $holder_styles ); ?>>
			<?php
			if ( ! empty( $instance['widget_title'] ) ) {
				echo wp_kses_post( $args['before_title'] ) . esc_html( $instance['widget_title'] ) . wp_kses_post( $args['after_title'] );
			}

			if ( ! empty( $instance['content'] ) ) {
				$lines = explode("\n", $instance['content']);

				echo wp_kses( $icon_holder_html, array(
					'span' => array(
						'class' => true
					)
				) );

				echo '<span class="edgtf-it-content">';

				if ( is_array( $lines ) ) {

					foreach( $lines as $line ) {
						echo '<span class="edgtf-ct-line">' . esc_html($line) . '</span><br/>';
					}
				} else {
					echo esc_html($lines);
				}

				echo '</span>';
			}
			?>
		</div>
		<?php
	}
}