<?php

class GastrobarEdgePhpClassOpeningHoursWidget extends GastrobarEdgePhpClassWidget {
	public function __construct() {
		parent::__construct(
			'edgtf_opening_hours_widget',
			esc_html__( 'Edge Opening Hours Widget', 'gastrobar' ),
			array( 'description' => esc_html__( 'Add a opening hours element to your widget areas', 'gastrobar' ) )
		);
		
		$this->setParams();
	}
	
	protected function setParams() {
		$days = array();
		for ( $n = 1; $n <= 7; $n++ ) {
			$days[] = array(
				'type'        => 'textfield',
				'name'        => 'day_' . $n,
				'title'       => sprintf( '%s %s %s', esc_html__('Day', 'gastrobar'), $n, esc_html__('of the Week', 'gastrobar') ),
			);

			// Add hours option bellow each day
			$days[] = array(
				'type'        => 'textfield',
				'name'        => 'hours_' . $n,
				'title'       => sprintf( '%s %s', esc_html__('Hours For Day', 'gastrobar'), $n ),
				'description' => esc_html__('eg: 9:00 - 22:00 ', 'gastrobar'),
			);
		}

		$this->params = array_merge(
			array(
				array(
					'type'        => 'textfield',
					'name'        => 'widget_title',
					'title'       => esc_html__('Widget Title', 'gastrobar'),
					'save_always' => true,
				),
				array(
					'type'        => 'dropdown',
					'name'        => 'width',
					'title'       => esc_html__('Use Our Predefined Width', 'gastrobar'),
					'options'     => gastrobar_edge_get_yes_no_select_array( false ),
					'save_always' => true,
				),
			),
			$days,
            array(
	            array(
		            'type'        => 'textfield',
		            'name'        => 'day_color',
		            'title'       => esc_html__('Days Label Color', 'gastrobar'),
		            'save_always' => true,
	            ),
	            array(
		            'type'        => 'textfield',
		            'name'        => 'hours_color',
		            'title'       => esc_html__('Hours Label Color', 'gastrobar'),
		            'save_always' => true,
	            ),
	            array(
		            'type'        => 'textfield',
		            'name'        => 'dots_color',
		            'title'       => esc_html__('Dots Color', 'gastrobar'),
		            'save_always' => true,
	            ),
            )
		);
	}
	
	public function widget( $args, $instance ) {
		if ( ! is_array( $instance ) ) {
			$instance = array();
		}

		
		echo '<div class="widget edgtf-opening-hours-widget ' . ($instance['width'] === 'yes' ? 'edgtf-predefined-width' : '') .'">';
			 if ( ! empty( $instance['widget_title'] ) ) {
				echo wp_kses_post( $args['before_title'] ) . esc_html( $instance['widget_title'] ) . wp_kses_post( $args['after_title'] );
			}

			for ( $n = 1; $n <= 7; $n++ ) {
				//prepare variables
				$params = array();
				$params = $instance;

				if ( !empty( $instance['day_' . $n] )  ) {
					$params['day'] = $instance['day_' . $n];
					$params['hours'] = $instance['hours_' . $n];

					echo gastrobar_edge_execute_shortcode( 'edgtf_opening_hours', $params );
				}
			}
		echo '</div>';
	}
}