<?php

class GastrobarEdgePhpClassSocialIconsWidget extends GastrobarEdgePhpClassWidget {
	public function __construct() {
		parent::__construct(
			'edgtf_social_icons_widget',
			esc_html__( 'Edge Social Icons Group Widget', 'gastrobar' ),
			array( 'description' => esc_html__( 'Use this widget to add a group of up to 5 social icons to a widget area.', 'gastrobar' ) )
		);

		$this->setParams();
	}

	protected function setParams() {
		$this->params = array_merge(
			array(
				array(
					'type'  => 'textfield',
					'name'  => 'widget_title',
					'title' => esc_html__( 'Widget Title', 'gastrobar' )
				)
			),
			gastrobar_edge_icon_collections()->getSocialIconWidgetMultipleParamsArray(7),
			array(
				array(
					'type'    => 'dropdown',
					'name'    => 'layout',
					'title'   => esc_html__( 'Icons Layout', 'gastrobar' ),
					'options' => array(
						''                   => esc_html__( 'Default', 'gastrobar' ),
						'edgtf-square-icons' => esc_html__( 'Square', 'gastrobar' ),
					)
				),
				array(
					'type'        => 'dropdown',
					'name'        => 'skin',
					'title'       => esc_html__( 'Square Icons Skin', 'gastrobar' ),
					'description' => esc_html__( 'This applies to the square layout', 'gastrobar' ),
					'options'     => array(
						''                 => esc_html__( 'Dark Skin', 'gastrobar' ),
						'edgtf-light-skin' => esc_html__( 'Light Skin', 'gastrobar' ),
					)
				),
				array(
					'type'  => 'textfield',
					'name'  => 'icon_size',
					'title' => esc_html__( 'Icons Size (px)', 'gastrobar' )
				),
				array(
					'type'  => 'textfield',
					'name'  => 'color',
					'title' => esc_html__( 'Color', 'gastrobar' )
				),
				array(
					'type'  => 'textfield',
					'name'  => 'hover_color',
					'title' => esc_html__( 'Hover Color', 'gastrobar' )
				),
				array(
					'type'        => 'textfield',
					'name'        => 'margin',
					'title'       => esc_html__( 'Margin', 'gastrobar' ),
					'description' => esc_html__( 'Insert margin in format: top right bottom left (e.g. 10px 5px 10px 5px)', 'gastrobar' )
				)
			)
		);
	}
	
	public function widget( $args, $instance ) {
		$icon_styles = array();
		$class = array( $instance['layout'], $instance['skin'] );
		
		if ( ! empty( $instance['color'] ) ) {
			$icon_styles[] = 'color: ' . $instance['color'] . ';';
		}
		
		if ( ! empty( $instance['icon_size'] ) ) {
			$icon_styles[] = 'font-size: ' . gastrobar_edge_filter_px( $instance['icon_size'] ) . 'px';
		}
		
		if ( ! empty( $instance['margin'] ) ) {
			$icon_styles[] = 'margin: ' . $instance['margin'] . ';';
		}

		$hover_color = ! empty( $instance['hover_color'] ) ? $instance['hover_color'] : '';
		$class = implode( ' ', $class );

		echo '<div class="widget edgtf-social-icons-widget ' . esc_attr($class) . '">';

		if ( ! empty( $instance['widget_title'] ) ) {
			echo wp_kses_post( $args['before_title'] ) . esc_html( $instance['widget_title'] ) . wp_kses_post( $args['after_title'] );
		}

		for ( $n = 1; $n <= 5; $n++ ) {
			$link   = ! empty( $instance[ 'link_' . $n ] ) ? $instance[ 'link_' . $n ] : '#';
			$target = ! empty( $instance['target_' . $n] ) ? $instance['target_' . $n] : '_self';

			$icon_holder_html = '';
			if ( ! empty( $instance['icon_pack_'.$n] ) ) {
				$icon_class   = array( 'edgtf-social-icon-widget' );
                if ( ! empty( $instance['fa_icon_'.$n] ) && $instance['icon_pack_'.$n] === 'font_awesome' ) {
                    $icon_class[] =  'fa ' . $instance['fa_icon_'.$n];
                }

                if (  ! empty( $instance['fe_icon_'.$n] ) && $instance['icon_pack_'.$n] === 'font_elegant' ) {
                    $icon_class[] = $instance['fe_icon_'.$n];
                }

                if ( ! empty( $instance['ion_icon_'.$n] ) && $instance['icon_pack_'.$n] === 'ion_icons' ) {
                    $icon_class[] =  $instance['ion_icon_'.$n];
                }

                if ( ! empty( $instance['icomoon_'.$n] ) && $instance['icon_pack_'.$n] === 'icomoon_icons' ) {
                    $icon_class[] =  $instance['icomoon_'.$n];
                }

				if ( ! empty( $icon_class ) && isset($icon_class[1]) && ! empty($icon_class[1]) ) {
					$icon_class = implode( ' ', $icon_class );
					$icon_holder_html = '<span class="' . $icon_class . '"></span>';
				} else {
					$icon_holder_html = '';
				}
			}
			?>
			<?php if ( ! empty($icon_holder_html) ) { ?>
				<a class="edgtf-social-icon-widget-holder edgtf-icon-has-hover" <?php echo gastrobar_edge_get_inline_attr( $hover_color, 'data-hover-color' ); ?> <?php gastrobar_edge_inline_style( $icon_styles ) ?> href="<?php echo esc_url( $link ); ?>" target="<?php echo esc_attr( $target ); ?>">
					<?php echo wp_kses_post( $icon_holder_html ); ?>
				</a>
			<?php }
		}
		echo '</div>';
	}
}