<?php

if(!function_exists('gastrobar_edge_map_woocommerce_meta')) {
    function gastrobar_edge_map_woocommerce_meta() {
        $woocommerce_meta_box = gastrobar_edge_create_meta_box(
            array(
                'scope' => array('product'),
                'title' => esc_html__('Product Meta', 'gastrobar'),
                'name' => 'woo_product_meta'
            )
        );

        gastrobar_edge_create_meta_box_field(array(
            'name'        => 'edgtf_product_featured_image_size',
            'type'        => 'select',
            'label'       => esc_html__('Dimensions for Product List Shortcode', 'gastrobar'),
            'description' => esc_html__('Choose image layout when it appears in Edge Product List - Masonry layout shortcode', 'gastrobar'),
            'parent'      => $woocommerce_meta_box,
            'options'     => array(
                'edgtf-woo-image-normal-width' => esc_html__('Default', 'gastrobar'),
                'edgtf-woo-image-large-width'  => esc_html__('Large Width', 'gastrobar')
            )
        ));

        gastrobar_edge_create_meta_box_field(
            array(
                'name'          => 'edgtf_show_title_area_woo_meta',
                'type'          => 'select',
                'default_value' => '',
                'label'         => esc_html__('Show Title Area', 'gastrobar'),
                'description'   => esc_html__('Disabling this option will turn off page title area', 'gastrobar'),
                'parent'        => $woocommerce_meta_box,
                'options'       => gastrobar_edge_get_yes_no_select_array()
            )
        );

        gastrobar_edge_create_meta_box_field(array(
            'name'        => 'edgtf_single_product_new_meta',
            'type'        => 'select',
            'label'       => esc_html__('Enable New Product Mark', 'gastrobar'),
            'description' => esc_html__('Enabling this option will show new product mark on your product lists and product single', 'gastrobar'),
            'parent'      => $woocommerce_meta_box,
            'options'     => array(
                'no'  => esc_html__('No', 'gastrobar'),
                'yes' => esc_html__('Yes', 'gastrobar')
            )
        ));
    }
	
    add_action('gastrobar_edge_action_meta_boxes_map', 'gastrobar_edge_map_woocommerce_meta', 99);
}