<?php

if ( ! function_exists( 'gastrobar_edge_woocommerce_options_map' ) ) {
	
	/**
	 * Add Woocommerce options page
	 */
	function gastrobar_edge_woocommerce_options_map() {
		
		gastrobar_edge_add_admin_page(
			array(
				'slug'  => '_woocommerce_page',
				'title' => esc_html__( 'Woocommerce', 'gastrobar' ),
				'icon'  => 'fa fa-shopping-cart'
			)
		);
		
		/**
		 * Product List Settings
		 */
		$panel_product_list = gastrobar_edge_add_admin_panel(
			array(
				'page'  => '_woocommerce_page',
				'name'  => 'panel_product_list',
				'title' => esc_html__( 'Product List', 'gastrobar' )
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'edgtf_woo_product_list_columns',
				'label'         => esc_html__( 'Product List Columns', 'gastrobar' ),
				'default_value' => 'edgtf-woocommerce-columns-4',
				'description'   => esc_html__( 'Choose number of columns for product listing and related products on single product', 'gastrobar' ),
				'options'       => array(
					'edgtf-woocommerce-columns-3' => esc_html__( '3 Columns', 'gastrobar' ),
					'edgtf-woocommerce-columns-4' => esc_html__( '4 Columns', 'gastrobar' )
				),
				'parent'        => $panel_product_list,
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'edgtf_woo_product_list_columns_space',
				'label'         => esc_html__( 'Space Between Items', 'gastrobar' ),
				'description'   => esc_html__( 'Select space between items for product listing and related products on single product', 'gastrobar' ),
				'default_value' => 'normal',
				'options'       => gastrobar_edge_get_space_between_items_array(),
				'parent'        => $panel_product_list,
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'edgtf_woo_product_list_info_position',
				'label'         => esc_html__( 'Product Info Position', 'gastrobar' ),
				'default_value' => 'info_below_image',
				'description'   => esc_html__( 'Select product info position for product listing and related products on single product', 'gastrobar' ),
				'options'       => array(
					'info_below_image'    => esc_html__( 'Info Below Image', 'gastrobar' ),
					'info_on_image_hover' => esc_html__( 'Info On Image Hover', 'gastrobar' )
				),
				'parent'        => $panel_product_list,
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'type'          => 'text',
				'name'          => 'edgtf_woo_products_per_page',
				'label'         => esc_html__( 'Number of products per page', 'gastrobar' ),
				'description'   => esc_html__( 'Set number of products on shop page', 'gastrobar' ),
				'parent'        => $panel_product_list,
				'args'          => array(
					'col_width' => 3
				)
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'edgtf_products_list_title_tag',
				'label'         => esc_html__( 'Products Title Tag', 'gastrobar' ),
				'default_value' => 'h5',
				'options'       => gastrobar_edge_get_title_tag(),
				'parent'        => $panel_product_list,
			)
		);
		
		/**
		 * Single Product Settings
		 */
		$panel_single_product = gastrobar_edge_add_admin_panel(
			array(
				'page'  => '_woocommerce_page',
				'name'  => 'panel_single_product',
				'title' => esc_html__( 'Single Product', 'gastrobar' )
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'show_title_area_woo',
				'default_value' => '',
				'label'         => esc_html__( 'Show Title Area', 'gastrobar' ),
				'description'   => esc_html__( 'Enabling this option will show title area on single post pages', 'gastrobar' ),
				'parent'        => $panel_single_product,
				'options'       => gastrobar_edge_get_yes_no_select_array(),
				'args'          => array(
					'col_width' => 3
				)
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'edgtf_single_product_title_tag',
				'default_value' => 'h2',
				'label'         => esc_html__( 'Single Product Title Tag', 'gastrobar' ),
				'options'       => gastrobar_edge_get_title_tag(),
				'parent'        => $panel_single_product,
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'woo_number_of_thumb_images',
				'default_value' => '4',
				'label'         => esc_html__( 'Number of Thumbnail Images per Row', 'gastrobar' ),
				'options'       => array(
					'4' => esc_html__( 'Four', 'gastrobar' ),
					'3' => esc_html__( 'Three', 'gastrobar' ),
					'2' => esc_html__( 'Two', 'gastrobar' )
				),
				'parent'        => $panel_single_product
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'woo_set_thumb_images_position',
				'default_value' => 'below-image',
				'label'         => esc_html__( 'Set Thumbnail Images Position', 'gastrobar' ),
				'options'       => array(
					'below-image'  => esc_html__( 'Below Featured Image', 'gastrobar' ),
					'on-left-side' => esc_html__( 'On The Left Side Of Featured Image', 'gastrobar' )
				),
				'parent'        => $panel_single_product
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'woo_enable_single_product_zoom_image',
				'default_value' => 'no',
				'label'         => esc_html__( 'Enable Zoom Maginfier', 'gastrobar' ),
				'description'   => esc_html__( 'Enabling this option will show magnifier image on featured image hover', 'gastrobar' ),
				'parent'        => $panel_single_product,
				'options'       => gastrobar_edge_get_yes_no_select_array( false ),
				'args'          => array(
					'col_width' => 3
				)
			)
		);
		
		gastrobar_edge_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'woo_set_single_images_behavior',
				'default_value' => 'pretty-photo',
				'label'         => esc_html__( 'Set Images Behavior', 'gastrobar' ),
				'options'       => array(
					'pretty-photo' => esc_html__( 'Pretty Photo Lightbox', 'gastrobar' ),
					'photo-swipe'  => esc_html__( 'Photo Swipe Lightbox', 'gastrobar' )
				),
				'parent'        => $panel_single_product
			)
		);
	}
	
	add_action( 'gastrobar_edge_action_options_map', 'gastrobar_edge_woocommerce_options_map', 21 );
}