(function($) {
	'use strict';

	var woocommerce = {};
	edgtf.modules.woocommerce = woocommerce;

	woocommerce.edgtfOnDocumentReady = edgtfOnDocumentReady;
	woocommerce.edgtfOnWindowLoad = edgtfOnWindowLoad;
	woocommerce.edgtfOnWindowResize = edgtfOnWindowResize;

	$(document).ready(edgtfOnDocumentReady);
	$(window).on('load',edgtfOnWindowLoad);
	$(window).resize(edgtfOnWindowResize);

	/*
        All functions to be called on $(document).ready() should be in this function
    */
	function edgtfOnDocumentReady() {
		edgtfInitAddToCartMarkup();
		edgtfInitQuantityButtons();
		edgtfInitSelect2();
		edgtfInitSingleProductLightbox();
	}

	/*
        All functions to be called on $(window).on('load', ) should be in this function
    */
	function edgtfOnWindowLoad() {
		edgtfInitProductListMasonryShortcode();
	}

	/*
        All functions to be called on $(window).resize() should be in this function
    */
	function edgtfOnWindowResize() {
		edgtfInitProductListMasonryShortcode();
	}

	/*
	 ** Add additional Markup for view cart button
	 */
	function edgtfInitAddToCartMarkup() {
		var buttonHolder = $('ul.products .edgtf-pl-add-to-cart');

		if(buttonHolder.length) {
			var currentButtonHolder = $(this),
				addToCart = currentButtonHolder.find('.add_to_cart_button');

			edgtf.body.on('click', addToCart, function () {

				setTimeout(function () {
					var addedToCart = $('.added_to_cart');

					if(addedToCart.length) {
						addedToCart.each(function(){
							var $this = $(this);

							if ( $this.find('span').length <= 0 ) {
								$this.wrapInner( "<span class='edgtf-btn-text' />");
							}
						});
					}
				}, 1800);
			});
		}
	}

	/*
    ** Init quantity buttons to increase/decrease products for cart
    */
	function edgtfInitQuantityButtons() {
		$(document).on('click', '.edgtf-quantity-minus, .edgtf-quantity-plus', function (e) {
			e.stopPropagation();

			var button = $(this),
				inputField = button.parent().siblings('.edgtf-quantity-input'),
				step = parseFloat(inputField.data('step')),
				max = parseFloat(inputField.data('max')),
				minus = false,
				inputValue = typeof Number.isNaN === 'function' && Number.isNaN(parseFloat(inputField.val())) ? min : parseFloat(inputField.val()),
				newInputValue;

			if (button.hasClass('edgtf-quantity-minus')) {
				minus = true;
			}

			if (minus) {
				newInputValue = inputValue - step;
				if (newInputValue >= 1) {
					inputField.val(newInputValue);
				} else {
					inputField.val(0);
				}
			} else {
				newInputValue = inputValue + step;
				if (max === undefined) {
					inputField.val(newInputValue);
				} else {
					if (newInputValue >= max) {
						inputField.val(max);
					} else {
						inputField.val(newInputValue);
					}
				}
			}

			inputField.trigger('change');
		});
	}

	/*
    ** Init select2 script for select html dropdowns
    */
	function edgtfInitSelect2() {
		var orderByDropDown = $('.woocommerce-ordering .orderby');
		if (orderByDropDown.length) {
			orderByDropDown.select2({
				minimumResultsForSearch: Infinity
			});
		}

		var variableProducts = $('.edgtf-woocommerce-page .edgtf-content .variations td.value select');
		if (variableProducts.length) {
			variableProducts.select2();
		}

		var shippingCountryCalc = $('#calc_shipping_country');
		if (shippingCountryCalc.length) {
			shippingCountryCalc.select2();
		}

		var shippingStateCalc = $('.cart-collaterals .shipping select#calc_shipping_state');
		if (shippingStateCalc.length) {
			shippingStateCalc.select2();
		}
	}

	/*
	 ** Init Product Single Pretty Photo attributes
	 */
	function edgtfInitSingleProductLightbox() {
		var item = $('.edgtf-woo-single-page.edgtf-woo-single-has-pretty-photo .images .woocommerce-product-gallery__image');

		if(item.length) {
			item.children('a').attr('data-rel', 'prettyPhoto[woo_single_pretty_photo]');

			if (typeof edgtf.modules.common.edgtfPrettyPhoto === "function") {
				edgtf.modules.common.edgtfPrettyPhoto();
			}
		}
	}

	/*
	 ** Init Product List Masonry Shortcode Layout
	 */
	function edgtfInitProductListMasonryShortcode() {
		var container = $('.edgtf-pl-holder.edgtf-masonry-layout .edgtf-pl-outer');

		if (container.length) {
			container.each(function () {
				var thisContainer = $(this);

				thisContainer.waitForImages(function () {
					thisContainer.isotope({
						itemSelector: '.edgtf-pli',
						resizable: false,
						masonry: {
							columnWidth: '.edgtf-pl-sizer',
							gutter: '.edgtf-pl-gutter'
						}
					});

					setTimeout(function () {
						if (typeof edgtf.modules.common.edgtfInitParallax === "function") {
							edgtf.modules.common.edgtfInitParallax();
						}
					}, 1000);

					thisContainer.isotope('layout').css('opacity', 1);
				});
			});
		}
	}

})(jQuery);