<?php
namespace EdgeCore\CPT\Shortcodes\PricingListItem;

use EdgeCore\Lib;

class PricingListItem implements Lib\ShortcodeInterface {
	private $base;
	
	function __construct() {
		$this->base = 'edgtf_pricing_list_item';
		add_action('vc_before_init', array($this, 'vcMap'));
	}
	
	public function getBase() {
		return $this->base;
	}
	
	public function vcMap() {
		vc_map( array(
			'name' => esc_html__('Edge Pricing List Item', 'edgtf-core'),
			'base' => $this->base,
			'icon' => 'icon-wpb-pricing-list-item extended-custom-icon',
			'category' => esc_html__('by EDGE', 'edgtf-core'),
			'allowed_container_element' => 'vc_row',
			'as_child' => array('only' => 'edgtf_pricing_list'),
			'params' => array(
				array(
					'type'        => 'attach_image',
					'param_name'  => 'image',
					'heading'     => esc_html__('Image', 'edgtf-core'),
				),
				array(
					'type'        => 'dropdown',
					'param_name'  => 'image_size',
					'heading'     => esc_html__('Select The Image Size', 'edgtf-core'),
					'value'       => array(
						esc_html__( 'Normal (100x100px)', 'edgtf-core' ) => 'normal',
						esc_html__( 'Small (66x66px)', 'edgtf-core' )    => 'small',
					),
					'dependency'  => array( 'element' => 'image', 'not_empty' => true ),
					'save_always' => true
				),
				array(
					'type'        => 'textfield',
					'param_name'  => 'title',
					'heading'     => esc_html__('Title', 'edgtf-core'),
				),
				array(
					'type'        => 'textfield',
					'param_name'  => 'description',
					'heading'     => esc_html__('Description', 'edgtf-core'),
				),
				array(
					'type'       => 'textfield',
					'param_name' => 'price',
					'heading'    => esc_html__('Price', 'edgtf-core')
				),
				array(
					'type'       => 'textfield',
					'param_name' => 'link',
					'heading'    => esc_html__('Title Link', 'edgtf-core'),
				),
				array(
					'type'        => 'dropdown',
					'param_name'  => 'target',
					'heading'     => esc_html__('Link Target', 'edgtf-core'),
					'value'       => array_flip(gastrobar_edge_get_link_target_array())
				),
				array(
					'type'        => 'dropdown',
					'param_name'  => 'active',
					'heading'     => esc_html__('Set this item as active', 'edgtf-core'),
					'value'       => array_flip(gastrobar_edge_get_yes_no_select_array(false, false))
				),
				array(
					'type'       => 'dropdown',
					'param_name' => 'active_color',
					'heading'    => esc_html__('Active Item Color Style', 'edgtf-core'),
					'value'       => array(
						esc_html__( 'Main Color', 'edgtf-core' )        => 'edgtf-pli-main-color',
						esc_html__( 'Our Custom Color', 'edgtf-core' )  => 'edgtf-pli-custom-color',
					),
					'save_always' => true
				),
				array(
					'type'        => 'dropdown',
					'param_name'  => 'transform',
					'heading'     => esc_html__('Title Transform', 'edgtf-core'),
					'value'       => array_flip(gastrobar_edge_get_text_transform_array(true))
				),
				array(
					'type'        => 'dropdown',
					'param_name'  => 'separator',
					'heading'     => esc_html__('Select The Separator Style', 'edgtf-core'),
					'value'       => array(
						esc_html__( 'Empty Space', 'edgtf-core' ) => 'edgtf-no-border',
						esc_html__( 'Dots', 'edgtf-core' )        => 'edgtf-pli-dots',
					),
					'save_always' => true
				),
				array(
					'type'       => 'colorpicker',
					'param_name' => 'color_title',
					'heading'    => esc_html__('Title Color', 'edgtf-core'),
					'group'      => 'Style'
				),
				array(
					'type'       => 'colorpicker',
					'param_name' => 'color_description',
					'heading'    => esc_html__('Description Color', 'edgtf-core'),
					'group'      => 'Style'
				),
				array(
					'type'       => 'colorpicker',
					'param_name' => 'color_price',
					'heading'    => esc_html__('Price Color', 'edgtf-core'),
					'group'      => 'Style'
				),
				array(
					'type'       => 'colorpicker',
					'param_name' => 'color_separator',
					'heading'    => esc_html__('Separator Color', 'edgtf-core'),
					'group'      => 'Style'
				),
			)
		));
	}

	public function render($atts, $content = null) {
		$args = array(
			'image'             => '',
			'image_size'        => '',
			'title'             => '',
			'description'       => '',
			'price'             => '',
			'link'              => '',
			'target'            => '_self',
			'active'            => 'no',
			'active_color'      => 'edgtf-pli-main-color',
			'transform'         => 'none',
			'separator'         => 'edgtf-no-border',
			'color_title'       => '',
			'color_description' => '',
			'color_price'       => '',
			'color_separator'   => ''
		);
		
		$params = shortcode_atts($args, $atts);

		$params['title_styles']     = $this->getPricingListItemTitleStyles($params);
		$params['desc_styles']      = $this->getPricingListItemDescStyles($params);
		$params['price_styles']     = $this->getPricingListItemPriceStyles($params);
		$params['separator_styles'] = $this->getPricingListItemSeparatorStyles($params);

		extract($params);

		$html = edgtf_core_get_shortcode_module_template_part('templates/pricing-list-item', 'pricing-list', '', $params);
		
		return $html;
	}

	private function getPricingListItemTitleStyles($params) {
		$styles = array();

		if(!empty($params['color_title'])) {
			$styles[] = 'color: '.$params['color_title'];
		}

		if(!empty($params['transform'])) {
			$styles[] = 'text-transform: '.$params['transform'];
		}

		return implode( ';', $styles );
	}

	private function getPricingListItemDescStyles($params) {
		$styles = array();

		if(!empty($params['color_description'])) {
			$styles[] = 'color: '.$params['color_description'];
		}

		return implode( ';', $styles );
	}

	private function getPricingListItemPriceStyles($params) {
		$styles = array();

		if(!empty($params['color_price'])) {
			$styles[] = 'color: '.$params['color_price'];
		}

		return implode( ';', $styles );
	}

	private function getPricingListItemSeparatorStyles($params) {
		$styles = array();

		if(!empty($params['color_separator'])) {
			$styles[] = 'border-color: '.$params['color_separator'];
		}

		return implode( ';', $styles );
	}
}