<div class="edgtf-pricing-list-item clearfix <?php echo empty($image) ? 'edgtf-pli-no-image' : ''; ?>">
	<?php if(!empty($image)){ ?>
		<div class="edgtf-pli-image-holder <?php echo 'small' === $image_size ? 'edgtf-image-small' : 'edgtf-image-normal'; ?>">
			<?php echo wp_get_attachment_image($image); ?>
		</div>
	<?php } ?>
	<div class="edgtf-pli-content clearfix">
		<?php if(!empty($title)): ?>
			<div class="edgtf-pli-title-holder">
				<h5 itemprop="name" class="edgtf-pli-title entry-title" <?php echo gastrobar_edge_get_inline_style($title_styles); ?>>
					<?php if(!empty($link)): ?><a itemprop="url" target="<?php echo esc_attr($target); ?>" href="<?php echo esc_url($link); ?>"><?php endif; ?>
						<?php echo esc_html($title); ?>
					<?php if(!empty($link)): ?></a><?php endif; ?>
					<?php if ( $active === 'yes' ) { ?>
						<span class="edgtf-pli-active <?php echo esc_attr($active_color); ?>"></span>
					<?php } ?>
				</h5>
				<div <?php gastrobar_edge_class_attribute($separator); ?> <?php gastrobar_edge_inline_style($separator_styles); ?>></div>
				<?php if(!empty($price)) : ?>
					<div class="edgtf-pli-price-holder">
						<h5 class="edgtf-pli-price" <?php echo gastrobar_edge_get_inline_style($price_styles); ?>>
							<span><?php echo esc_html($price); ?></span>
						</h5>
					</div>
				<?php endif; ?>
			</div>
		<?php endif; ?>
		<div class="edgtf-pli-bottom-content">
			<?php if(!empty($description)) : ?>
				<div class="edgtf-pli-desc clearfix" <?php echo gastrobar_edge_get_inline_style($desc_styles); ?>>
					<p><?php echo esc_html($description); ?></p>
				</div>
			<?php endif; ?>
		</div>
	</div>
</div>	