<div class="edgtf-team-holder <?php echo esc_attr($holder_classes); ?>">
	<div class="edgtf-team-inner">
		<?php if ($team_image !== '') { ?>
			<div class="edgtf-team-image">
				<?php if ($enable_image_frame === 'yes') { ?>
					<div class="edgtf-team-image-frame" <?php echo gastrobar_edge_get_inline_style($frame_styles); ?>></div>
                <?php } ?>
                <?php echo wp_get_attachment_image($team_image, 'full'); ?>
			</div>
		<?php } ?>
		<div class="edgtf-team-info">
			<?php if (!empty($team_name)) { ?>
				<<?php echo esc_attr($team_name_tag); ?> class="edgtf-team-name" <?php echo gastrobar_edge_get_inline_style($team_name_styles); ?>><?php echo esc_html($team_name); ?></<?php echo esc_attr($team_name_tag); ?>>
			<?php } ?>
			<?php if (!empty($team_position)) { ?>
				<<?php echo esc_attr($team_position_tag); ?> class="edgtf-team-position" <?php echo gastrobar_edge_get_inline_style($team_position_styles); ?>><?php echo esc_html($team_position); ?></<?php echo esc_attr($team_position_tag); ?>>
			<?php } ?>
			<?php if (!empty($team_desc)) { ?>
				<p class="edgtf-team-desc" <?php echo gastrobar_edge_get_inline_style($team_desc_styles); ?>><?php echo esc_html($team_desc); ?></p>
			<?php } ?>
			<div class="edgtf-team-social-wrapper" <?php echo gastrobar_edge_get_inline_style($overlay_styles); ?>>
				<div class="edgtf-team-social-outer">
					<div class="edgtf-team-social-inner">
						<?php if (!empty($team_social_icons)) { ?>
							<div class="edgtf-team-social-holder <?php echo esc_attr($team_social_classes) ?>">
								<?php foreach( $team_social_icons as $team_social_icon ) { ?>
									<span class="edgtf-team-icon"><?php echo wp_kses_post($team_social_icon); ?></span>
								<?php } ?>
							</div>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>