<?php
/*
template name:home page
*/

get_header();
$field = get_fields();
$themedata =  get_fields('options');
?>
<!-- banner starts -->
<div class="front-page">
    <?php if ($themedata['banner_bg_image']['url']) { ?>
        <div class="bg-img">
            <img src="<?php echo $themedata['banner_bg_image']['url'] ?>">
        </div>
    <?php } ?>
    <section class="banner banner-space margin-top-81">
        <div class="container">
            <div class="banner-content">
                <div class="row">
                    <div class="col-md-6">
                        <div class="banner-heading">
                            <h4>Become a Revenue-Focused Marketer</h4>
                            <?php if (!empty($field['banner_heading'])) { ?>
                                <h1><?php echo $field['banner_heading']; ?></h1>
                            <?php } ?>
                            <?php if (!empty($field['banner_description'])) { ?>
                                <p><?php echo $field['banner_description'] ?></p>
                            <?php } ?>
                            <?php if (!empty($field['banner_start_button']['url'])) { ?>
                                <a href="<?php echo $field['banner_start_button']['url'] ?>" target="<?php echo $field['banner_start_button']['target'] ?>" class="grad-button fill-btn-small"><?php echo $field['banner_start_button']['title'] ?>
                                </a>
                            <?php } ?>
                            <div class="normal-button">
                                <?php if (!empty($field['banner_video_button']['url'])) { ?>
                                    <a href="<?php echo $field['banner_video_button']['url'] ?>" target="<?php echo $field['banner_video_button']['target'] ?>" class="normal--button" data-bs-toggle="modal" data-bs-target="#exampleModal"><?php echo $field['banner_video_button']['title'] ?></a>
                                <?php } ?>
                                <?php if (!empty($field['banner_video_button_icon']['url'])) { ?>
                                    <img src="<?php echo $field['banner_video_button_icon']['url'] ?>" alt="<?php echo $field['banner_video_button_icon']['alt'] ?>" title="<?php echo $field['banner_video_button_icon']['title'] ?>">
                                <?php } ?>
                            </div>
                        </div>
                        <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>
                                    <div class="modal-body">
                                        <?php if (!empty($field['video_url'])) { ?>
                                            <iframe width="460" height="315" src="<?php echo $field['video_url'] ?>" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="banner-image">
                            <?php if ($field['banner_image_link']['url']) { ?>
                                <?php if (!empty($field['banner_image_link']['url'])) { ?>
                                    <lottie-player src="<?php echo $field['banner_image_link']['url'] ?>" style="width: 100%; height: 100%; transform: translate3d(0px, 0px, 0px);" background="transparent" speed="1" autoplay="true" loop="true"></lottie-player>
                                <?php }
                            } else { ?>
                                <img src="<?php echo $field['banner_image']['url'] ?>" alt="<?php echo $field['banner_image']['alt'] ?>" title="<?php echo $field['banner_image']['title'] ?>">
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- banner ends -->
    <section class="section-space bg-cvr trust-logo-upper" <?php if (!empty($themedata['background_image']['url'])) { ?> style="background-image: url(<?php echo $themedata['background_image']['url'] ?>);" <?php } ?>>
        <div class="container">
            <div class="row">
                <?php if (!empty($field['customer_logo_heading'])) { ?>
                    <div class="col-12 text-center">
                        <h2 class="custom-heading"><?php echo $field['customer_logo_heading'] ?></h2>
                    </div>
                <?php } ?>
                <div class="col-12">
                    <div class="support-logo">
                        <?php foreach ($field['customer_logos'] as $logo) { ?>
                            <?php if (!empty($logo['customer_logo']['url'])) { ?>
                                <div class="support-logo-box">
                                    <figure><img src="<?php echo $logo['customer_logo']['url'] ?>" alt="<?php echo $logo['customer_logo']['alt'] ?>"></figure>
                                </div>
                        <?php }
                        } ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="dig-services custom-space-top-bottom">
    <h2 class="d-md-none d-block section-heading">Products</h2>
        <div class="container">
            
            <?php foreach ($field['left_right_sections'] as $lr) { ?>
                <div class="row">
                    <div class="col-lg-6 col-md-6 col-12 d-md-inline-block d-none">
                        <div class="service-banner-image wow animate__animated  <?php echo $count % 2 == 0 ? 'animate__fadeInLeft' : 'animate__fadeInRight' ?>" data-wow-delay="0.3s">
                            <div class="service-image">
                                <?php if ($lr['lr_image_link']['url']) { ?>
                                    <?php if (!empty($lr['lr_image_link']['url'])) { ?>
                                        <lottie-player src="<?php echo $lr['lr_image_link']['url'] ?>" style="width: 100%; height: 100%; transform: translate3d(0px, 0px, 0px);" background="transparent" speed="1" autoplay="true" loop="true"></lottie-player>
                                    <?php }
                                } else { ?>
                                    <figure> <img src="<?php echo $lr['lr_image']['url'] ?>" alt="<?php echo $lr['lr_image']['alt'] ?>" title="<?php echo $lr['lr_image']['title'] ?>"> </figure>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-6 col-12">
                        <div class="service-content wow animate__animated <?php echo $count % 2 == 0 ? 'animate__fadeInRight' : 'animate__fadeInLeft' ?>" data-wow-delay="0.3s">
                            <?php if (!empty($lr['lr_heading'])) { ?>
                                <h5 class="service-small-text"><?php echo $lr['lr_heading'] ?></h5>
                            <?php } ?>
                            <?php if (!empty($lr['lr_subheading'])) { ?>
                                <h3 class="custom-service-heading"><?php echo $lr['lr_subheading'] ?></h3>
                            <?php } ?>
                            <?php if (!empty($lr['lr_description'])) { ?>
                                <p class="custom-service-info"><?php echo $lr['lr_description'] ?></p>
                            <?php } ?>
                            <?php if (!empty($lr['lr_link']['url'])) { ?>
                                <div class="service-btn">
                                    <a href="<?php echo $lr['lr_link']['url'] ?>" class="custom-service-btn"><?php echo $lr['lr_link']['title'] ?>
                                    </a>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            <?php $count++;
            } ?>
        </div>
    </section>
    <section class="custom-tabs-section">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <h2 class="d-md-none d-block section-heading">Solutions</h2>
                    <div class="accordian-mobile d-md-none d-block">
                        <div class="accordion" id="accordionExample">
                        <?php $count = 0; ?>
                            <?php foreach ($field['mobile_tabs_heading_and_desc'] as $key => $mobile) { ?>
                                <?php $count++ ?>
                                    <div class="accordion-item">
                                        <h2 class="accordion-header" id="heading-<?php echo $key + 1 ?>">
                                            <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-<?php echo $key + 1 ?>" aria-expanded="true" aria-controls="collapse-<?php echo $key + 1 ?>">
                                            <?php echo $mobile['mobile_heading']; ?>
                                            </button>
                                        </h2>
                                        <div id="collapse-<?php echo $key + 1 ?>" class="accordion-collapse collapse" aria-labelledby="heading-<?php echo $key + 1 ?>" data-bs-parent="#accordionExample">
                                            <div class="accordion-body">
                                            <?php echo $mobile['mobile_subheading']; ?>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>
                            <!-- <div class="accordion-item">
                                <h2 class="accordion-header" id="headingTwo">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                        Accordion Item #2
                                    </button>
                                </h2>
                                <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        <strong>This is the second item's accordion body.</strong> It is hidden by default, until the collapse plugin adds the appropriate classes that we use to style each element. These classes control the overall appearance, as well as the showing and hiding via CSS transitions. You can modify any of this with custom CSS or overriding our default variables. It's also worth noting that just about any HTML can go within the <code>.accordion-body</code>, though the transition does limit overflow.
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="headingThree">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                                        Accordion Item #3
                                    </button>
                                </h2>
                                <div id="collapseThree" class="accordion-collapse collapse" aria-labelledby="headingThree" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        <strong>This is the third item's accordion body.</strong> It is hidden by default, until the collapse plugin adds the appropriate classes that we use to style each element. These classes control the overall appearance, as well as the showing and hiding via CSS transitions. You can modify any of this with custom CSS or overriding our default variables. It's also worth noting that just about any HTML can go within the <code>.accordion-body</code>, though the transition does limit overflow.
                                    </div>
                                </div>
                            </div> -->
                        </div>
                    </div>
                    <div class="tabs-outer d-md-block d-none">
                        <ul class="nav nav-tabs" id="myTab" role="tablist">
                            <?php $count = 0;
                            foreach ($field['tabs'] as $key => $tab) {
                                $count++ ?>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link <?php if ($count == 1) {
                                                                echo 'active';
                                                            } ?>" id="<?php echo $tab['tabs_id']['url'] ?>-tab" data-bs-toggle="tab" data-bs-target="#<?php echo $tab['tabs_id']['url'] ?>" type="button" role="tab" aria-controls="<?php echo $tab['tabs_id']['url'] ?>" aria-selected="true"><?php echo $tab['tabs_heading'] ?></button>
                                </li>
                            <?php } ?>
                        </ul>
                        <div class="tab-content" id="myTabContent">
                            <?php foreach ($field['tabs'] as $key => $tab) {  ?>
                                <div class="tab-pane fade <?php if ($count == 1) {
                                                                echo ' show active';
                                                            } ?>" id="<?php echo $tab['tabs_id']['url'] ?>" role="tabpanel" aria-labelledby="<?php echo $tab['tabs_id']['url'] ?>-tab">
                                    <div class="tab-content">
                                        <div class="tab-content-outer">
                                            <h3><?php echo  $tab['tabs_title'] ?></h3>
                                            <p><?php echo  $tab['tabs_description'] ?></p>
                                            <?php if (!empty($tab['tabs_link']['url'])) { ?>
                                                <div class="service-btn">
                                                    <a href="<?php echo  $tab['tabs_link']['url'] ?>" class="custom-service-btn"><?php echo  $tab['tabs_link']['title'] ?>
                                                    </a>
                                                </div>
                                            <?php } ?>

                                        </div>
                                        <div class="tab-info-image">
                                            <?php if ($tab['tabs_image_link']['url']) { ?>
                                                <?php if (!empty($tab['tabs_image_link']['url'])) { ?>
                                                    <lottie-player src="<?php echo $tab['tabs_image_link']['url'] ?>" style="width: 100%; height: 100%; transform: translate3d(0px, 0px, 0px);" background="transparent" speed="1" autoplay="true" loop="true">
                                                    </lottie-player>
                                                <?php }
                                            } else { ?>
                                                <figure><img src="<?php echo  $tab['tabs_image']['url'] ?>" alt="<?php echo  $tab['tabs_image']['alt'] ?>"></figure>
                                            <?php } ?>
                                        </div>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Overview-Platform starts-->
        <section class="overview-platform d-none">
            <div class="container">
                <div class="overview-platform-heading">
                    <?php if (!empty($field['overview_heading'])) { ?>
                        <h2><?php echo $field['overview_heading'] ?></h2>
                    <?php } ?>
                    <?php if (!empty($field['overview_heading2'])) { ?>
                        <h3><?php echo $field['overview_heading2'] ?></h3>
                    <?php } ?>
                </div>

                <div class="overview-platform-content d-none">
                    <div class="row">
                        <?php foreach ($field['overview_platform_section'] as $val) {
                        ?>
                            <div class="col-md-4">
                                <div class="overview-platform-subheading">
                                    <?php if (!empty($val['overview_icon']['url'])) { ?>
                                        <img src="<?php echo $val['overview_icon']['url'] ?>" alt="<?php echo $val['overview_icon']['alt'] ?>" title="<?php echo $val['overview_icon']['title'] ?>">
                                    <?php } ?>
                                    <?php if (!empty($val['overview_heading'])) { ?>
                                        <h5><?php echo $val['overview_heading'] ?></h5>
                                    <?php } ?>
                                    <?php if (!empty($val['overview_description'])) { ?>
                                        <p><?php echo $val['overview_description']; ?></p>
                                    <?php } ?>
                                </div>
                            </div>

                        <?php } ?>
                    </div>
                </div>
        </section>
        <!-- Overview-Platform ends-->


        <!-- Got Any Questions? Reach Out! start -->
        <?php if (!empty($field['question_heading'])) { ?>
            <section class="questions d-none">
                <div class="container">
                    <div class="questions-content">
                        <div class="questions-subcontent">

                            <h2><?php echo $field['question_heading'] ?></h2>

                        </div>
                        <div class="questions-button">
                            <?php if (!empty($field['question_button']['url'])) { ?>
                                <a href="<?php echo $field['question_button']['url'] ?>" target="<?php echo $field['question_button']['target'] ?>" class="normalbutton"><?php echo $field['question_button']['title'] ?></a>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </section>
        <?php } ?>
        <!-- Got Any Questions? Reach Out! end -->
        <section class="ad-platform">
            <div class="custom-container">
                <div class="overview-platform-heading">
                    <?php if (!empty($field['carousel_main_heading'])) { ?> <h2>
                            <?php echo $field['carousel_main_heading'] ?></h2>
                    <?php } ?>
                    <?php if (!empty($field['carousel__main_subeading'])) { ?>
                        <p><?php echo $field['carousel__main_subeading'] ?></p>
                    <?php } ?>
                </div>
                <div class="ad-slider">
                    <div class="owl-carousel owl-theme home-carousel">
                        <?php foreach ($field['carousel_cards'] as $cval) { ?>
                            <div class="item">
                                <a href="<?php echo !empty($cval['carousel_link']['url']) ? $cval['carousel_link']['url'] : 'javascript:void(0)'; ?>" class="connector-link" target="<?php echo $cval['carousel_link']['target'] ?>">
                                    <div class="slide-box">
                                        <?php if (!empty($cval['carousel_image']['url'])) { ?>
                                            <div class="slidebox-img">
                                                <img src="<?php echo $cval['carousel_image']['url'] ?>" alt="<?php echo $cval['carousel_image']['alt'] ?>" title="<?php echo $cval['carousel_image']['alt'] ?>">
                                            </div>
                                        <?php } ?>
                                        <div class="slide-box-content">
                                            <?php if (!empty($cval['carousel_heading'])) { ?>
                                                <h5><?php echo $cval['carousel_heading'] ?>
                                                </h5>
                                            <?php } ?>
                                            <?php if (!empty($cval['carousel_subheading'])) { ?>
                                                <p><?php echo $cval['carousel_subheading'] ?>
                                                </p>
                                            <?php } ?>
                                        </div>
                                    </div>
                                </a>
                            </div>
                        <?php } ?>

                    </div>
                </div>
            </div>
        </section>
        <!-- Advertising Platforms ends-->
        <!-- Welcome to the Future of DIGG. ends -->
        <?php
        get_template_part('/includes/gradient', 'section', $field); ?>
        <?php
        get_footer();
        ?>