<?php
function style_code()
{
  // enqueue style
  wp_enqueue_style('animate css ', get_template_directory_uri() . '/assets/css/animate.min.css');
  wp_enqueue_style('bootstrap css', get_template_directory_uri() . '/assets/css/bootstrap.css');

  wp_enqueue_style('owl css ', get_template_directory_uri() . '/assets/css/owl.carousel.min.css');
  wp_enqueue_style('slick.min css ', get_template_directory_uri() . '/assets/css/slick-min.css"');
  wp_enqueue_style('slick theme css ', get_template_directory_uri() . '/assets/css/slick-theme.css');
  
  // if ( is_page_template('templates/datahygine.php') ) {
  // wp_enqueue_style('onepage css ', get_template_directory_uri() . '/assets/css/onepage-scroll.css');
  // }

  wp_enqueue_style('custom css ', get_template_directory_uri() . '/assets/css/style.css');
  wp_enqueue_style('custom-css-1', get_template_directory_uri() . '/assets/css/custom.css');
  wp_enqueue_style('custom-css-2', get_template_directory_uri() . '/assets/css/custom-2.css');
  // enqueue script
  wp_enqueue_script('jquery ', get_template_directory_uri() . '/assets/js/jquery.min.js');
  wp_enqueue_script('lottie js ', get_template_directory_uri() . '/assets/js/lottie.js');
  wp_enqueue_script('bootstrap js ', get_template_directory_uri() . '/assets/js/bootstrap.js');
  wp_enqueue_script('owl js ', get_template_directory_uri() . '/assets/js/owl.carousel.min.js');
  wp_enqueue_script('slick js ', get_template_directory_uri() . '/assets/js/slick.js');
  wp_enqueue_script('wow js ', get_template_directory_uri() . '/assets/js/wow.min.js');
  wp_enqueue_script('custom js ', get_template_directory_uri() . '/assets/js/custom.js',array(),'1.0.0',true);

}


add_action('wp_enqueue_scripts', 'style_code');


// function enqueue_parent_styles() {
//   wp_register_style('bootstrap css', get_template_directory_uri() . '/assets/css/bootstrap.css');
//    wp_enqueue_style('bootstrap css');
//    wp_register_style('custom css ', get_template_directory_uri() . '/assets/css/style.css');
//    wp_enqueue_style('custom css ');
//    wp_register_style('owl css ', get_template_directory_uri() . '/assets/css/owl.carousel.min.css' );
//    wp_enqueue_style('owl css ');
//      if ( is_page_template('templates/datahygine.php') ) {
//    wp_register_style('one page css ', get_template_directory_uri() . '/assets/css/onepage-scroll.css' );
//   }
//    wp_enqueue_style('one page css ');
 

// }
// add_action('wp_enqueue_scripts', 'enqueue_parent_styles');
// function load_js(){
//    wp_register_script('jquery ', get_template_directory_uri() . '/assets/js/jquery.min.js');
//    wp_enqueue_script('jquery');
//    wp_register_script('lottie js ', get_template_directory_uri() . '/assets/js/lottie.js');
//    wp_enqueue_script('lottie');
//    wp_register_script('bootstrap js ', get_template_directory_uri() . '/assets/js/bootstrap.js');
//    wp_enqueue_script('bootstrap js ');
//    wp_register_script('owl js ', get_template_directory_uri() . '/assets/js/owl.carousel.min.js');
//    wp_enqueue_script('owl js ');
//    if ( is_page_template('templates/datahygine.php') ) {
//    wp_register_script('fullpage js ', get_template_directory_uri() . '/assets/js/onepage-scroll.min.js');
//   }
//    wp_enqueue_script('fullpage js');

//    wp_register_script('custom js ', get_template_directory_uri() . '/assets/js/custom.js',array(),'1.0.0',true);
//    wp_enqueue_script('custom js');
// }
// add_action( 'wp_enqueue_scripts', 'load_js' );



// Allow SVG
// Wp v4.7.1 and higher
add_filter('wp_check_filetype_and_ext', function ($data, $file, $filename, $mimes) {
  $filetype = wp_check_filetype($filename, $mimes);
  return [
    'ext'             => $filetype['ext'],
    'type'            => $filetype['type'],
    'proper_filename' => $data['proper_filename']
  ];
}, 10, 4);

function cc_mime_types($mimes)
{
  $mimes['svg'] = 'image/svg+xml';
  return $mimes;
}
add_filter('upload_mimes', 'cc_mime_types');

function fix_svg()
{
  echo '<style type="text/css">
          .attachment-266x266, .thumbnail img {
               width: 100% !important;
               height: auto !important;
          }
          </style>';
}
add_action('admin_head', 'fix_svg');
//  end allow SVG


//   This function add class to li
function set_li_class($classes, $item, $args, $depth)
{
  $classes[] = 'nav-item';
  return $classes;
}


//add Theme setting link in wordpress 

if (function_exists('acf_add_options_page')) {
  acf_add_options_page(array(
    'page_title'  => 'Theme General Settings',
    'menu_title'  => 'Theme Settings',
    'menu_slug'   => 'theme-general-settings',
    'capability'  => 'edit_posts',
    'redirect'    => false
  ));
  acf_add_options_sub_page(array(
    'page_title'  => 'Theme Header Settings',
    'menu_title'  => 'Header',
    'parent_slug' => 'theme-general-settings',
  ));
  acf_add_options_sub_page(array(
    'page_title'  => 'Theme Footer Settings',
    'menu_title'  => 'Footer',
    'parent_slug' => 'theme-general-settings',
  ));
}

function my_login_logo_one()
{
?>
  <style type="text/css">
    body.login div#login h1 a {
      background-image: url(wp-content/uploads/2022/03/Group-2767-1.png);
      /* padding-bottom: 30px;  */
    }
  </style>
<?php
}
add_action('login_enqueue_scripts', 'my_login_logo_one');


add_filter('wp_image_editors', 'wpse303391_change_graphic_editor');
function wpse303391_change_graphic_editor($array)
{
  return array('WP_Image_Editor_GD', 'WP_Image_Editor_Imagick');
}





function cf7_add_custom_class($error)
{
  $error = str_replace("class=\"", "class=\"MyClass1 MyClass2 ", $error);
  return $error;
}
add_filter('wpcf7_validation_error', 'cf7_add_custom_class');


	
add_theme_support( 'post-thumbnails' );



add_action( 'init', 'ebook_custom_postType' );
function ebook_custom_postType() {
	$labels   = array(
		'name'               => _x( 'Ebooks', 'Post type general name', 'textdomain' ),
		'singular_name'      => _x( 'Ebook', 'Post type singular name', 'textdomain' ),
		'menu_name'          => _x( 'Ebooks', 'Admin Menu text', 'textdomain' ),
		'name_admin_bar'     => _x( 'Ebook', 'Add New on Toolbar', 'textdomain' ),
		'add_new'            => __( 'Add New', 'textdomain' ),
		'add_new_item'       => __( 'Add New Ebook', 'textdomain' ),
		'new_item'           => __( 'New Ebook', 'textdomain' ),
		'edit_item'          => __( 'Edit Ebook', 'textdomain' ),
		'view_item'          => __( 'View Ebook', 'textdomain' ),
		'all_items'          => __( 'All Ebooks', 'textdomain' ),
		'search_items'       => __( 'Search Ebooks', 'textdomain' ),
		'parent_item_colon'  => __( 'Parent Ebooks:', 'textdomain' ),
		'not_found'          => __( 'No Ebooks found.', 'textdomain' ),
		'not_found_in_trash' => __( 'No Ebook found in Trash.', 'textdomain' ),
	);
	$supports = array(
		'title', // post title
		'editor', // post content
		'author', // post author
		'thumbnail', // featured images
		'excerpt', // post excerpt
		'custom-fields', // custom fields
		'revisions', // post revisions
		'post-formats', // post formats
	);
	$args     = array(
		'labels'              => $labels,
		'supports'            => $supports,
		// give personal category and post_tag inside it instead of common to all posts
		'taxonomies'          => array( 'category', 'post_tag' ),
		'public'              => true,
		'publicly_queryable'  => true,
		'show_ui'             => true,
		'show_in_menu'        => true,
		'show_in_rest'        => true,
		'query_var'           => true,
		'capability_type'     => 'post',
		'has_archive'         => true,
		'hierarchical'        => false,//false = post, true = page
		'menu_position'       => null,
		'exclude_from_search' => 'false',
		'description'         => 'ebooks',
		'show_in_nav_menus'   => true,
		'show_in_admin_bar'   => true,
		'can_export'          => true,
		'rewrite' => array(
			'with_front' => false,
			'slug'       => 'ebook'
		)

	);
	register_post_type( 'ebooks', $args );
}

function fn_theme_supports()
{
	add_theme_support('title-tag');
  add_theme_support('custom-logo');
}

add_action('after_setup_theme', 'fn_theme_supports');

add_filter( 'get_custom_logo', 'change_logo_class' );

//add class to custom logo navbar start
function change_logo_class( $html ) {
    $html = str_replace( 'custom-logo', 'navbar-brand', $html );
    return $html;
}
//add class to custom logo navbar end

function add_upload_mimes( $types ) { 
	$types['json'] = 'text/plain';
	return $types;
}
add_filter( 'upload_mimes', 'add_upload_mimes' );


//for custom menues
function wpb_custom_new_menu()
{
	register_nav_menus(
		array(
			'digg-menu' => __('Digg Menu'),
			'extra-menu'          => __('Extra Menu'),
			'social-icons'        => __('social icons')
		)
	);
}

add_action('init', 'wpb_custom_new_menu');



// Add page name to body tag start 
add_filter( 'body_class', 'my_class_names' );
function my_class_names( $classes ) 
{
	global $post;
	
	// add 'post_name' to the $classes array 
	$classes[] = $post->post_name;
	// return the $classes array
	return $classes;
}
// Add page name to body tag end

?>