<?php
$themeData = get_fields('option');
$current_page = get_queried_object();
?>
<!DOCTYPE html>
<html>

<head>
  <!-- meta tags -->
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no">
  <!-- fontawesome start -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
  <!-- Start of HubSpot Embed Code -->
  <script type="text/javascript" id="hs-script-loader" async defer src="//js-eu1.hs-scripts.com/25106816.js"></script>
  <!-- End of HubSpot Embed Code -->
  <!-- Here is embed code for required Contact Us form -->
  <script charset="utf-8" type="text/javascript" src="//js-eu1.hsforms.net/forms/v2.js"></script>
  <!-- fontawesome ends -->
  <!-- Google Tag Manager -->
  <script>
    (function(w, d, s, l, i) {
      w[l] = w[l] || [];
      w[l].push({
        'gtm.start': new Date().getTime(),
        event: 'gtm.js'
      });
      var f = d.getElementsByTagName(s)[0],
        j = d.createElement(s),
        dl = l != 'dataLayer' ? '&l=' + l : '';
      j.async = true;
      j.src =
        'https://www.googletagmanager.com/gtm.js?id=' + i + dl;
      f.parentNode.insertBefore(j, f);
    })(window, document, 'script', 'dataLayer', 'GTM-W4JJ39D');
  </script>
  <!-- End Google Tag Manager -->
  <!-- Additionally, paste this code immediately after the opening -->


  <?php wp_head(); ?>
  </head>

  <body <?php body_class($current_page->post_name); ?>>
  
  <!-- Google Tag Manager (noscript) -->
  <noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-W4JJ39D" height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
  <!-- End Google Tag Manager (noscript) -->
    <!-- header starts -->
    <?php
    function yourprefix_get_menu_items($menu_name)
    {
      if (($locations = get_nav_menu_locations()) && isset($locations[$menu_name])) {
        $menu = wp_get_nav_menu_object($locations[$menu_name]);

        return wp_get_nav_menu_items($menu->term_id);
      }
    }
    $menu_array = yourprefix_get_menu_items('digg-menu');
    ?>
    <header>
      <nav class="navbar navbar-expand-lg  custom-nav-bar">
        <div class="container">
          <?php
          if (function_exists('the_custom_logo')) {
            the_custom_logo();
          }
          ?>
        <?php if (!empty($themeData['header_logo']['url'])) { ?>
          <a href="<?php echo site_url(); ?>" class="nav-brand-link"><img src="<?php echo $themeData['header_logo']['url'] ?>" alt="<?php echo $themeData['header_logo']['alt'] ?>" class="scroll-image"></a>
          <?php } ?>
          <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"> <i class="fa fa-bars" id="toggle_tst" aria-hidden="true" style="color: #fff"></i></span>
          </button>
          <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav">
              <?php
              foreach ($menu_array as $num => $menu_item) :
                $custom_menu = get_fields($menu_item->ID);
              ?>
                <?php
                if (have_rows('mega_menu_flexible', $menu_item->ID)) :
                  while (have_rows('mega_menu_flexible', $menu_item->ID)) :
                    the_row(); ?>
                    <?php
                    if (get_row_layout() == 'mega_menu_tab') :
                      $mega_menu_content = get_sub_field('mega_menu_content');
                      $tab_rep = get_sub_field('tab_item_repeater');
                    ?>
                      <li class="nav-item">
                        <a class="nav-link" aria-current="page" href="<?php echo !empty($menu_item->url) ? $menu_item->url : 'javascript:void(0)'; ?>"> <?php echo $menu_item->title; ?></a>
                          <i class="fa fa-angle-down" aria-hidden="true"></i>
                        <div class="dropdown-menu dropdown-large megamenu">
                          <div class="row">
                            <div class="col-md-2">
                              <figure class="menu-icon-drop"><img src="<?php echo $mega_menu_content['image']['url'] ?>" alt="growth"></figure>
                            </div>
                            <div class="col-md-10">
                              <div class="right-sub-menu">
                               
                               <?php echo $mega_menu_content['sub_title'] ?>
                              </div>
                            </div>
                            <div class="menu-item-drop-down">
                              <ul class="left-sub-menu">
                                <?php
                                foreach ($tab_rep as $key => $value) :
                                  $link_text = $value['item_link']['title'];
                                  $link = $value['item_link']['url'];
                                ?>
                                  <li class="drop-down-menu"><a href="<?php echo $link ?>"><?php echo $link_text ?></a></li>
                              <?php
                                endforeach;
                              endif; ?>
                          <?php
                        endwhile;
                      endif; ?>
                              </ul>

                            </div>
                          </div>
                        </div>
                      </li>
                    <?php
                  endforeach;
                    ?>
            </ul>
            <ul class="right-navbar">
              <!-- <a class="grad-button" href="#">Login</a> -->
              <?php if (!empty($themeData['login_button']['title'])) : ?>
	      <a class="grad-button" href="<?php echo isset($themeData['login_button']['url']) ? $themeData['login_button']['url'] : ''; ?>" target="<?php echo $themeData['login_button']['target'] ?>"><?php echo $themeData['login_button']['title'] ?></a>
                <script type="text/javascript" src="https://test.digg.ai/track.js?webtrack_id=4&user_id=10"></script>
            <?php endif; ?>
            </ul>
          </div>
        </div>
      </nav>
    </header>
    <!-- header ends -->
