<?php
$field = $args ?? [];


?>

    <!-- banner starts -->
    <section class="banner banner-space margin-top-81">
        <div class="container">
            <div class="banner-content">
                <div class="row">
                    <div class="col-md-6">
                        <div class="banner-image">
                            <?php if ($field['banner_image_link']['url']) { ?>
                            <?php if (!empty($field['banner_image_link']['url'])) { ?>
                            <lottie-player src="<?php echo $field['banner_image_link']['url'] ?>"
                                style="width: 100%; height: 100%; transform: translate3d(0px, 0px, 0px);"
                                background="transparent" speed="1" autoplay="true" loop="true"></lottie-player>
                            <?php }
                            } else { ?>
                            <img src="<?php echo $field['banner_image']['url'] ?>"
                                alt="<?php echo $field['banner_image']['alt'] ?>"
                                title="<?php echo $field['banner_image']['title'] ?>">
                            <?php } ?>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="banner-heading">
                            <?php if (!empty($field['banner_heading'])) { ?>
                            <div class="slider-outer">
                                <div class="sticky-text-slider">
                                    <h1><?php echo $field['banner_heading'] ?> <ul class="slider">
                                    <?php foreach ($field['banner_list_sliders'] as $list) { ?>
                                    <li><?php echo $list['banner_list'] ?> </li>
                                    <?php } ?>
                                </ul></h1>
                                </div>                                
                            </div>
                            <?php } ?>
                            <?php if (!empty($field['banner_desc'])) { ?>
                            <p><?php echo $field['banner_desc'] ?></p>
                            <?php } ?>
                            <?php if (!empty($field['banner_link']['url'])) { ?>
                            <a href="<?php echo $field['banner_link']['url'] ?>"
                                target="<?php echo $field['banner_link']['target'] ?>"
                                class="grad-button fill-btn-small"><?php echo $field['banner_link']['title'] ?>
                               </a>
                            <?php } ?>
                        </div>

                    </div>
                </div>
            </div>
            <!-- scroll down starts -->
            <div class="scroll-down" id="<?php echo $field['scroll_down_id'] ?>">
                <a href="#tabs" class="scrolly-centered">
                    <div class="scrollbtn scroll" id="scrollbtn">
                        <?php if (!empty($field['scroll_down_image']['url'])) { ?>
                        <img id="tabs" src="<?php echo $field['scroll_down_image']['url'] ?>"
                            alt="<?php echo $field['scroll_down_image']['alt'] ?>"
                            title="<?php echo $field['scroll_down_image']['title'] ?>">
                        <?php } ?>
                    </div>
                </a>
            </div>
            <!-- scrolldown ends -->
        </div>
    </section>
    <!-- banner ends -->
    <!-- Problems Faced By CMOs starts -->
    <section class="problems-faced">
        <div class="container">
            <div class="overview-platform-heading">
                <?php if (!empty($field['main_heading'])) { ?>
                <h2><?php echo $field['main_heading'] ?></h2>
                <?php } ?>
                <?php if (!empty($field['sub_heading'])) { ?>
                <p><?php echo $field['sub_heading'] ?></p>
                <?php } ?>
            </div>
            <div class="datahygine-content">
                <?php foreach ($field['left_right_repeater'] as $val) { ?>
                <div class="row">

                    <div class="col-lg-6">
                        <?php if (!empty($val['left_right_images']['url'])) { ?>
                        <div class="datahygine-photo ">
                        <?php if ($val['left_right_image_link']['url']) { ?>
                            <?php if (!empty($val['left_right_image_link']['url'])) { ?>
                            <lottie-player src="<?php echo $val['left_right_image_link']['url'] ?>"
                                style="width: 100%; height: 100%; transform: translate3d(0px, 0px, 0px);"
                                background="transparent" speed="1" autoplay="true" loop="true"></lottie-player>
                            <?php }
                            } else { ?>
                            <img src="<?php echo $val['left_right_images']['url'] ?>" alt="<?php echo $val['left_right_images']['alt'] ?>" title="<?php echo $val['left_right_images']['title'] ?>">
                            <?php } ?>
                        </div>
                        <?php } ?>
                    </div>
                    <div class="col-lg-6">
                        <div class="datahygine-text ">

                            <?php if (!empty($val['content_heading'])) { ?>
                            <h2><?php echo $val['content_heading'] ?>
                            </h2>
                            <?php } ?>
                            <?php if (!empty($val['content_subheading'])) { ?>
                            <p>
                                <?php echo $val['content_subheading'] ?>
                            </p>
                            <?php } ?>
                            <?php if (!empty($val['content_link']['url'])) { ?>
                            <a href="<?php echo $val['content_link']['url'] ?>"
                                class="grad-button"><?php echo $val['content_link']['title'] ?></a>
                            <?php } ?>
                        </div>
                    </div>

                </div>
                <?php } ?>
            </div>
        </div>
    </section>
    <!-- Problems Faced By CMOs ends -->