<?php
$field = get_fields();
$theme = get_fields('options');
?>

<style>
    .carousel-indicators {
        display: none;
    }

    @media (max-width:767px) {
        .carousel-indicators {
            display: block;
        }

    }
</style>
<!-- More Resources To Offer starts -->
<div class="more-resources">
    <div class="container">

        <div class="overview-platform-heading">
            <?php if (!empty($field['blog_heading'])) { ?>
                <h2><?php echo $field['blog_heading']; ?></h2>
            <?php } else {
            ?>
                <h2><?php echo $theme['blog_heading']; ?></h2>
            <?php
            }
            ?>
            <?php if (!empty($field['blog_subheading'])) { ?>
                <p><?php echo $field['blog_subheading']; ?></p>
            <?php } else {
            ?>
                <p><?php echo $theme['blog_subheading']; ?></p>
            <?php } ?>
        </div>


        <div class="more-resource-content">


            <div class="blog-carousel">
                <?php
                $wpb_all_query = new WP_Query(array(
                    'post_type'      => 'post',
                    'post_status'    => 'publish',
                    'posts_per_page' => 3,
                    'orderby'        => 'publish_time',
                    'order'          => 'desc'
                ));
                $count = true;
                $count2 = true;
                $i = 0;
                $myCount = $wpb_all_query->found_posts;
                ?>
                <div id="add-to-me">
                    <div class="carousel slide" data-bs-ride="carousel">
                        <div class="carousel-indicators">
                            <?php while ($wpb_all_query->have_posts()) : $wpb_all_query->the_post(); ?>
                                <button type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide-to="<?php echo $i ?>" class="<?php if ($count2) { {
                                                                                                                                                        echo "active";
                                                                                                                                                    }
                                                                                                                                                } ?>" aria-label="Slide 1"></button>
                                <?php $count2 = false;
                                $i++; ?>

                            <?php endwhile; ?>
                        </div>

                        <div class="carousel-inner row">
                            <?php if ($wpb_all_query->have_posts()) : ?>
                                <?php while ($wpb_all_query->have_posts()) : $wpb_all_query->the_post();
                                    $id          = get_the_id();
                                    $thumbnail   = wp_get_attachment_image_src(get_post_thumbnail_id($id), 'full');
                                    $thumbnail   = get_the_post_thumbnail();
                                    $image_id    = get_post_thumbnail_id($id);
                                    $image_title = get_the_title($image_id);
                                    $category    = get_the_category($id);
                                    $excerpt     = get_the_excerpt($id);
                                    $date        = get_the_date();

                                ?>

                                    <div class="col-lg-4 col-md-6 col-12 pp  <?php if ($count) {
                                                                                    echo "active";
                                                                                } ?>">
                                
                                            <?php $count = false; ?>


                                            <a href="<?php the_permalink(); ?>">

                                                <div class="blog-post-subcontent">
                                                    <div class="blog-post-content">
                                                        <?php

                                                        if (!empty($thumbnail)) :
                                                            echo "<figure>";
                                                            echo $thumbnail;
                                                            echo "</figure>";
                                                        ?>
                                                        <?php
                                                        else :
                                                        ?>
                                                            <figure>
                                                                <img class="no-preview" src="<?php echo get_site_url(); ?>/wp-content/uploads/2022/08/no-preview-1.png" alt="No Preview">
                                                            </figure>
                                                        <?php
                                                        endif;
                                                        ?>

                                                    </div>
                                                    <div class="blog-title-content">
                                                        <h4><?= esc_html(get_the_title()) ?></h4>
                                                        <p><?= esc_html($excerpt) ?></p>
                                                        <?php if (!empty($field['single_blog_link_text'])) { ?>
                                                            <a class="title-button" href="<?php the_permalink(); ?>"><?php echo $field['single_blog_link_text']; ?></a>
                                                        <?php } else { ?>
                                                            <a class="title-button" href="<?php the_permalink(); ?>"><?php echo $theme['single_blog_link_text']; ?></a>
                                                        <?php } ?>
                                                    </div>
                                                </div>
                                            </a>

                                    </div>

                            <?php
                                endwhile;
                            endif;
                            ?>

                        </div>
                    </div>
                </div>

            </div>


            <div class="service-btn">
                <?php if (!empty($field['blog_link']['url'])) { ?>
                    <a href="<?php echo $field['blog_link']['url']; ?>" class="custom-service-btn"><?php echo $field['blog_link']['title']; ?>
                    </a>
                <?php } else {
                ?>
                    <a href="<?php echo $theme['blog_link']['url']; ?>" class="custom-service-btn"><?php echo $theme['blog_link']['title']; ?>
                    </a>
                <?php } ?>
            </div>

        </div>
    </div>
</div>
<!-- More Resources To Offer ebds -->
<script>

</script>