<?php
/*Template Name: about us Template*/
/*Template Description: about us Template*/
get_header();
$field = get_fields();
$themedata = get_fields('options');
?>


<div class="about-us-page">
  <?php if (!empty($themedata['banner_bg_image']['url'])) { ?>
    <div class="bg-img">
      <img src="<?php echo $themedata['banner_bg_image']['url'] ?>" alt="<?php echo $themedata['banner_bg_image']['alt'] ?>">
    </div>
  <?php } ?>
  <!-- banner section starts -->
  <?php get_template_part('/includes/banner', 'section', $field); ?>
  <!-- banner section ends -->
<?php
 ?>
  <!-- meet our team starts -->
  <?php foreach ($field['tabs'] as $key => $tabs) { ?>
    <?php foreach ($tabs['tabs_cards'] as $keys => $tab_card) { 
  ?>
      <div class="modal fade modal-top" id="exampleModal-<?php echo $key; ?>-<?php echo $keys + 1 ?>" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog custom-modal-about modal-xl modal-lg modal-dialog-centered ">

          <div class="modal-content">
            <div class="modal-header">
              <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
              <div class="modal-outer">
                <div class="vector-image">
                <?php if (!empty($tab_card['member_image']['url'])) { ?>
                  <figure>
                    <img src="<?php echo $tab_card['member_image']['url'] ?>" alt="<?php echo $tab_card['member_image']['alt'] ?>">
                  </figure>
                  <?php } ?>
                </div>
                <div class="informaction-right">
                <?php if (!empty($tab_card['member_name'])) { ?>
                  <h3><?php echo $tab_card['member_name'] ?></h3>
                  <?php } ?>
                  <?php if (!empty($tab_card['member_designation'])) { ?>
                  <h5 class="position-in comp"><?php echo $tab_card['member_designation'] ?></h5>
                  <?php } ?>
                  <?php if (!empty($tab_card['member_bio_description'])) { ?>
                  <p><?php echo $tab_card['member_bio_description'] ?></p>
                  <?php } ?>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
  <?php }
  } ?>
  <section class="meet-our-team">
    <div class="container">
      <div class="overview-platform-heading">
        <h2><?php echo $field['tabs_heading'] ?></h2>
      </div>
      <div class="meet-our-team-tabs">

        <ul class="nav nav-tabs" id="myTab" role="tablist">

          <?php $count = 0;
          foreach ($field['tabs'] as $key => $tabs) {
            $count++;  ?>
            <li class="nav-item" role="presentation">
              <button class="nav-link <?php if ($count == 1) {
                                        echo "active";
                                      } ?>" id="<?php echo $tabs['card_id'] ?>" data-bs-toggle="tab" data-bs-target="#<?php echo $tabs['tabs_id'] ?>" type="button" role="tab" aria-controls="<?php echo $tabs['tabs_id'] ?>" aria-selected="true"><?php echo $tabs['tabs_name'] ?></button>
            </li>
          <?php } ?>
        </ul>
        <div class="tab-content" id="myTabContent">

          <?php $count = 0;
          foreach ($field['tabs'] as $key => $tabs) {
            $count++; ?>
            <div class="tab-pane fade <?php if ($count == 1) {
                                        echo "show active";
                                      } ?>" id="<?php echo $tabs['tabs_id'] ?>" role="tabpanel" aria-labelledby="<?php echo $tabs['card_id'] ?>" tabindex="0">
              <div class="team-members">
                <div class="row">
                  <?php foreach ($tabs['tabs_cards'] as $keys => $tab_card) { ?>
                    <div class="team-box">
                      <div class="team-member-content">
                        <div class="team-memeber-img">
                          <figure>
                            <img src="<?php echo $tab_card['member_image']['url'] ?>" alt="<?php echo $tab_card['member_image']['alt'] ?>">
                          </figure>
                          <div class="work-overlay">
                            <div class="overlay-button">
                            <?php if (!empty($tabs['modal_open_text'])) { ?>
                              <button type="button" class="btn" data-bs-toggle="modal" data-bs-target="#exampleModal-<?php echo $key; ?>-<?php echo $keys + 1 ?>">
                                <?php echo $tabs['modal_open_text'] ?>
                              </button>
                              <?php } ?>
                            </div>
                          </div>
                        </div>
                        <div class="team-info">
                        <?php if (!empty($tab_card['member_name'])) { ?>
                          <h5><?php echo $tab_card['member_name'] ?></h5>
                          <?php } ?>
                          <?php if (!empty($tab_card['member_designation'])) { ?>
                          <p><?php echo $tab_card['member_designation'] ?></p>
                          <?php } ?>
                        </div>
                      </div>
                    </div>
                  <?php } ?>
                </div>
              </div>
          
            </div>
            <?php } ?>
        </div>
      </div>
  </section>
  <!-- meet our team ends -->
  <!-- Our Values starts -->
  <section class="our-values">
    <div class="container">
      <div class="overview-platform-heading">
        <h2><?php echo $field['values_heading'] ?></h2>
      </div>
      <div class="our-values-content">
        <div class="row">
          <?php foreach ($field['values_cards'] as $value_card) { ?>
            <div class="col-lg-4 col-md-6 col-12">
              <div class="our-values-box">
              <?php if (!empty($value_card['value_image']['url'])) { ?>
                <figure>
                  <img src="<?php echo $value_card['value_image']['url'] ?>" alt="<?php echo $value_card['value_image']['alt'] ?>">
                </figure>
                <?php } ?>
                <?php if (!empty($value_card['vaue_heading'])) { ?>
                <h5><?php echo $value_card['vaue_heading'] ?></h5>
                <?php } ?>
                <div class="box-details">
                <?php if (!empty($value_card['value_subheading'])) { ?>
                  <p><?php echo $value_card['value_subheading'] ?></p>
                  <?php } ?>
                </div>
              </div>

            </div>
          <?php } ?>
        </div>
      </div>
    </div>
  </section>
  <!-- Our Values ends -->
  <!-- join our team starts -->
  <section class="join-our-team">
    <div class="container">
      <div class="team-content">
        <div class="team-photo">
        <?php if (!empty($field['join_team_image']['url'])) { ?>
          <img src="<?php echo $field['join_team_image']['url'] ?>" alt="<?php echo $field['join_team_image']['alt'] ?>">
          <?php } ?>
          <div class="team-text">
          <?php if (!empty($field['join_team_heading'])) { ?>
            <h4><?php echo $field['join_team_heading'] ?></h4>
            <?php } ?>
            <?php if (!empty($field['join_team_subheading'])) { ?>
            <p><?php echo $field['join_team_subheading'] ?></p>
            <?php } ?>
            <?php if (!empty($field['join_team_email_link'])) { ?>
            <a href="mailto:<?php echo $field['join_team_email_link'] ?>"><?php echo $field['join_team_email_text'] ?></a>
            <?php } ?>
          </div>
        </div>

      </div>
    </div>
  </section>
  <!-- join our team ends -->
  <!-- StillMaking starts-->
  <?php
  get_template_part('/includes/gradient', 'section', $field); ?>
  <!-- StillMaking ends-->
</div>
<?php get_footer()  ?>
</div>