<?php
/*
template name:connector
*/
$field = get_fields();
get_header();
?>
<style>
    .background {
        position: fixed;
        top: 0;
        left: 0;
        width: 50%;
        height: 100vh;
        z-index: 1;
    }

    .section {
        display: flex;
        min-height: 100vh;
        position: relative;
        z-index: 2;
    }

    .section>* {
        width: 50%;
    }

    .section__img {
        position: relative;
        display: flex;
        align-items: center;
    }

    .section__img__inner {
        height: 100vh;
        position: fixed;
        right: 10%;
        width: 40%;
        top: 0;
    }

    .section__body {
        display: flex;
        align-items: center;
        position: relative;
        z-index: 100;
    }

    .section__img__inner img {
        width: 100%;
        height: 100%;
        object-fit: contain;
    }

    .section__text {
        padding: 0vw;
    }

    .section__img__inner {
        filter: blur(30px);
        opacity: 0;
        background-position: 50% 40%;
        transition: filter 0.6s ease, opacity 0.6s ease, background-position 0.8s ease;
    }

    .section.active .section__img__inner {
        opacity: 1;
        background-position: 50% 50%;
        filter: blur(0);
    }

    .section__text h2 {
        font-size: 58px;
        line-height: 72px;
        margin-bottom: 10px;
        margin-top: 0;
        color: #fff;
    }

    .section__text p {
        color: #fff;
        font-size: 18px;
    }

    /* .background-blue-con {
        background-image: url(/wp-content/uploads/2022/11/Mask-Group-108.svg);

    } */
</style>
</style>
<div class="connector-page">
    <!----with effect -->
    <div class="background-blue-con" style="background-image:url('<?php echo $banner_data['connector_banner_bg_image']['url'] ?>') ;">
        <div class="outer-connector container">
            <?php foreach ($field['connector_banners'] as $banner_data) { ?>
                <div class="section <?php echo $banner_data['connector_banner_class'] ?>">
                    <div class="section__body">
                        <div class="section__text">
                            <?php if (!empty($banner_data['connector_banner_heading'])) { ?>
                                <h2><?php echo $banner_data['connector_banner_heading'] ?></h2>
                            <?php } ?>
                            <?php if (!empty($banner_data['connector_banner_subheading'])) { ?>
                                <p><?php echo $banner_data['connector_banner_subheading'] ?></p>
                            <?php } ?>
                        </div>
                    </div>
                    <div class="section__img">
                        <div class="section__img__inner">
                            <?php if ($banner_data['connector_banner_lottie']['url']) { ?>
                                <?php if (!empty($banner_data['connector_banner_lottie']['url'])) { ?>
                                    <lottie-player src="<?php echo $banner_data['connector_banner_lottie']['url'] ?>" style="width: 100%; height: 100%; transform: translate3d(0px, 0px, 0px);" background="transparent" speed="1" autoplay="true" loop="true"></lottie-player>
                                <?php }
                            } else { ?>
                                <img src="<?php echo $banner_data['connector_banner_image']['url'] ?>" alt="<?php echo $banner_data['connector_banner_image']['alt'] ?>" title="<?php echo $banner_data['connector_banner_image']['title'] ?>">
                            <?php } ?>
                        </div>
                    </div>

                </div>
            <?php } ?>

        </div>
    </div>
    <!--- end with effect section---->
    <!-- connector banner ends-->
    <!-- plug nd play starts -->
    <section class="plug-play" style="background-image: url(<?php echo $field['circle_bg_image']['url'] ?>);">
        <div class="container">
            <div class="connector-circle-content">
                <div class="row">
                    <?php foreach ($field['circle_lists'] as $list) { ?>
                        <div class="col-md-2">
                            <?php if (!empty($list['circle_list'])) { ?>
                                <p class="connecttor-circle"><?php echo $list['circle_list'] ?></p>
                            <?php } ?>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </section>
    <!-- plug nd play ends -->
    <!-- Advertising Platforms starts-->
    <section class="ad-platform" id="supported-platforms">
        <div class="custom-container">
            <div class="overview-platform-heading">
                <?php if (!empty($field['carousel_main_heading'])) { ?> <h2>
                        <?php echo $field['carousel_main_heading'] ?></h2>
                <?php } ?>
                <?php if (!empty($field['carousel__main_subeading'])) { ?>
                    <p><?php echo $field['carousel__main_subeading'] ?></p>
                <?php } ?>
            </div>
            <div class="ad-slider">
                <div class="owl-carousel owl-theme home-carousel">
                    <?php foreach ($field['carousel_cards'] as $cval) { ?>
                        <div class="item">
                            <div class="slide-box">
                                <?php if (!empty($cval['carousel_image']['url'])) { ?>
                                    <div class="slidebox-img">
                                        <img src="<?php echo $cval['carousel_image']['url'] ?>" alt="<?php echo $cval['carousel_image']['alt'] ?>" title="<?php echo $cval['carousel_image']['alt'] ?>">
                                    </div>
                                <?php } ?>
                                <div class="slide-box-content">
                                    <?php if (!empty($cval['carousel_heading'])) { ?>
                                        <h5><?php echo $cval['carousel_heading'] ?>
                                        </h5>
                                    <?php } ?>
                                    <?php if (!empty($cval['carousel_subheading'])) { ?>
                                        <p><?php echo $cval['carousel_subheading'] ?>
                                        </p>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>
                    <?php } ?>

                </div>
            </div>
        </div>
    </section>
    <!-- Advertising Platforms ends-->

    <!-- More Resources To Offer starts -->
    <?php get_template_part('/includes/recent', 'post', $currentPage); ?>
    <!-- More Resources To Offer ends -->

    <!-- StillMaking starts-->
    <?php
    get_template_part('/includes/gradient', 'section', $field); ?>
    <!-- StillMaking ends-->

</div>
<?php get_footer()  ?>
<script>
    // $(window).scroll(function() {

    // // selectors
    var $window = $(window),
        $body = $('body'),
        $panel = $('.section');

    // // Change 33% earlier than scroll position so colour is there when you arrive.
    // var scroll = $window.scrollTop() + ($window.height() / 3);

    //   $('.section').removeClass('active');
    //     console.log('scroll remove active');

    // $panel.each(function () {
    //   var $this = $(this);
    //   console.log( scroll , $this.position().top , $this.height() )
    //   // if position is within range of this panel.
    //   // So position of (position of top of div <= scroll position) && (position of bottom of div > scroll position).
    //   // Remember we set the scroll to 33% earlier in scroll var.
    //   if ($this.position().top <= scroll && $this.position().top + $this.height() > scroll) {
    //     $this.addClass('active');
    //   }
    // });    

    // }).scroll();


    $.fn.visible = function(partial) {

        var $t = $(this),
            $w = $(window),
            viewTop = $w.scrollTop(),
            viewBottom = viewTop + $w.height(),
            _top = $t.offset().top,
            _bottom = _top + $t.height(),
            compareTop = partial === true ? _bottom : _top,
            compareBottom = partial === true ? _top : _bottom;

        return ((compareBottom <= viewBottom) && (compareTop >= viewTop));

    };
    // el.visible(true) && el[0].offsetTop <= scroll && el[0].offsetTop + el[0].clientHeight > scroll

    $(window).scroll(function(event) {
        var scroll = $window.scrollTop() + ($window.height() / 3);
        $(".section").each(function(i, el) {
            var el = $(el);
            if (el.visible(true) && el[0].offsetTop <= scroll && el[0].offsetTop + el[0].clientHeight > scroll) {
                el.addClass("active");
                if (el[0].className == "section second active" && (el[0].offsetTop + el[0].clientHeight) - scroll < 400) {
                    el.removeClass("active");
                }
            } else {
                el.removeClass("active");
            }
        });
    });





    // $(window).scroll(function(){
    // 	 inViewport();
    //  });

    //  $(window).resize(function(){
    // 	 inViewport();
    //  });

    //  function inViewport(){
    //     console.log("function called");
    //      $('.section').removeClass('hello');
    // 	 $('.section').each(function(){
    // 		 var divPos = $(this).offset().top;
    //              topOfWindow = $(window).scrollTop();
    //              console.log("divPos"+ divPos);
    //              console.log("top of window"+topOfWindow);


    // 		 if( divPos < topOfWindow+400 ){
    // 			 $(this).addClass('hello');
    // 		 }
    // 	 });
    //  }
</script>
</div>