<?php
/*
template name:contact page
*/
get_header();
$field = get_fields();
?>
<div class="contact-us-page">
    <!-- form starts -->
    <section class="contact-us-form">
        <div class="container">
            <div class="contact-us-form-content">
                <div class="row">
                    <div class="col-md-6">
                        <div class="contact-left-content">
                            <h5><?php echo $field['form_heading'] ?></h5>
                            <div class="form-subcontent">
                                <script>
                                    hbspt.forms.create({
                                        region: "eu1",
                                        portalId: "25106816",
                                        formId: "84ae2d19-91c2-43b0-bc33-e0d46b20bc63"
                                    });
                                </script>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-right-content">
                            <div class="contact-left-content">
                                <h5><?php echo $field['contact_info_heading'] ?></h5>
                                <div class="right-subcontent">
                                    <?php foreach ($field['contact_info_repeater'] as $val) { ?>
                                        <div class="form-contact-info">

                                            <?php if (!empty($val['contact_info_icon'])) { ?>
                                                <img src="<?php echo $val['contact_info_icon']['url'] ?>" alt="<?php echo $val['contact_info_icon']['alt'] ?>" title="<?php echo $field['contact_info_icon']['title'] ?>">
                                            <?php } ?>
                                            <?php if (!empty($val['contact_info_detail'])) { ?>
                                                <?php echo $val['contact_info_detail'] ?>
                                            <?php } ?>
                                        </div>
                                    <?php } ?>

                                </div>
                                <div class="contact-map">
                                    <iframe src="<?php echo $field['map_url'] ?>" style="border:0;" allowfullscreen="" loading="lazy"></iframe>
                                </div>
                                <div class="contact-form-icons">
                                    <ul class="follow">
                                        <?php foreach ($field['contact_social_links'] as $val) { ?>
                                            <?php if (!empty($val['social_link'])) { ?>
                                                <li><a target="<?php echo $val['social_link']['target'] ?>" href="<?php echo $val['social_link']['url'] ?>">
                                                    <?php } ?>
                                                    <?php if (!empty($val['social_link_image'])) { ?>
                                                        <img src="<?php echo $val['social_link_image']['url'] ?>" alt="<?php echo $val['social_link_image']['alt'] ?>" title="<?php echo $val['social_link_image']['title'] ?>"></a>
                                                <?php } ?>
                                                </li>

                                            <?php } ?>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- form ends -->