<?php
/*
template name:data hygine
*/
get_header();
$field = get_fields();
$themedata = get_fields('options');
$currentPage = get_queried_object();
?>
<div class="data-hygine">
<?php if ($themedata['banner_bg_image']['url']) { ?>
    <div class="bg-img">
        <img src="<?php echo $themedata['banner_bg_image']['url'] ?>">
    </div>
    <?php } ?>
    <!-- banner starts -->
    <section class="banner banner-space margin-top-81">
        <div class="container">
            <div class="banner-content">
                <div class="row">
                    <div class="col-md-5">
                        <div class="banner-image">
                            <?php if ($field['banner_image_link']['url']) { ?>
                            <?php if (!empty($field['banner_image_link']['url'])) { ?>
                            <lottie-player src="<?php echo $field['banner_image_link']['url'] ?>"
                                style="width: 100%; height: 100%; transform: translate3d(0px, 0px, 0px);"
                                background="transparent" speed="1" autoplay="true" loop="true"></lottie-player>
                            <?php }
                            } else { ?>
                            <img src="<?php echo $field['banner_image']['url'] ?>" alt="banner-img" title="banner-img">
                            <?php } ?>
                        </div>
                    </div>
                    <div class="col-md-7">
                        <div class="banner-heading">
                            <?php if (!empty($field['banner_heading'])) { ?>
                            <h1><?php echo $field['banner_heading'] ?></h1>
                            <?php } ?>
                            <?php if (!empty($field['banner_desc'])) { ?>
                            <p><?php echo $field['banner_desc'] ?></p>
                            <?php } ?>
                            <?php if (!empty($field['banner_link']['url'])) { ?>
                            <a href="<?php echo $field['banner_link']['url'] ?>"
                                target="<?php echo $field['banner_link']['target'] ?>"
                                class="grad-button fill-btn-small"><?php echo $field['banner_link']['title'] ?>
                            </a>
                            <?php } ?>
                            <?php if (!empty($field['banner_video_link_text'])) { ?>
                            <div class="normal-button">
                                <a href="#" class="normal--button" data-bs-toggle="modal"
                                    data-bs-target="#exampleModal"><?php echo $field['banner_video_link_text'] ?></a>
                                <img class="normal--button" data-bs-toggle="modal" data-bs-target="#exampleModal"
                                    src="<?php echo $field['banner_video_button_icon']['url'] ?>"
                                    alt="<?php echo $field['banner_video_button_icon']['alt'] ?>">
                            </div>
                            <?php } ?>
                        </div>
                        <?php if (!empty($field['banner_video_link']['url'])) { ?>
                        <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel"
                            aria-hidden="true">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                                            aria-label="Close"></button>
                                    </div>
                                    <div class="modal-body">
                                        <iframe width="100%" height="315"
                                            src="<?php echo $field['banner_video_link']['url']; ?>"
                                            title="YouTube video player" frameborder="0"
                                            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                                            allowfullscreen></iframe>
                                    </div>

                                </div>
                            </div>
                        </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- banner ends -->

    <!-- Why Diggrowth For Data Hygiene? starts -->
    <?php $count = 1;   ?>
    <?php
    ?>
    <section class="datahygine">
        <div class="container">
            <div class="overview-platform-heading">
                <?php if (!empty($field['main_heading'])) { ?>
                <h2><?php echo $field['main_heading'] ?></h2>
                <?php } ?>
                <?php if (!empty($field['sub_heading'])) { ?>
                <p><?php echo $field['sub_heading'] ?></p>
                <?php } ?>
            </div>
            <div class="datahygine-content">
                <?php $i = 0;
                foreach ($field['left_right_repeater'] as $keyy => $val) {
                ?>
                <div class="row custom-scroll">
                    <div class="col-lg-6">
                        <div class="datahygine-photo wow animate__animated  <?php echo $count % 2 == 0 ? 'animate__fadeInRight' : 'animate__fadeInLeft' ?>"
                            data-wow-delay="0.3s">
                            <?php if ($val['left_right_image_link']['url']) { ?>
                            <?php if (!empty($val['left_right_image_link']['url'])) { ?>
                            <lottie-player src="<?php echo $val['left_right_image_link']['url'] ?>"
                                style="width: 100%; height: 100%; transform: translate3d(0px, 0px, 0px);"
                                background="transparent" speed="1" autoplay="true" loop="true"></lottie-player>
                            <?php }
                            } else { ?>
                            <img src="<?php echo $val['left_right_images']['url'] ?>" alt="<?php echo $val['left_right_images']['alt'] ?>" title="<?php echo $val['left_right_images']['title'] ?>">
                            <?php } ?>
                        </div>
                    </div>
                    <div class="col-lg-6 ">
                        <?php $i++ ?>
                        <div class="datahygine-text wow animate__animated <?php echo $count % 2 == 0 ? 'animate__fadeInLeft' : 'animate__fadeInRight' ?>"
                            data-wow-delay="0.3s">
                            <?php if (!empty($val['content_heading'])) { ?>
                            <h2><?php echo $val['content_heading'] ?>
                            </h2>
                            <?php } ?>
                            <?php if (!empty($val['content_subheading'])) { ?>
                            <p>
                                <?php echo $val['content_subheading'] ?>
                            </p>
                            <?php } ?>
                            <?php if (!empty($val['content_link']['url'])) { ?>
                            <a href="<?php echo $val['content_link']['url'] ?>"
                                class="grad-button"><?php echo $val['content_link']['title'] ?></a>
                            <?php } ?>
                        </div>
                    </div>
                </div>
                <?php $count++;
                } ?>
            </div>
        </div>
    </section>
    <!-- Why Diggrowth For Data Hygiene ends -->
    <!-- How It Works? starts -->
    <section class="how-it-works">
        <div class="container">

            <div class="overview-platform-heading">
                <?php if (!empty($field['work_heading'])) { ?>
                <h2><?php echo $field['work_heading'] ?></h2>
                <?php } ?>
                <?php if (!empty($field['work_subheading'])) { ?>
                <p><?php echo $field['work_subheading'] ?></p>
                <?php } ?>
            </div>
            <div class="row">
                <div class="col-lg-6">
                    <div class="accordion" id="accordionExample1">
                        <?php $count = 0;
                        foreach ($field['work_list_repeater'] as $key => $list) {
                            $count++; ?>
                        <div class="accordion-item">
                            <h2 class="accordion-header work-acc-head" id="heading-<?php echo $key + 1 ?>">
                                <button class="accordion-button <?php if ($count == 1) {
                                                                        echo '';
                                                                    } else {
                                                                        echo 'collapsed';
                                                                    } ?>" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#collapse-<?php echo $key + 1 ?>" aria-expanded="true"
                                    aria-controls="collapse-<?php echo $key + 1 ?>">
                                    <?php if (!empty($list['list_icon']['url'])) { ?>
                                    <img src="<?php echo $list['list_icon']['url'] ?>">
                                    <?php } ?>
                                    <?php if (!empty($list['list_heading'])) { ?>
                                    <h5 class="work_head"> <?php echo $list['list_heading'] ?></h5>
                                    <?php } ?>
                                </button>
                            </h2>
                            <div id="collapse-<?php echo $key + 1 ?>" class="accordion-collapse collapse <?php if ($count == 1) {
                                                                                                                    echo ' show';
                                                                                                                } ?>"
                                aria-labelledby="heading-<?php echo $key + 1 ?>" data-bs-parent="#accordionExample1">
                                <div class="accordion-body">
                                    
                                            <?php if (!empty($list['list_image']['url'])) { ?>
                                            <img src="<?php echo $list['list_image']['url'] ?>"
                                                alt="<?php echo $list['list_image']['alt'] ?>"
                                                title="<?php echo $list['list_image']['title'] ?>" class="img-fluid d-block d-lg-none">
                                            <?php } ?>
                                    <?php if (!empty($list['list_subheading'])) { ?>
                                    <p class="work-para" id="work-para-<?php echo $key + 1 ?>">
                                        <?php echo $list['list_subheading'] ?></p>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>

                        <?php } ?>
                    </div>
                </div>
                <div class="col-lg-6 d-none d-lg-inline-block">
                    <div class="custom-images">
                        <?php foreach ($field['work_list_repeater'] as $key => $list) { ?>
                        <div class="" id="img_<?php echo $key + 1 ?>">
                            <?php if (!empty($list['list_image']['url'])) { ?>
                            <img src="<?php echo $list['list_image']['url'] ?>"
                                alt="<?php echo $list['list_image']['alt'] ?>"
                                title="<?php echo $list['list_image']['title'] ?>">
                            <?php } ?>
                        </div>

                        <?php } ?>
                    </div>
                </div>

            </div>
        </div>
    </section>
    <!-- How It Works? ends -->
    <!-- Even More To Offer starts -->
    <?php if (!empty($field['offer_card_repeater'])) { ?>
    <section class="even-more-to offer">
        <div class="container">
            <div class="overview-platform-heading">
                <?php if (!empty($field['offer_heading'])) { ?>
                <h2><?php echo $field['offer_heading']; ?></h2>
                <?php } ?>
                <?php if (!empty($field['offer_subheading'])) { ?>
                <p><?php echo $field['offer_subheading']; ?></p>
                <?php } ?>
            </div>
            <div class="even-more-content">
                <div class="row">
                    <?php foreach ($field['offer_card_repeater'] as $valu) {
                        ?>
                    <div class="col-lg-6">
                        <?php if (!empty($valu['card_link']['url'])) { ?>
                        <a href="<?php echo $valu['card_link']['url'] ?>"
                            target="<?php echo $valu['card_link']['target'] ?>">
                            <div class="even-more-subcontent">
                                <h5><?php echo $valu['card_heading'] ?></h5>
                                <img src="<?php echo $valu['card_image']['url'] ?>"
                                    alt="<?php echo $valu['card_image']['alt'] ?>"
                                    title="<?php echo $valu['card_image']['title'] ?>">
                            </div>
                        </a>
                        <?php  } ?>
                    </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </section>
    <?php } ?>

    <!-- Even More To Offer ends -->
    <!-- More Resources To Offer starts -->
    <?php get_template_part('/includes/recent', 'post', $currentPage); ?>
    <!-- More Resources To Offer ends -->
    <!-- accordion section starts -->
    <section class="product-accordion">
        <div class="container">
            <div class="overview-platform-heading">
                <?php if (!empty($field['faqs_main_heading'])) { ?>
                <h2><?php echo $field['faqs_main_heading']; ?></h2>
                <?php } ?>
                <?php if (!empty($field['faqs_main_subheading'])) { ?>
                <p><?php echo $field['faqs_main_subheading']; ?></p>
                <?php } ?>
            </div>
            <div class="accordion" id="accordionExample2">
                <?php $count = 0; ?>
                <?php foreach ($field['faqs'] as $key => $faq_data) { ?>
                    <?php $count++ ?> 
                <div class="accordion-item">
                    <?php if (!empty($faq_data['faqs_heading'])) { ?>
                    <h5 class="accordion-header" id="headingg-<?php echo $key + 1 ?>">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapsee-<?php echo $key + 1 ?>" aria-expanded="true"
                            aria-controls="collapsee-<?php echo $key + 1 ?>">
                            <?php echo $faq_data['faqs_heading']; ?>
                        </button>
                    </h5>
                    <?php } ?>
                    <div id="collapsee-<?php echo $key + 1 ?>" class="accordion-collapse collapse"
                        aria-labelledby="headingg-<?php echo $key + 1 ?>" data-bs-parent="#accordionExample2">
                        <?php if (!empty($faq_data['faqs_subheading'])) { ?>
                        <div class="accordion-body">
                            <p> <?php echo $faq_data['faqs_subheading']; ?></p>
                        </div>
                        <?php }  ?>
                    </div>
                </div>
                <?php } ?>
            </div>
        </div>
</div>
</section>
<!-- accordion section ends -->
<!-- StillMaking starts-->
<?php
get_template_part('/includes/gradient', 'section', $field); ?>
<!-- StillMaking ends-->
</div>
<?php get_footer()  ?>