<?php
/*
template name:dummy-connector
*/
$field = get_fields();
get_header();
?>
<style>
html {
  line-height: 0;
}

.background {
  position: fixed;
  top: 0;
  left: 0;
  width: 50%;
  height: 100vh;
  z-index: 1;
}

.section {
  display: flex;
  min-height: 100vh;
  position: relative;
  z-index: 2;
}
.section > * {
  width: 50%;
}
.section__img {
  position: relative;
  display: flex;
      align-items: center;
}
.section__img__inner {
    height: 100vh;
    position: fixed;
    right: 10%;
    width: 40%;
    top: 0;
}
.section__body {
  display: flex;
  align-items: center;
  position: relative;
  z-index: 100;
}
.section__img__inner img {
    width: 100%;
    height: 100%;
    object-fit: contain;
}
.section__text {
  padding: 0vw;
}

.section__img__inner {
  filter: blur(30px);
  opacity: 0;
  background-position: 50% 40%;
  transition: filter 0.6s ease, opacity 0.6s ease, background-position 0.8s ease;
}

.section.active .section__img__inner {
  opacity: 1;
  background-position: 50% 50%;
  filter: blur(0);
}
lottie-player {
    --lottie-player-seeker-track-color: #e48509;
    --lottie-player-seeker-thumb-color: #ffcc00;
}
.section__text h2 {
    font-size: 58px;
    line-height: 72px;
  margin-bottom: 0.5em;
  margin-top: 0;
  color:#fff;
}
.section__text p{
    color:#fff;
    font-size:18px;
}
.background-blue-con{
    background-image: url(/wp-content/uploads/2022/11/Mask-Group-108.svg);

}
</style>


<div class="background-blue-con">
<div class="outer-connector container">
<div class="section active ">
<div class="section__body">
    <div class="section__text">
      <h2>Extract</h2>
      <p>Focus on insights and outcomes instead of data extraction with DiGGrowth’s custom connectors. Our plug-and-play connectors automate importing your data from your CRM, marketing automation platform, advertising platform, and more.</p>
    </div>
  </div>
  <div class="section__img">
    <div class="section__img__inner">
    <lottie-player src="https://digg.demandtech.org/wp-content/uploads/2022/11/data-4.json" style="width: 100%; height: 100%; transform: translate3d(0px, 0px, 0px);" background="transparent" speed="1" autoplay="true" loop=""></lottie-player>
    <!-- <img src="http://media.idownloadblog.com/wp-content/uploads/2014/10/iPad-mini-3-silver-side-by-side.png"> -->
    </div>
  </div>
  
</div>

<div class="section first">
<div class="section__body">
    <div class="section__text">
      <h2>Load</h2>
      <p>Speed up decision making with our connectors. DiGGrowth’s plug-and-play connectors load all your data to AWS S3 or any data warehouse of your choice like Amazon Redshift, Google BigQuery, MySQL, and mor</p>
    </div>
  </div>
  <div class="section__img">
    <div
      class="section__img__inner"
      style="background-image: url();"
    >
    <lottie-player src="https://digg.demandtech.org/wp-content/uploads/2022/11/data2-1-1.json" style="width: 100%; height: 100%; transform: translate3d(0px, 0px, 0px);" background="transparent" speed="1" autoplay="true" loop=""></lottie-player>
    <!-- <img src="http://wpuploads.appadvice.com/wp-content/uploads/2014/12/ipad-c4a63aad52bb1d69495bc2100e5f2026.png"> -->
    </div>
  </div>
  
</div>
<div class="section second">
<div class="section__body">
    <div class="section__text">
      <h2>Transform</h2>
      <p>Ensure data integrity with DiGGrowth’s custom connectors. Our connectors transform data and ensure consistency with source systems.</p>
    </div>
  </div>
  <div class="section__img">
     <div
      class="section__img__inner"
      >
      <lottie-player src="https://digg.demandtech.org/wp-content/uploads/2022/11/data3.json" style="width: 100%; height: 100%; transform: translate3d(0px, 0px, 0px);" background="transparent" speed="1" autoplay="true" loop=""></lottie-player>
    <!-- <img src="http://media.idownloadblog.com/wp-content/uploads/2014/10/iPad-mini-3-silver-side-by-side.png">- -->
    </div>
  </div>
</div>
</div>
</div>
 <!-- Advertising Platforms ends-->

    <!-- More Resources To Offer starts -->
    <?php get_template_part('/includes/recent', 'post', $currentPage); ?>
    <!-- More Resources To Offer ends -->

    <!-- StillMaking starts-->
    <?php
    get_template_part('/includes/gradient', 'section', $field); ?>
    <!-- StillMaking ends-->


<?php get_footer()  ?>

<script>
// $(window).scroll(function() {

// // selectors
var $window = $(window),
    $body = $('body'),
    $panel = $('.section');

// // Change 33% earlier than scroll position so colour is there when you arrive.
// var scroll = $window.scrollTop() + ($window.height() / 3);

//   $('.section').removeClass('active');
//     console.log('scroll remove active');

// $panel.each(function () {
//   var $this = $(this);
//   console.log( scroll , $this.position().top , $this.height() )
//   // if position is within range of this panel.
//   // So position of (position of top of div <= scroll position) && (position of bottom of div > scroll position).
//   // Remember we set the scroll to 33% earlier in scroll var.
//   if ($this.position().top <= scroll && $this.position().top + $this.height() > scroll) {
//     $this.addClass('active');
//   }
// });    

// }).scroll();


$.fn.visible = function(partial) {
    
    var $t            = $(this),
        $w            = $(window),
        viewTop       = $w.scrollTop(),
        viewBottom    = viewTop + $w.height(),
        _top          = $t.offset().top,
        _bottom       = _top + $t.height(),
        compareTop    = partial === true ? _bottom : _top,
        compareBottom = partial === true ? _top : _bottom;
  
  return ((compareBottom <= viewBottom) && (compareTop >= viewTop));

};
// el.visible(true) && el[0].offsetTop <= scroll && el[0].offsetTop + el[0].clientHeight > scroll

$(window).scroll(function(event) {
    var scroll = $window.scrollTop() + ($window.height() / 3);
    console.log("scroll"+scroll)
    $(".section").each(function(i, el) {
        var el = $(el);
        console.log(el)
        if (el.visible(true) && el[0].offsetTop <= scroll && el[0].offsetTop + el[0].clientHeight > scroll) {
            if(el[0].className =="section second active"){
                console.log("yesssss")
            }
            el.addClass("active"); 
        } else {
            el.removeClass("active");
        }
    });
});





// $(window).scroll(function(){
// 	 inViewport();
//  });

//  $(window).resize(function(){
// 	 inViewport();
//  });

//  function inViewport(){
//     console.log("function called");
//      $('.section').removeClass('hello');
// 	 $('.section').each(function(){
// 		 var divPos = $(this).offset().top;
//              topOfWindow = $(window).scrollTop();
//              console.log("divPos"+ divPos);
//              console.log("top of window"+topOfWindow);

		 
// 		 if( divPos < topOfWindow+400 ){
// 			 $(this).addClass('hello');
// 		 }
// 	 });
//  }
</script>