<?php
/*
template name: ebook
*/
get_header();
$field = get_fields();
$themeData = get_fields('option');
?>

<div class="resource-page">
    <!-- blogs starts -->
    <section class="blogs">
        <div class="container">
            <div class="blog-content">
                <div class="row">
                    <?php get_template_part('/includes/resource', 'side-bar', $currentPage); ?>
                    <div class="col-lg-9 col-12">
                        <div class="blog-tab-content">
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="blog-carousel">
                                        <?php
                                        $wpb_all_query = new WP_Query(array(
                                            'post_type' => 'ebooks',
                                            'post_status' => 'publish',
                                            'posts_per_page' => 3,
                                            'orderby' => 'publish_time',
                                            'order' => 'desc',
                                        ));
                                        $count = true;
                                        $count2 = true;
                                        $i = 0;
                                        $myCount = $wpb_all_query->found_posts;
                                        ?>
                                        <div id="carouselExampleIndicators" class="carousel slide"
                                            data-bs-ride="carousel">
                                            <div class="carousel-indicators">
                                                <?php while ($wpb_all_query->have_posts()) : $wpb_all_query->the_post(); ?>
                                                <button type="button" data-bs-target="#carouselExampleIndicators"
                                                    data-bs-slide-to="<?php echo $i ?>"
                                                    class="<?php if ($count2) {
                                                                                                                                                                        echo "active";
                                                                                                                                                                    } ?>"
                                                    aria-current="true" aria-label="Slide 1"></button>
                                                <?php $count2 = false;
                                                    $i++; ?>
                                                <?php endwhile; ?>
                                            </div>
                                            <div class="carousel-inner">

                                                <?php //if ($wpb_all_query->have_posts()) : 
                                                foreach ($field['feature_posts'] as $cd) {
                                                ?>
                                                <!-- loop -->
                                                <?php if ($wpb_all_query->have_posts()) : $wpb_all_query->the_post();
                                                        $featurepost = $cd['feature_post'];
                                                        $pid = $featurepost->ID;
                                                        $ebook_link = get_field('ebook_link', $pid);
                                                        $featuredTitle = get_the_title($pid);
                                                        $thumbnail = wp_get_attachment_image_src(get_post_thumbnail_id($pid), 'full');
                                                        $thumbnail = get_the_post_thumbnail();
                                                        $image_id = get_post_thumbnail_id($pid);
                                                        $image_title = get_the_title($image_id);
                                                        $category = get_the_category($pid);
                                                        $excerpt    = get_the_excerpt($pid);
                                                        $excerpt = substr($excerpt, 0, 200);
                                                        $permalinkk = get_the_permalink($pid);
                                                        $date = get_the_date();

                                                    ?>
                                                <!-- loop -->
                                                <div class="carousel-item <?php if ($count) {
                                                                                        echo "active";
                                                                                    } ?>">
                                                    <?php $count = false; ?>
                                                    <div class="blog-heading-content">
                                                        <figure>
                                                            <?php
                                                                    if (!empty($thumbnail)) :
                                                                        echo $thumbnail;
                                                                    else :
                                                                    ?>
                                                            <img class="no-preview"
                                                                src="<?php echo get_site_url(); ?>/wp-content/uploads/2022/08/no-preview-1.png"
                                                                alt="No Preview">
                                                            <?php
                                                                    endif;
                                                                    ?>
                                                        </figure>

                                                        <div class="blog-heading-text">
                                                            <h6><?= $featuredTitle; ?></h6>
                                                            <p><?= esc_html($excerpt) ?>
                                                            </p>
                                                            <a class="title-button" data-bs-toggle="modal"
                                                                data-bs-target="#exampleModal1"
                                                                href="<?php echo $ebook_link['url']; ?>">Download
                                                                Now</a>
                                                        </div>
                                                    </div>
                                                    <div class="modal fade" id="exampleModal1" data-bs-backdrop="static"
                                                        data-bs-keyboard="false" tabindex="-1"
                                                        aria-labelledby="staticBackdropLabel" aria-hidden="true">
                                                        <div class="modal-dialog">
                                                            <div class="modal-content">
                                                                <div class="modal-close">
                                                                    <button type="button" class="btn-close"
                                                                        data-bs-dismiss="modal"
                                                                        aria-label="Close"></button>
                                                                </div>
                                                                <div class="modal-body">
                                                                    <div class="modal-body">
                                                                        <div class="row">
                                                                            <div class="col-md-6">
                                                                                <div class="pop-uo-img">
                                                                                    <?php if (!empty($themeData['ebook_form_image']['url'])) { ?>
                                                                                    <img src="<?php echo $themeData['ebook_form_image']['url'] ?>"
                                                                                        alt="<?php echo $themeData['ebook_form_image']['alt'] ?>"
                                                                                        title="<?php echo $themeData['ebook_form_image']['title'] ?>">
                                                                                    <?php } ?>
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-md-6">
                                                                                <div class="pop-up-form">
                                                                                    <?php if (!empty($themeData['ebook_form_heading'])) { ?>
                                                                                    <h5><?php echo $themeData['ebook_form_heading'] ?>
                                                                                    </h5>
                                                                                    <?php } ?>
                                                                                    <!-- <p> Enter your email address below
                                                                                        and get this eBook delivered
                                                                                        straight to your inbox</p> -->
                                                                                    <script charset="utf-8"
                                                                                        type="text/javascript"
                                                                                        src="//js-eu1.hsforms.net/forms/v2.js">
                                                                                    </script>
                                                                                    <script>
                                                                                    hbspt.forms.create({
                                                                                        region: "eu1",
                                                                                        portalId: "25106816",
                                                                                        formId: "ad93beca-f676-44d6-91b0-6db78479a4d9",
                                                                                        version: "V2_PRERELEASE",
                                                                                        onFormSubmit: function(
                                                                                            $forms) {
                                                                                            var a = document
                                                                                                .createElement(
                                                                                                    "a");
                                                                                            a.href =
                                                                                                "<?php echo  $ebook_link['url'] ?>";
                                                                                            a.download =
                                                                                                "<?php echo  $ebook_link['title'] ?>";
                                                                                            a.target =
                                                                                                "_blank",
                                                                                                a.click();
                                                                                        }
                                                                                    });
                                                                                    </script>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>

                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <?php

                                                    endif;
                                                }
                                                ?>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php
                                $paged     = (get_query_var('paged')) ? get_query_var('paged') : 1;
                                $args      = array(
                                    'paged'          => $paged,
                                    'post_type'      => 'ebooks',
                                    'post_status'    => 'publish',
                                    'posts_per_page' => 9,
                                    'order'          => 'desc',
                                );
                                $the_query = new WP_Query($args);
                                ?>
                                <?php
                                wp_reset_postdata();
                                if ($the_query->have_posts()) :
                                    while ($the_query->have_posts()) :
                                        $the_query->the_post();
                                        $postID     = get_the_id();
                                        $ebook_link = get_field('ebook_link', $postID);
                                        $postTitle  = get_the_title($postID);
                                        $thumbnail  = get_the_post_thumbnail();
                                        $categories = get_the_category($postID);
                                        $excerpt    = get_the_excerpt($postID);
                                        $excerpt    = substr($excerpt, 0, 260);
                                        $date       = get_the_date('M j, Y', $postID);
                                        $author     = get_the_author($postID);
                                        $postType = get_post_type_object(get_post_type());

                                ?>
                                <div class="col-lg-4 col-md-6 col-12">
                                    <div class="blog-post-subcontent">
                                        <div class="blog-post-content">
                                            <figure>
                                                <?php
                                                        if (!empty($thumbnail)) :
                                                            echo $thumbnail;
                                                        else :
                                                        ?>
                                                <img class="no-preview"
                                                    src="<?php echo get_site_url(); ?>/wp-content/uploads/2022/08/no-preview-1.png"
                                                    alt="No Preview">
                                                <?php
                                                        endif;
                                                        ?>
                                            </figure>
                                            <div class="blog-post-white-text">
                                                <div class="blog-post-white-text-left-text">
                                                    <h6><?php if ($postType) {
                                                                    echo esc_html($postType->labels->singular_name);
                                                                } ?></h6>
                                                </div>
                                                <div class="blog-post-white-text-right-text">
                                                    <i class="fa fa-calendar-o" aria-hidden="true"></i>
                                                    <h6><?php echo esc_html($date) ?></h6>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="blog-title-content">
                                            <h4><?php echo esc_html($postTitle) ?></h4>
                                            <p><?php echo esc_html($excerpt) ?>...</p>
                                            <input type="hidden" id="pdf-download"
                                                value="<?php echo $ebook_link['url'] ?>">
                                            <a class="title-button show" data-bs-toggle="modal"
                                                data-bs-target="#exampleModal" href="#">Download Now</a>

                                        </div>


                                        <div class="modal fade" id="exampleModal" data-bs-backdrop="static"
                                                        data-bs-keyboard="false" tabindex="-1"
                                                        aria-labelledby="staticBackdropLabel" aria-hidden="true">
                                                        <div class="modal-dialog">
                                                            <div class="modal-content">
                                                                <div class="modal-close">
                                                                    <button type="button" class="btn-close"
                                                                        data-bs-dismiss="modal"
                                                                        aria-label="Close"></button>
                                                                </div>
                                                                <div class="modal-body">
                                                                    <div class="modal-body">
                                                                        <div class="row">
                                                                            <div class="col-md-6">
                                                                                <div class="pop-uo-img">
                                                                                    <?php if (!empty($themeData['ebook_form_image']['url'])) { ?>
                                                                                    <img src="<?php echo $themeData['ebook_form_image']['url'] ?>"
                                                                                        alt="<?php echo $themeData['ebook_form_image']['alt'] ?>"
                                                                                        title="<?php echo $themeData['ebook_form_image']['title'] ?>">
                                                                                    <?php } ?>
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-md-6">
                                                                                <div class="pop-up-form">
                                                                                    <?php if (!empty($themeData['ebook_form_heading'])) { ?>
                                                                                    <h5><?php echo $themeData['ebook_form_heading'] ?>
                                                                                    </h5>
                                                                                    <?php } ?>
                                                                                    <!-- <p> Enter your email address below
                                                                                        and get this eBook delivered
                                                                                        straight to your inbox</p> -->
                                                                                    <script charset="utf-8"
                                                                                        type="text/javascript"
                                                                                        src="//js-eu1.hsforms.net/forms/v2.js">
                                                                                    </script>
                                                                                    <script>
                                                                                    hbspt.forms.create({
                                                                                        region: "eu1",
                                                                                        portalId: "25106816",
                                                                                        formId: "ad93beca-f676-44d6-91b0-6db78479a4d9",
                                                                                        version: "V2_PRERELEASE",
                                                                                        onFormSubmit: function(
                                                                                            $forms) {
                                                                                            var a = document
                                                                                                .createElement(
                                                                                                    "a");
                                                                                            a.href =
                                                                                                "<?php echo  $ebook_link['url'] ?>";
                                                                                            a.download =
                                                                                                "<?php echo  $ebook_link['title'] ?>";
                                                                                            a.target =
                                                                                                "_blank",
                                                                                                a.click();
                                                                                        }
                                                                                    });
                                                                                    </script>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>

                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                    </div>
                                </div>

                                <?php
                                    endwhile;
                                else :
                                    ?>
                                <div class="alert alert-info text-center w-100 mb-0">
                                    <p>There Are No Posts Under This Category </p>
                                </div>
                                <?php
                                endif;
                                ?>
                            </div>
                        </div>
                    </div>
                    <!--pagination-->
                    <div class="pagination-outer">
                        <div class="pagination">
                            <?php
                            $big = 999999999;
                            echo paginate_links(array(
                                'base'      => str_replace($big, '%#%', esc_url(get_pagenum_link($big))),
                                'format'    => '?paged=%#%',
                                'current'   => max(1, get_query_var('paged')),
                                'total'     => $the_query->max_num_pages,
                                'prev_text' => '<i class="fa fa-angle-left" aria-hidden="true"></i>',
                                'next_text' => '<i class="fa fa-angle-right" aria-hidden="true"></i>'
                            ));

                            ?>
                        </div>
                    </div>
                    <!--pagination ends-->
                </div>
    </section>
    <!-- blogs endss -->
    <!-- StillMaking starts-->
    <section class="stillmaking">
        <div class="stillmaking-content">
            <?php if (!empty($field['lottie_heading'])) { ?>
            <h2><?php echo $field['lottie_heading'] ?></h2>
            <?php } ?>
            <?php if (!empty($field['lottie_subheading'])) { ?>
            <p><?php echo $field['lottie_subheading']; ?></p>
            <?php } ?>
            <?php if (!empty($field['lottie_button_link']['url'])) { ?>
            <a href="<?php echo $field['lottie_button_link']['url']; ?>"
                target="<?php echo $field['lottie_button_link']['target']; ?>"><?php echo $field['lottie_button_link']['title']; ?></a>
            <?php } ?>
        </div>
        <div class="lotti-abimation">
            <lottie-player src="<?php echo $field['lottie_image']['url'] ?>"
                style="width: 100%; height: 100%; transform: translate3d(0px, 0px, 0px);" background="transparent"
                speed="1" autoplay="true" loop="true"></lottie-player>
        </div>
    </section>
    <!-- StillMaking ends-->



    <?php get_footer()  ?>