<?php
/*
template name:faq page
*/
get_header();
$themedata = get_fields('options');
$field = get_fields();
?>
<div class="faq-page">
<div class="bg-img">
<?php if ($field['faq_bg_image']['url']) { ?>
    <img src="<?php echo $field['faq_bg_image']['url'] ?>" alt="<?php echo $field['faq_bg_image']['alt'] ?>"></div>
    <?php } ?>
        <!-- faq banner starts -->
        <section class="banner  banner-space margin-top-81">
            <div class="container">
                <div class="banner-content">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="banner-image">
                            <?php if ($field['banner_image_link']['url']) { ?>
                                <?php if (!empty($field['banner_image_link']['url'])) { ?>
                                    <lottie-player src="<?php echo $field['banner_image_link']['url'] ?>" style="width: 100%; height: 100%; transform: translate3d(0px, 0px, 0px);" background="transparent" speed="1" autoplay="true" loop="true"></lottie-player>
                                <?php }
                            } else { ?>
                                <img src="<?php echo $field['banner_image']['url'] ?>" alt="<?php echo $field['banner_image']['alt'] ?>" title="<?php echo $field['banner_image']['title'] ?>">
                            <?php } ?>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="banner-heading">
                            <?php if (!empty($field['banner_heading'])) { ?>
                                <h1><?php echo $field['banner_heading'] ?></h1>
                            <?php } ?>
                            <?php if (!empty($field['banner_desc'])) { ?>
                                <p><?php echo $field['banner_desc'] ?></p>
                            <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- faq banner starts -->
        <!-- faq section starts -->
        <section class="faq-details">
            <div class="container">
                <div class="faq-blog-details-contents" >
                    <div class="row">
                        <div class="col-lg-3">
                            <div class="table-of-content faq-navigation">
                            <h3><?php echo $themedata['single_page_blog_content_heading'] ?></h3>
                                <ul class="table-list"  >
                                <?php $i=0 ?>
                                    <?php foreach ($field['faq_content_headings'] as $counts => $val) { ?>                              
                                        <li><a href="#scroll-<?php echo $counts+1 ?>"  class="nav-link faq-nav-link "><i class="fa fa-check" aria-hidden="true" ></i>     
                                        <?php if (!empty($val['content_heading'])) { ?>                                
                                                <p><?php echo $val['content_heading'] ?></p>
                                                <?php } ?>
                                            </a></li>
                                    <?php }   ?>
                                  
                                </ul>
                            </div>
                            
                        </div>
                        <div class="col-lg-8">
                            <div class="faq-main-content">
                            <?php foreach ($field['faq_content'] as $count2 => $faq_contents) { ?>
                                <div class="faq-left-content">
                                    <h4 id="scroll-<?php echo $count2+1 ?>"><?php echo $faq_contents['faq_heading'] ?></h4>
                                    <div class="accordion" id="accordionExample">                       
                                    <?php $count = 0;
                                    foreach ($faq_contents['faqs'] as $key => $faqs) { 
                                        $count++;?>
                                        <div class="accordion-item">
                                            <h5 class="accordion-header" id="heading-<?php echo $key + 1 ?>">
                                                <button class="accordion-button <?php if($count == 1){echo ''; }else {echo 'collapsed'; } ?>" type="button"
                                                    data-bs-toggle="collapse" data-bs-target="#collapse-<?php echo $key + 1 ?>"
                                                    aria-expanded="true" aria-controls="collapse-<?php echo $key + 1 ?>">
                                                    <?php if (!empty($faqs['faqs_question'])) { ?> 
                                                   <?php echo $faqs['faqs_question'] ?>
                                                   <?php } ?>
                                                </button>
                                            </h5>
                                            <div id="collapse-<?php echo $key + 1 ?>" class="accordion-collapse-data collapse  <?php if($count == 1){echo ' show';} ?>"
                                                aria-labelledby="heading-<?php echo $key + 1 ?>" data-bs-parent="#accordionExample">
                                                <?php if (!empty($faqs['faqs_answer'])) { ?> 
                                                <div class="accordion-body">
                                                    <p>   <?php echo $faqs['faqs_answer'] ?></p>
                                                </div>
                                                <?php } ?>
                                            </div>
                                        </div>
                                        <?php }  $i++; ?>
                                    </div>
                                </div>
                                <?php } ?>
                            </div> 
                        </div>                 
                    </div>
                </div>
            </div>
    </section>
<!-- faqsection ends -->
    <!-- StillMaking starts-->
    <?php
    get_template_part('/includes/gradient', 'section', $field); ?>
    <!-- StillMaking ends-->
</div>
</div>
<?php get_footer()  ?>  